/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;

@Immutable
public final class ElapsedTime
implements Serializable,
Comparable<ElapsedTime> {
    public static final ElapsedTime EMPTY = new ElapsedTime(0L);
    public static final ElapsedTime HOUR;
    public static final ElapsedTime INFINITY;
    public static final String INFINITY_STRING = "Infinity";
    public static final ElapsedTime INVALID;
    public static final ElapsedTime MICRO;
    public static final ElapsedTime MILLI;
    public static final ElapsedTime MINUTE;
    public static final ElapsedTime SECOND;
    private static final long _HOUR_RAW = 36000000000L;
    private static final long _INVALID_RAW = Long.MIN_VALUE;
    private static final long _INFINITY_RAW = Long.MAX_VALUE;
    private static final long _MICRO_RAW = 10L;
    private static final long _MILLI_RAW = 10000L;
    private static final long _MINUTE_RAW = 600000000L;
    private static final long _SECOND_RAW = 10000000L;
    private static final long serialVersionUID = 1L;
    private static final Pattern _SECONDS_PATTERN;
    private static final Pattern _ELAPSED_PATTERN;
    private static final Pattern _DURATION_PATTERN;
    private final long _raw;

    private ElapsedTime(long raw) {
        this._raw = raw;
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromDataInput(@Nonnull DataInput source) throws IOException {
        long raw = source.readLong();
        return raw == INVALID.toRaw() ? INVALID : ElapsedTime._fromRaw(raw);
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromDuration(Duration duration) {
        long secondsRaw = duration.getSeconds() * 10000000L;
        return ElapsedTime.fromRaw(secondsRaw + (long)(duration.getNano() / 100));
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromMillis(long millis) {
        return ElapsedTime._fromRaw(millis * 10000L);
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromNanos(long nanos) {
        return ElapsedTime._fromRaw(nanos / 100L);
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromRaw(long raw) {
        return ElapsedTime._fromRaw(raw);
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromSeconds(double seconds) {
        double raw = Math.abs(seconds) * 1.0E7;
        return ElapsedTime._fromRaw(raw < 9.223372036854776E18 ? (long)raw : Long.MAX_VALUE);
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ElapsedTime> fromString(@Nonnull Optional<String> string) {
        if (!string.isPresent()) {
            return Optional.empty();
        }
        String elapsedString = string.get().trim();
        if (elapsedString.isEmpty() || elapsedString.charAt(0) == '-') {
            return Optional.empty();
        }
        return Optional.of(ElapsedTime.fromString(elapsedString));
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime fromString(@Nonnull String elapsedString) {
        if (elapsedString.equalsIgnoreCase(INFINITY_STRING)) {
            return INFINITY;
        }
        Matcher matcher = _ELAPSED_PATTERN.matcher(elapsedString);
        if (matcher.matches()) {
            return ElapsedTime._fromElapsedMatcher(matcher);
        }
        matcher = _SECONDS_PATTERN.matcher(elapsedString);
        if (matcher.matches()) {
            return ElapsedTime._fromSecondsMatcher(matcher);
        }
        matcher = _DURATION_PATTERN.matcher(elapsedString);
        if (matcher.matches()) {
            return ElapsedTime._fromDurationMatcher(matcher);
        }
        throw new IllegalArgumentException(Message.format(BaseMessages.ELAPSED_FORMAT, elapsedString));
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime max(@Nonnull Collection<ElapsedTime> elapsedTimes) {
        Require.failure(elapsedTimes.isEmpty());
        ElapsedTime max = EMPTY;
        for (ElapsedTime elapsedTime : elapsedTimes) {
            max = max.max(Optional.ofNullable(elapsedTime));
        }
        return max;
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime max(ElapsedTime ... elapsedTimes) {
        Require.success(elapsedTimes.length > 0);
        ElapsedTime max = EMPTY;
        for (ElapsedTime elapsedTime : elapsedTimes) {
            max = max.max(Optional.ofNullable(elapsedTime));
        }
        return max;
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime min(@Nonnull Collection<ElapsedTime> elapsedTimes) {
        Require.failure(elapsedTimes.isEmpty());
        ElapsedTime min = INFINITY;
        for (ElapsedTime elapsedTime : elapsedTimes) {
            min = min.min(Optional.ofNullable(elapsedTime));
        }
        return min;
    }

    @Nonnull
    @CheckReturnValue
    public static ElapsedTime min(ElapsedTime ... elapsedTimes) {
        Require.success(elapsedTimes.length > 0);
        ElapsedTime min = INFINITY;
        for (ElapsedTime elapsedTime : elapsedTimes) {
            min = min.min(Optional.ofNullable(elapsedTime));
        }
        return min;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<ElapsedTime> readExternal(@Nonnull ObjectInput source) throws IOException {
        ElapsedTime elapsedTime = ElapsedTime.fromDataInput(source);
        return elapsedTime.isInvalid() ? Optional.empty() : Optional.of(elapsedTime);
    }

    public static void writeExternal(@Nonnull Optional<ElapsedTime> elapsedTime, @Nonnull ObjectOutput destination) throws IOException {
        (elapsedTime.isPresent() ? elapsedTime.get() : INVALID).toDataOutput(destination);
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime add(@Nonnull ElapsedTime other) {
        if (this.isInfinity() || other.isInfinity()) {
            return INFINITY;
        }
        return ElapsedTime._fromRaw(this._raw + other._raw);
    }

    @Override
    public int compareTo(@Nonnull ElapsedTime other) {
        return this._raw < other._raw ? -1 : (this._raw > other._raw ? 1 : 0);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ElapsedTime) {
            return this._raw == ((ElapsedTime)other)._raw;
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime floor(@Nonnull ElapsedTime whole) {
        return this.floor(whole.toRaw());
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime floor(long whole) {
        return ElapsedTime._fromRaw(this.isInfinity() ? Long.MAX_VALUE : this._raw / whole);
    }

    public int hashCode() {
        return (int)(this._raw ^ this._raw >>> 32);
    }

    @CheckReturnValue
    public boolean isEmpty() {
        return this._raw == 0L;
    }

    @CheckReturnValue
    public boolean isInfinity() {
        return this._raw == Long.MAX_VALUE;
    }

    @CheckReturnValue
    public boolean isInvalid() {
        return this == INVALID;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime max(@Nonnull Optional<ElapsedTime> other) {
        if (!other.isPresent()) {
            return INFINITY;
        }
        return this.compareTo(other.get()) > 0 ? this : other.get();
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime min(@Nonnull Optional<ElapsedTime> other) {
        if (!other.isPresent()) {
            return this;
        }
        return this.compareTo(other.get()) < 0 ? this : other.get();
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime mul(double factor) {
        return ElapsedTime.fromRaw((long)((double)this._raw * factor));
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime mul(long factor) {
        return ElapsedTime.fromRaw(this._raw * factor);
    }

    @CheckReturnValue
    public double ratio(@Nonnull ElapsedTime divisor) {
        if (divisor.isInfinity()) {
            return this.isInfinity() ? Double.NaN : Double.MIN_VALUE;
        }
        if (this.isInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)this._raw / (double)divisor._raw;
    }

    @CheckReturnValue
    public double scaled(@Nonnull ElapsedTime whole) {
        return this.scaled(whole.toRaw());
    }

    @CheckReturnValue
    public double scaled(long whole) {
        return this.isInfinity() ? Double.POSITIVE_INFINITY : (double)this._raw / (double)whole;
    }

    @Nonnull
    @CheckReturnValue
    public ElapsedTime sub(@Nonnull ElapsedTime other) {
        return this.isInfinity() ? this : (other.isInfinity() ? EMPTY : ElapsedTime._fromRaw(this._raw - other._raw));
    }

    public void toDataOutput(@Nonnull DataOutput destination) throws IOException {
        destination.writeLong(this._raw);
    }

    @Nonnull
    @CheckReturnValue
    public Duration toDuration() {
        return Duration.ofSeconds(this._raw / 10000000L, this._raw % 10000000L * 100L);
    }

    @Nonnull
    @CheckReturnValue
    public String toDurationString() {
        StringBuilder stringBuilder = new StringBuilder("P");
        long raw = this._raw;
        int integer = (int)(raw / 864000000000L);
        if (integer > 0) {
            stringBuilder.append(integer);
            raw -= (long)(integer * 24) * 36000000000L;
            stringBuilder.append('D');
        }
        if (raw > 0L) {
            stringBuilder.append('T');
            integer = (int)(raw / 36000000000L);
            if (integer > 0) {
                stringBuilder.append(integer);
                raw -= (long)integer * 36000000000L;
                stringBuilder.append('H');
            }
            if ((integer = (int)(raw / 600000000L)) > 0) {
                stringBuilder.append(integer);
                raw -= (long)integer * 600000000L;
                stringBuilder.append('M');
            }
            if (raw > 0L) {
                integer = (int)(raw / 10000000L);
                stringBuilder.append(integer);
                if ((raw -= (long)integer * 10000000L) > 0L) {
                    stringBuilder.append('.');
                    stringBuilder.append(DateTime.Context.nanosToString((int)(raw * 100L)));
                }
                stringBuilder.append('S');
            }
        }
        if (stringBuilder.length() == 1) {
            stringBuilder.append("0D");
        }
        return stringBuilder.toString();
    }

    @Nonnegative
    @CheckReturnValue
    public long toMillis() {
        return this.isInfinity() ? Long.MAX_VALUE : this._raw / 10000L;
    }

    @Nonnegative
    @CheckReturnValue
    public long toRaw() {
        return this._raw;
    }

    @Nonnegative
    @CheckReturnValue
    public double toSeconds() {
        return this.isInfinity() ? 9.223372036854776E18 : (double)this._raw / 1.0E7;
    }

    public String toString() {
        if (this.isInfinity()) {
            return INFINITY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder("P");
        stringBuilder.append((int)(this._raw / 864000000000L));
        stringBuilder.append('T');
        stringBuilder.append(DateTime.Context.formatNumber((int)(this._raw / 36000000000L % 24L), 2));
        stringBuilder.append(':');
        stringBuilder.append(DateTime.Context.formatNumber((int)(this._raw / 600000000L % 60L), 2));
        int seconds = (int)(this._raw / 10000000L % 60L);
        int nanos = (int)(this._raw % 10000000L * 100L);
        if (seconds > 0 || nanos > 0) {
            stringBuilder.append(':');
            stringBuilder.append(DateTime.Context.formatNumber(seconds, 2));
            if (nanos > 0) {
                stringBuilder.append('.');
                stringBuilder.append(DateTime.Context.nanosToString(nanos));
            }
        }
        return stringBuilder.toString();
    }

    private static ElapsedTime _fromDurationMatcher(Matcher matcher) {
        long raw = 0L;
        String string = matcher.group(_DurationGroup.DAYS.group());
        raw += string != null ? (long)(Integer.parseInt(string) * 24) * 36000000000L : 0L;
        string = matcher.group(_DurationGroup.HOURS.group());
        raw += string != null ? (long)Integer.parseInt(string) * 36000000000L : 0L;
        string = matcher.group(_DurationGroup.MINUTES.group());
        raw += string != null ? (long)Integer.parseInt(string) * 600000000L : 0L;
        string = matcher.group(_DurationGroup.SECONDS.group());
        raw += string != null ? (long)Integer.parseInt(string) * 10000000L : 0L;
        string = matcher.group(_DurationGroup.NANOS.group());
        return ElapsedTime._fromRaw(raw += string != null ? (long)(DateTime.Context.nanosFromString(string) / 100) : 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ElapsedTime _fromElapsedMatcher(Matcher matcher) {
        long raw;
        String string = matcher.group(_ElapsedGroup.DAYS.group());
        if (string != null) {
            int integer = Integer.parseInt(string);
            if (matcher.group(_ElapsedGroup.PERIOD.group()) == null && matcher.group(_ElapsedGroup.SEPARATOR.group()) == null) return new ElapsedTime((long)integer * 10000L);
            raw = (long)(integer * 24) * 36000000000L;
        } else {
            raw = 0L;
        }
        raw += (string = matcher.group(_ElapsedGroup.HOURS.group())) != null ? (long)Integer.parseInt(string) * 36000000000L : 0L;
        string = matcher.group(_ElapsedGroup.MINUTES.group());
        raw += string != null ? (long)Integer.parseInt(string) * 600000000L : 0L;
        string = matcher.group(_ElapsedGroup.SECONDS.group());
        raw += string != null ? (long)Integer.parseInt(string) * 10000000L : 0L;
        string = matcher.group(_ElapsedGroup.NANOS.group());
        return new ElapsedTime(raw += string != null ? (long)(DateTime.Context.nanosFromString(string) / 100) : 0L);
    }

    private static ElapsedTime _fromRaw(long raw) {
        return new ElapsedTime((raw = Math.abs(raw)) >= 0L ? raw : Long.MAX_VALUE);
    }

    private static ElapsedTime _fromSecondsMatcher(Matcher matcher) {
        long raw = (long)Integer.parseInt(matcher.group(_SecondsGroup.SECONDS.group())) * 10000000L;
        return new ElapsedTime(raw += (long)(DateTime.Context.nanosFromString(matcher.group(_SecondsGroup.NANOS.group())) / 100));
    }

    static {
        _SECONDS_PATTERN = Pattern.compile("([0-9]++)[.]([0-9]+)");
        _ELAPSED_PATTERN = Pattern.compile("(P)?(?:([0-9]++)(?:(T|_|-|[ ]+)|$))??(?:([0-9]++):([0-9]++)(?::([0-9]++)(?:[.]([0-9]+))?)?)?", 2);
        _DURATION_PATTERN = Pattern.compile("P(?:([0-9]+)D)?T?(?:([0-9]+)H)?(?:([0-9]+)M)?(?:([0-9]++)(?:[.]([0-9]))?S)?", 2);
        HOUR = new ElapsedTime(36000000000L);
        INFINITY = new ElapsedTime(Long.MAX_VALUE);
        INVALID = new ElapsedTime(Long.MIN_VALUE);
        MICRO = new ElapsedTime(10L);
        MILLI = new ElapsedTime(10000L);
        MINUTE = new ElapsedTime(600000000L);
        SECOND = new ElapsedTime(10000000L);
    }

    private static enum _SecondsGroup {
        SECONDS,
        NANOS;


        int group() {
            return this.ordinal() + 1;
        }
    }

    private static enum _ElapsedGroup {
        PERIOD,
        DAYS,
        SEPARATOR,
        HOURS,
        MINUTES,
        SECONDS,
        NANOS;


        int group() {
            return this.ordinal() + 1;
        }
    }

    private static enum _DurationGroup {
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        NANOS;


        int group() {
            return this.ordinal() + 1;
        }
    }
}

