/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.Attributes;
import org.rvpf.base.Content;
import org.rvpf.base.Entity;
import org.rvpf.base.Origin;
import org.rvpf.base.Params;
import org.rvpf.base.PointRelation;
import org.rvpf.base.UUID;
import org.rvpf.base.store.Store;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.filter.ValueFilter;

public interface Point
extends Entity {
    public static final String ARCHIVE_TIME_PARAM = "ArchiveTime";
    public static final String CAPTURE_LIMIT_PARAM = "CaptureLimit";
    public static final String CAPTURE_TIME_PARAM = "CaptureTime";
    public static final String CEILING_GAP_PARAM = "CeilingGap";
    public static final String CEILING_RATIO_PARAM = "CeilingRatio";
    public static final String CONFIRM_PARAM = "Confirm";
    public static final String DEADBAND_GAP_PARAM = "DeadbandGap";
    public static final String DEADBAND_RATIO_PARAM = "DeadbandRatio";
    public static final String FAIL_RETURNS_NULL_PARAM = "FailReturnsNull";
    public static final String FILTER_PARAM = "Filter";
    public static final String FILTER_STAMP_TRIM_UNIT_PARAM = "FilterStampTrimUnit";
    public static final String FILTER_TIME_LIMIT_PARAM = "FilterTimeLimit";
    public static final String FLOOR_GAP_PARAM = "FloorGap";
    public static final String FLOOR_RATIO_PARAM = "FloorRatio";
    public static final String KEEP_AT_LEAST_PARAM = "KeepAtLeast";
    public static final String KEEP_AT_MOST_PARAM = "KeepAtMost";
    public static final String LIFE_TIME_PARAM = "LifeTime";
    public static final String NOTIFY_PARAM = "Notify";
    public static final Point NULL = new Named("");
    public static final String NULL_REMOVES_PARAM = "NullRemoves";
    public static final String PARAM_PARAM = "Param";
    public static final String POLATOR_PARAM = "Polator";
    public static final String POLATOR_TIME_LIMIT_PARAM = "PolatorTimeLimit";
    public static final String RECALC_LATEST_PARAM = "RecalcLatest";
    public static final String REPLICATED_PARAM = "Replicated";
    public static final String RESPECT_VERSION_PARAM = "RespectVersion";
    public static final String RESYNCHRONIZED_PARAM = "Resynchronized";
    public static final String STATES_PARAM = "States";
    public static final String STEP_SIZE_PARAM = "StepSize";
    public static final String TAG_PARAM = "Tag";
    public static final String VOLATILE_PARAM = "Volatile";

    @Nonnull
    @CheckReturnValue
    public ValueFilter filter();

    @Nonnull
    @CheckReturnValue
    public Optional<Content> getContent();

    @Nonnull
    @CheckReturnValue
    public List<? extends PointRelation> getInputs();

    @CheckReturnValue
    public int getLevel();

    @Nonnull
    @CheckReturnValue
    public Optional<? extends Origin> getOrigin();

    @Nonnull
    @CheckReturnValue
    public Params getParams();

    @Nonnull
    @CheckReturnValue
    public List<Replicate> getReplicates();

    @Nonnull
    @CheckReturnValue
    public List<? extends PointRelation> getResults();

    @Nonnull
    @CheckReturnValue
    public Optional<? extends Store> getStore();

    @Nonnull
    @CheckReturnValue
    public Optional<Sync> getSync();

    @CheckReturnValue
    public boolean isDropped();

    @CheckReturnValue
    public boolean isNullRemoves(boolean var1);

    @CheckReturnValue
    public boolean isSynced();

    @CheckReturnValue
    public boolean isVolatile();

    public static final class Replicate {
        private final Optional<Boolean> _convert;
        private final Point _point;

        public Replicate(@Nonnull Point point, @Nonnull Optional<Boolean> convert) {
            this._point = Require.notNull(point);
            this._convert = convert;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Boolean> getConvert() {
            return this._convert;
        }

        @Nonnull
        @CheckReturnValue
        public Point getPoint() {
            return this._point;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<UUID> getPointUUID() {
            return this._point.getUUID();
        }
    }

    @Immutable
    public static final class Named
    implements Point {
        private final String _name;
        private final Optional<UUID> _uuid;

        public Named(@Nonnull String name) {
            this(name, Optional.empty());
        }

        public Named(@Nonnull String name, @Nonnull Optional<UUID> uuid) {
            this._name = Require.notNull(name);
            this._uuid = uuid;
        }

        @Override
        public int compareTo(Entity other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Named copy() {
            return new Named(this._name, this._uuid);
        }

        public boolean equals(Object other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueFilter filter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Attributes> getAttributes(String usage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Content> getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getElementName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends PointRelation> getInputs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getName() {
            return Optional.of(this._name);
        }

        @Override
        public Optional<String> getNameInUpperCase() {
            return Optional.of(this._name.toUpperCase(Locale.ROOT));
        }

        public Optional<Origin> getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Params getParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrefix() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReferenceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Replicate> getReplicates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<? extends PointRelation> getResults() {
            throw new UnsupportedOperationException();
        }

        public Optional<Store> getStore() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Sync> getSync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UUID> getUUID() {
            return this._uuid;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDropped() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNullRemoves(boolean defaultNullRemoves) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSynced() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVolatile() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this._name;
        }
    }
}

