/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.Point;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.sync.Sync;

public interface PointValuesQuery {
    @Nonnull
    @CheckReturnValue
    public TimeInterval getInterval();

    @Nonnull
    @CheckReturnValue
    public Optional<Point> getPoint();

    @Nonnull
    @CheckReturnValue
    public Optional<Sync> getSync();

    @CheckReturnValue
    public boolean isExtrapolated();

    @CheckReturnValue
    public boolean isInterpolated();

    @CheckReturnValue
    public boolean isNotNull();

    @CheckReturnValue
    public boolean isPolated();

    @Immutable
    public static abstract class Abstract
    implements PointValuesQuery {
        private final TimeInterval _interval;
        private final Optional<Point> _point;
        private final Optional<Sync> _sync;

        protected Abstract(@Nonnull Optional<Point> point, @Nonnull TimeInterval interval, @Nonnull Optional<Sync> sync) {
            this._point = point;
            this._interval = interval;
            this._sync = sync;
        }

        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final TimeInterval getInterval() {
            return this._interval;
        }

        @Override
        public final Optional<Point> getPoint() {
            return this._point;
        }

        @Override
        public Optional<Sync> getSync() {
            return this._sync;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

