/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Point;
import org.rvpf.base.UUID;
import org.rvpf.base.store.PointBinding;
import org.rvpf.base.util.container.KeyedValues;

public interface Points {
    @Nonnull
    @CheckReturnValue
    public Optional<Point> getPoint(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public Optional<Point> getPointByName(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public Optional<Point> getPointByUUID(@Nonnull UUID var1);

    @Nonnull
    @CheckReturnValue
    public Collection<Point> getPointsCollection();

    public static final class Impl
    implements Points {
        private final Map<String, Reference<Point>> _pointsByName;
        private final Map<UUID, Reference<Point>> _pointsByUUID;

        public Impl() {
            this._pointsByName = new HashMap<String, Reference<Point>>();
            this._pointsByUUID = new LinkedHashMap<UUID, Reference<Point>>();
        }

        public Impl(@Nonnull PointBinding[] bindings) {
            int hashCapacity = KeyedValues.hashCapacity(bindings.length);
            this._pointsByName = new HashMap<String, Reference<Point>>(hashCapacity);
            this._pointsByUUID = new LinkedHashMap<UUID, Reference<Point>>(hashCapacity);
            for (PointBinding binding : bindings) {
                this.addPoint(new Point.Named(binding.getName(), Optional.of(binding.getUUID())));
            }
        }

        @Nonnull
        public Optional<Reference<Point>> addAlias(@Nonnull String alias, @Nonnull Point point) {
            return Optional.ofNullable(this._pointsByName.put(alias.toUpperCase(Locale.ROOT), new WeakReference<Point>(point)));
        }

        @Nonnull
        public Optional<Reference<Point>> addPoint(@Nonnull Point point) {
            Optional<String> name = point.getName();
            this._pointsByUUID.put(point.getUUID().get(), new WeakReference<Point>(point));
            return name.isPresent() ? this.addAlias(name.get(), point) : Optional.empty();
        }

        @Nonnull
        @CheckReturnValue
        public Map<String, Reference<Point>> getNamesMap() {
            return this._pointsByName;
        }

        @Override
        public Optional<Point> getPoint(String key) {
            if (UUID.isUUID(key)) {
                return this.getPointByUUID(UUID.fromString(key).get());
            }
            return this.getPointByName(key);
        }

        @Override
        public Optional<Point> getPointByName(String name) {
            Reference<Point> reference = this._pointsByName.get(name.trim().toUpperCase(Locale.ROOT));
            return Optional.ofNullable(reference != null ? reference.get() : null);
        }

        @Override
        public Optional<Point> getPointByUUID(UUID uuid) {
            Reference<Point> pointReference = this._pointsByUUID.get(uuid.undeleted());
            return Optional.ofNullable(pointReference != null ? pointReference.get() : null);
        }

        @Override
        public Collection<Point> getPointsCollection() {
            ArrayList<Point> points = new ArrayList<Point>(this._pointsByUUID.size());
            for (Reference<Point> pointReference : this._pointsByUUID.values()) {
                Point point = pointReference.get();
                if (point == null) continue;
                points.add(point);
            }
            return points;
        }

        @Nonnull
        @CheckReturnValue
        public Map<UUID, Reference<Point>> getUUIDMap() {
            return this._pointsByUUID;
        }
    }
}

