/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;

@ThreadSafe
public abstract class Stats
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private volatile transient DateTime _logTime;
    private volatile transient String _margin;
    private volatile DateTime _markTime;
    private volatile Stats _snapshot;
    private transient StringBuilder _text;

    protected Stats() {
        this.setMarkTime(DateTime.now());
        this._initialize();
    }

    public synchronized void buildText() {
        DateTime logTime = this.getLogTime().orElse(null);
        if (logTime == null) {
            logTime = DateTime.now();
            this.setLogTime(logTime);
        }
        this.addLine(BaseMessages.STATS_SINCE, this.getMarkTime(), ElapsedTime.fromMillis(logTime.toMillis() - this.getMarkTime().toMillis()).toString());
        this._clearLogTime();
    }

    public final void clearSnapshot() {
        this._snapshot = null;
    }

    public Stats clone() {
        Stats clone;
        try {
            clone = (Stats)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception);
        }
        return clone;
    }

    @Nonnull
    @CheckReturnValue
    public final Stats getIntermediate() {
        Stats stats;
        Optional<Stats> snapshot = this.getSnapshot();
        if (snapshot.isPresent()) {
            stats = this.clone();
            stats.clearSnapshot();
            stats.substract(snapshot.get());
        } else {
            stats = this;
        }
        return stats;
    }

    @Nonnull
    @CheckReturnValue
    public final DateTime getMarkTime() {
        return this._markTime;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<Stats> getSnapshot() {
        return Optional.ofNullable(this._snapshot);
    }

    @Nonnull
    @CheckReturnValue
    public final StringBuilder getText() {
        return this._text;
    }

    public final void setSnapshot(@Nonnull Stats snapshot) {
        snapshot.setMarkTime(DateTime.now());
        this._snapshot = snapshot;
    }

    public String toString() {
        this.buildText();
        String string = this.getText().toString();
        this.clearText();
        return string;
    }

    @Nonnull
    @CheckReturnValue
    protected static String nanosToString(long elapsed) {
        return ElapsedTime.fromNanos(elapsed).toString();
    }

    protected final void addLine(@Nonnull Messages.Entry entry, Object ... params) {
        this._addLine(entry.toString(), params);
    }

    @Deprecated
    protected final void addLine(String format, Object ... params) {
        this._addLine(format, params);
    }

    protected final void addText(@Nonnull String text) {
        this.getText().append(text);
    }

    protected final void clearMargin() {
        this._margin = null;
    }

    protected final void clearText() {
        this.getText().setLength(0);
    }

    @Nonnull
    @CheckReturnValue
    protected final Optional<DateTime> getLogTime() {
        return Optional.ofNullable(this._logTime);
    }

    protected final void setLogTime(@Nonnull DateTime logTime) {
        this._logTime = Require.notNull(logTime);
    }

    protected final void setMargin(@Nonnull String margin) {
        this._margin = Require.notNull(margin);
    }

    protected final void setMarkTime(@Nonnull DateTime markTime) {
        this._markTime = markTime;
    }

    protected void substract(@Nonnull Stats snapshot) {
        this.setMarkTime(snapshot.getMarkTime());
    }

    private void _addLine(String format, Object ... params) {
        String margin = this._margin;
        if (margin != null) {
            this.addText(margin);
        }
        this.addText(Message.format(format, params));
        if (margin == null) {
            this.addText("\n");
        }
    }

    private final void _clearLogTime() {
        this._logTime = null;
    }

    private void _initialize() {
        this._text = new StringBuilder();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this._initialize();
    }
}

