/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Message;

@Immutable
public final class TimeInterval
implements Serializable {
    public static final TimeInterval UNLIMITED = TimeInterval.newBuilder().build();
    private static final long serialVersionUID = 1L;
    private final Optional<DateTime> _after;
    private final Optional<DateTime> _before;

    TimeInterval(@Nonnull Optional<DateTime> after, @Nonnull Optional<DateTime> before) {
        this._after = after;
        this._before = before;
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    @CheckReturnValue
    public TimeInterval after(@Nonnull DateTime after) {
        return TimeInterval.newBuilder().setAfter(after)._setBefore(this._before).build();
    }

    @Nonnull
    @CheckReturnValue
    public TimeInterval before(@Nonnull DateTime before) {
        return TimeInterval.newBuilder()._setAfter(this._after).setBefore(before).build();
    }

    @CheckReturnValue
    public boolean contains(@Nonnull DateTime dateTime) {
        return !this.isBefore(dateTime) && !this.isAfter(dateTime);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TimeInterval)) {
            return false;
        }
        TimeInterval otherInterval = (TimeInterval)other;
        if (this._after.isPresent() ? !this._after.equals(otherInterval._after) : otherInterval._after.isPresent()) {
            return false;
        }
        return !(this._before.isPresent() ? !this._before.equals(otherInterval._before) : otherInterval._before.isPresent());
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getAfter() {
        return this._after;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getBefore() {
        return this._before;
    }

    @Nonnull
    @CheckReturnValue
    public DateTime getBeginning(boolean closed) {
        return this._after.isPresent() ? (closed ? this._after.get().after() : this._after.get()) : DateTime.BEGINNING_OF_TIME;
    }

    @Nonnull
    @CheckReturnValue
    public DateTime getEnd(boolean closed) {
        return this._before.isPresent() ? (closed ? this._before.get().before() : this._before.get()) : DateTime.END_OF_TIME;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNotAfter() {
        return this._before.isPresent() ? Optional.of(this._before.get().before()) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNotBefore() {
        return this._after.isPresent() ? Optional.of(this._after.get().after()) : Optional.empty();
    }

    public int hashCode() {
        int hash = 0;
        if (this._after.isPresent()) {
            hash ^= this._after.get().hashCode();
        }
        if (this._before.isPresent()) {
            hash ^= this._before.get().hashCode();
        }
        return hash;
    }

    @CheckReturnValue
    public boolean isAfter(@Nonnull DateTime dateTime) {
        return !this.isFromBeginningOfTime() && this._after.get().compareTo(dateTime) >= 0;
    }

    @CheckReturnValue
    public boolean isBefore(@Nonnull DateTime dateTime) {
        return !this.isToEndOfTime() && this._before.get().compareTo(dateTime) <= 0;
    }

    @CheckReturnValue
    public boolean isFromBeginningOfTime() {
        return !this._after.isPresent() || this._after.get().isBeginningOfTime();
    }

    @CheckReturnValue
    public boolean isInstant() {
        return this._after.isPresent() && this._before.isPresent() && this._after.get().toRaw() + 1L == this._before.get().toRaw() - 1L;
    }

    @CheckReturnValue
    public boolean isToEndOfTime() {
        return !this._before.isPresent() || this._before.get().isEndOfTime();
    }

    @Nonnull
    @CheckReturnValue
    public TimeInterval notAfter(@Nonnull DateTime notAfter) {
        return TimeInterval.newBuilder()._setAfter(this._after).setNotAfter(notAfter).build();
    }

    @Nonnull
    @CheckReturnValue
    public TimeInterval notBefore(@Nonnull DateTime notBefore) {
        return TimeInterval.newBuilder()._setBefore(this._before).setNotBefore(notBefore).build();
    }

    public String toString() {
        if (this.isFromBeginningOfTime() && this.isToEndOfTime()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(" ");
        if (this.isInstant()) {
            stringBuilder.append('[');
            stringBuilder.append(this._after.get().after());
            stringBuilder.append(']');
        } else {
            if (this.isFromBeginningOfTime()) {
                stringBuilder.append("(_");
            } else if (this._after.get().toRaw() % 10L == 9L) {
                stringBuilder.append('[');
                stringBuilder.append(this._after.get().after());
            } else {
                stringBuilder.append('(');
                stringBuilder.append(this._after.get());
            }
            stringBuilder.append("--");
            if (this.isToEndOfTime()) {
                stringBuilder.append("_)");
            } else if (this._before.get().toRaw() % 10L == 1L) {
                stringBuilder.append(this._before.get().before());
                stringBuilder.append(']');
            } else {
                stringBuilder.append(this._before.get());
                stringBuilder.append(')');
            }
        }
        return stringBuilder.toString();
    }

    @Nonnull
    @CheckReturnValue
    public TimeInterval trimmed(@Nonnull TimeInterval limits) {
        return TimeInterval.newBuilder().copyFrom(this).trim(limits).build();
    }

    private Object writeReplace() {
        return TimeInterval.newBuilder().copyFrom(this);
    }

    public static final class InvalidIntervalException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidIntervalException(@Nonnull String message) {
            super(message);
        }
    }

    @NotThreadSafe
    public static final class Builder
    implements Externalizable {
        private Optional<DateTime> _after = Optional.empty();
        private Optional<DateTime> _before = Optional.empty();

        @Nonnull
        @CheckReturnValue
        public static TimeInterval fromString(@Nonnull String intervalString) {
            Builder builder = TimeInterval.newBuilder();
            if ((intervalString = intervalString.trim()).length() > 0) {
                int separatorLength;
                int separatorIndex = intervalString.indexOf(47);
                if (separatorIndex >= 0) {
                    separatorLength = 1;
                } else {
                    separatorIndex = intervalString.indexOf("--");
                    if (separatorIndex >= 0) {
                        separatorLength = 2;
                    } else {
                        separatorIndex = intervalString.indexOf(44);
                        separatorLength = 1;
                    }
                }
                if (separatorIndex < 0) {
                    if (intervalString.charAt(0) != '[' || intervalString.charAt(intervalString.length() - 1) != ']') {
                        return Builder._invalidIntervalFormat(intervalString);
                    }
                    builder.setAt(Builder._dateTime(intervalString.substring(1, intervalString.length() - 1)).orElse(null));
                } else {
                    char limitChar = intervalString.charAt(0);
                    String timeString = intervalString.substring(1, separatorIndex);
                    if (limitChar == '(') {
                        builder._setAfter(Builder._dateTime(timeString));
                    } else if (limitChar == '[') {
                        builder._setNotBefore(Builder._dateTime(timeString));
                    } else {
                        return Builder._invalidIntervalFormat(intervalString);
                    }
                    limitChar = intervalString.charAt(intervalString.length() - 1);
                    timeString = intervalString.substring(separatorIndex + separatorLength, intervalString.length() - 1);
                    if (limitChar == ')') {
                        builder._setBefore(Builder._dateTime(timeString));
                    } else if (limitChar == ']') {
                        builder._setNotAfter(Builder._dateTime(timeString));
                    } else {
                        return Builder._invalidIntervalFormat(intervalString);
                    }
                }
            }
            return builder.build();
        }

        @Nonnull
        @CheckReturnValue
        public TimeInterval build() {
            if (!this.isValid()) {
                throw new InvalidIntervalException(Message.format(BaseMessages.NOT_BEFORE, this._after.get().after(), this._before));
            }
            return new TimeInterval(this._after, this._before);
        }

        @Nonnull
        public Builder clear() {
            this._after = Optional.empty();
            this._before = Optional.empty();
            return this;
        }

        @Nonnull
        public Builder copyFrom(@Nonnull TimeInterval otherInterval) {
            this._setAfter(otherInterval.getAfter());
            this._setBefore(otherInterval.getBefore());
            return this;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<DateTime> getAfter() {
            return this._after;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<DateTime> getBefore() {
            return this._before;
        }

        @CheckReturnValue
        public boolean isInstant() {
            return this._after.isPresent() && this._before.isPresent() && this._after.get().toRaw() + 1L == this._before.get().toRaw() - 1L;
        }

        @CheckReturnValue
        public boolean isValid() {
            return !this._after.isPresent() || !this._before.isPresent() || Long.compare(this._after.get().toRaw() + 1L, this._before.get().toRaw()) < 0;
        }

        @Override
        public void readExternal(@Nonnull ObjectInput input) throws IOException {
            this._after = DateTime.readExternal(input);
            this._before = DateTime.readExternal(input);
        }

        @Nonnull
        public Builder setAfter(@Nonnull DateTime after) {
            return this._setAfter(Optional.of(after));
        }

        @Nonnull
        public Builder setAt(@Nonnull DateTime at) {
            return this.setNotBefore(at).setNotAfter(at);
        }

        @Nonnull
        public Builder setBefore(@Nonnull DateTime before) {
            return this._setBefore(Optional.of(before));
        }

        @Nonnull
        public Builder setNotAfter(@Nonnull DateTime notAfter) {
            this.setBefore(notAfter.after());
            return this;
        }

        @Nonnull
        public Builder setNotBefore(@Nonnull DateTime notBefore) {
            this.setAfter(notBefore.before());
            return this;
        }

        public String toString() {
            return this.build().toString();
        }

        @Nonnull
        public Builder trim(@Nonnull TimeInterval limits) {
            Optional<DateTime> limitsAfter = limits.getAfter();
            DateTime trimAfter = limitsAfter.isPresent() && (!this._after.isPresent() || this._after.get().isBefore(limitsAfter.get())) ? limitsAfter.get() : null;
            Optional<DateTime> limitsBefore = limits.getBefore();
            DateTime trimBefore = limitsBefore.isPresent() && (!this._before.isPresent() || this._before.get().isAfter(limitsBefore.get())) ? limitsBefore.get() : null;
            if (trimAfter != null) {
                this.setAfter(trimAfter);
            }
            if (trimBefore != null) {
                this.setBefore(trimBefore);
            }
            return this;
        }

        @Override
        public void writeExternal(@Nonnull ObjectOutput output) throws IOException {
            DateTime.writeExternal(this._after, output);
            DateTime.writeExternal(this._before, output);
        }

        @Nonnull
        Builder _setAfter(@Nonnull Optional<DateTime> after) {
            this._after = after;
            return this;
        }

        @Nonnull
        Builder _setBefore(@Nonnull Optional<DateTime> before) {
            this._before = before;
            return this;
        }

        @Nonnull
        Builder _setNotAfter(@Nonnull Optional<DateTime> notAfter) {
            this._setBefore(notAfter.isPresent() ? Optional.of(notAfter.get().after()) : Optional.empty());
            return this;
        }

        @Nonnull
        Builder _setNotBefore(@Nonnull Optional<DateTime> notBefore) {
            this._setAfter(notBefore.isPresent() ? Optional.of(notBefore.get().before()) : Optional.empty());
            return this;
        }

        private static Optional<DateTime> _dateTime(String timeString) {
            if ((timeString = timeString.trim()).isEmpty() || "_".equals(timeString)) {
                return Optional.empty();
            }
            return Optional.of(DateTime.fromString(timeString));
        }

        private static TimeInterval _invalidIntervalFormat(String intervalString) {
            throw new InvalidIntervalException(Message.format(BaseMessages.INTERVAL_FORMAT, intervalString));
        }

        private Object readResolve() {
            return this.build();
        }
    }
}

