/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.alert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.Mappable;

@ThreadSafe
public abstract class Alert
implements Externalizable,
Mappable {
    public static final String ENTITY_FIELD = "entity";
    public static final String INFO_FIELD = "info";
    public static final String NAME_FIELD = "name";
    public static final String SERVICE_FIELD = "service";
    public static final String SOURCE_FIELD = "source";
    public static final String STAMP_FIELD = "stamp";
    public static final String UUID_FIELD = "uuid";
    public static final String VISITS_FIELD = "visits";
    private static final long serialVersionUID = 1L;
    private Optional<String> _info;
    private String _name;
    private Optional<String> _sourceEntityName;
    private Optional<String> _sourceServiceName;
    private Optional<UUID> _sourceUUID;
    private Optional<DateTime> _stamp;
    private UUID _uuid;
    private LinkedHashSet<UUID> _visits;

    protected Alert() {
    }

    protected Alert(@Nonnull String name, @Nonnull Optional<String> sourceServiceName, @Nonnull Optional<String> sourceEntityName, @Nonnull Optional<UUID> sourceUUID, @Nonnull Optional<?> info) {
        this._uuid = UUID.generate();
        this._name = Require.notNull(name);
        this._sourceServiceName = sourceServiceName;
        this._sourceEntityName = sourceEntityName;
        this._sourceUUID = sourceUUID;
        this._info = info.isPresent() ? Optional.of(info.get().toString().trim()) : Optional.empty();
        this._stamp = Optional.of(DateTime.now());
    }

    public final boolean addVisit(@Nonnull UUID uuid) {
        if (this._visits == null) {
            this._visits = new LinkedHashSet();
        }
        return this._visits.add(Require.notNull(uuid));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Alert otherAlert = (Alert)other;
        return Objects.equals(this._name, otherAlert._name) && Objects.equals(this._sourceServiceName, otherAlert._sourceServiceName) && Objects.equals(this._sourceEntityName, otherAlert._sourceEntityName) && Objects.equals(this._sourceUUID, otherAlert._sourceUUID) && Objects.equals(this._info, otherAlert._info) && Objects.equals(this._stamp, otherAlert._stamp) && Objects.equals(this._visits, otherAlert._visits);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getInfo() {
        return this._info;
    }

    @Nonnull
    @CheckReturnValue
    public final String getName() {
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getSourceEntityName() {
        return this._sourceEntityName;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getSourceServiceName() {
        return this._sourceServiceName;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<UUID> getSourceUUID() {
        return this._sourceUUID;
    }

    @Nonnull
    @CheckReturnValue
    public final DateTime getStamp() {
        return this._stamp.get();
    }

    @Nonnull
    @CheckReturnValue
    public final UUID getUUID() {
        return this._uuid;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        this._uuid = UUID.readExternal(input).get();
        this._name = Externalizer.readString(input).get();
        this._sourceServiceName = Externalizer.readString(input);
        this._sourceEntityName = Externalizer.readString(input);
        this._sourceUUID = UUID.readExternal(input);
        this._info = Externalizer.readString(input);
        this._stamp = DateTime.readExternal(input);
        int visits = input.readInt();
        while (--visits >= 0) {
            this.addVisit(UUID.readExternal(input).get());
        }
    }

    @Override
    public void readMap(Map<String, Serializable> map) {
        this._uuid = UUID.fromString((String)((Object)map.get(UUID_FIELD))).get();
        this._name = (String)((Object)map.get(NAME_FIELD));
        this._stamp = DateTime.fromString(Optional.ofNullable((String)((Object)map.get(STAMP_FIELD))));
        this._sourceServiceName = Optional.ofNullable((String)((Object)map.get(SERVICE_FIELD)));
        this._sourceEntityName = Optional.ofNullable((String)((Object)map.get(ENTITY_FIELD)));
        String sourceUUID = (String)((Object)map.get(SOURCE_FIELD));
        this._sourceUUID = sourceUUID != null ? UUID.fromString(sourceUUID) : Optional.empty();
        this._info = Optional.ofNullable((String)((Object)map.get(INFO_FIELD)));
        Collection visits = (Collection)((Object)map.get(VISITS_FIELD));
        if (visits != null) {
            for (Object visit : visits) {
                this.addVisit((UUID)visit);
            }
        }
    }

    public final String toString() {
        String service;
        String entity = this._sourceEntityName.isPresent() ? "'" + this._sourceEntityName.get() + "' " : "";
        String string = service = this._sourceServiceName.isPresent() ? "[" + this._sourceServiceName.get() + "] " : "";
        String info = !this._info.isPresent() ? "" : (this._info.get().startsWith("(") && this._info.get().endsWith(")") ? " " + this._info.get() : " \"" + this._info.get() + "\"");
        return Message.format(BaseMessages.ALERT, this.getTypeString(), this.getName(), info, entity, service, this._sourceUUID.orElse(null));
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        UUID.writeExternal(Optional.of(this._uuid), output);
        Externalizer.writeString(Optional.of(this._name), output);
        Externalizer.writeString(this._sourceServiceName, output);
        Externalizer.writeString(this._sourceEntityName, output);
        UUID.writeExternal(this._sourceUUID, output);
        Externalizer.writeString(this._info, output);
        DateTime.writeExternal(this._stamp, output);
        int visits = this._visits != null ? this._visits.size() : 0;
        output.writeInt(visits);
        if (visits > 0) {
            for (UUID visit : this._visits) {
                UUID.writeExternal(Optional.of(visit), output);
            }
        }
    }

    @Override
    public void writeMap(Map<String, Serializable> map) {
        map.put("", null);
        map.put(UUID_FIELD, (Serializable)((Object)this._uuid.toString()));
        map.put(NAME_FIELD, (Serializable)((Object)this._name));
        map.put(STAMP_FIELD, (Serializable)((Object)this._stamp.get().toString()));
        map.put(INFO_FIELD, this._info.orElse(null));
        map.put(SERVICE_FIELD, this._sourceServiceName.orElse(null));
        map.put(ENTITY_FIELD, this._sourceEntityName.orElse(null));
        if (this._sourceUUID.isPresent()) {
            map.put(SOURCE_FIELD, (Serializable)((Object)this._sourceUUID.get().toString()));
        }
        map.put(SERIALIZABLE_MODE, null);
        map.put(VISITS_FIELD, this._visits);
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String getTypeString();

    public static interface Dispatcher {
        public void dispatchAlert(@Nonnull Logger.LogLevel var1, @Nonnull String var2, @Nonnull String var3);
    }
}

