/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.Listeners;

@ThreadSafe
public class Logger
implements Externalizable,
Thread.UncaughtExceptionHandler {
    public static final String ID_KEY = "ID";
    public static final String LOG_ID_PROPERTY = "rvpf.log.id";
    public static final String MIDNIGHT_LOGGER_NAME = "MIDNIGHT";
    private static final String _FQCN = Logger.class.getName();
    private static final Field _log4jLoggerField;
    private static boolean _manualShutdown;
    private static Logger _midnightLogger;
    private static boolean _shutDown;
    private static final long serialVersionUID = 1L;
    private static final Map<org.apache.logging.log4j.Logger, Logger> _loggers;
    private static final Listeners<LogListener> _listeners;
    private static final AtomicInteger _generated_id;
    private final ExtendedLogger _log4jLogger;
    private final AtomicReference<LogLevel> _loggedLevel = new AtomicReference();

    public Logger() {
        this(Logger.class);
    }

    protected Logger(@Nonnull Class<?> ownerClass) {
        this(LogManager.getLogger(ownerClass.getName()));
    }

    protected Logger(@Nonnull org.apache.logging.log4j.Logger log4jLogger) {
        this._log4jLogger = Require.notNull((ExtendedLogger)log4jLogger);
    }

    @CheckReturnValue
    public static boolean addListener(@Nonnull LogListener listener) {
        return _listeners.add(Require.notNull(listener));
    }

    @Nonnull
    @CheckReturnValue
    public static synchronized Optional<String> currentLogID() {
        return Optional.ofNullable(ThreadContext.get(ID_KEY));
    }

    @Nonnull
    @CheckReturnValue
    public static Logger getInstance(@Nonnull Class<?> ownerClass) {
        return Logger.getInstance(ownerClass.getName());
    }

    @Nonnull
    @CheckReturnValue
    public static synchronized Logger getInstance(@Nonnull org.apache.logging.log4j.Logger log4jLogger) {
        Logger logger = _loggers.get(Require.notNull(log4jLogger));
        if (logger == null || logger.hasLogged(LogLevel.WARN)) {
            logger = new Logger(log4jLogger);
            _loggers.put(log4jLogger, logger);
        } else {
            logger.reset();
        }
        return logger;
    }

    @Nonnull
    @CheckReturnValue
    public static Logger getInstance(@Nonnull String name) {
        return Logger.getInstance(LogManager.getLogger(Require.notNull(name)));
    }

    @Nonnull
    @CheckReturnValue
    public static synchronized Logger getMidnightLogger() {
        Logger midnightLogger = _midnightLogger;
        if (midnightLogger == null) {
            _midnightLogger = midnightLogger = Logger.getInstance(MIDNIGHT_LOGGER_NAME);
        }
        return midnightLogger;
    }

    @CheckReturnValue
    public static synchronized boolean isShutDown() {
        return _shutDown;
    }

    public static void logBackEnd() {
        Package backEndPackage = LoggerContext.class.getPackage();
        Logger.getInstance(Logger.class).debug(BaseMessages.LOGGER_BACK_END, backEndPackage.getImplementationTitle(), backEndPackage.getImplementationVersion());
    }

    @CheckReturnValue
    public static boolean removeListener(@Nonnull LogListener listener) {
        return _listeners.remove(Require.notNull(listener));
    }

    public static synchronized void restoreLogID(@Nonnull Optional<String> logID) {
        if (logID.isPresent()) {
            ThreadContext.put(ID_KEY, logID.get());
        } else {
            ThreadContext.remove(ID_KEY);
        }
    }

    public static void setLogID() {
        Logger.setLogID(Optional.ofNullable(System.getProperty(LOG_ID_PROPERTY)));
    }

    public static synchronized void setLogID(@Nonnull Optional<String> logID) {
        ThreadContext.put(ID_KEY, logID.isPresent() ? logID.get().trim() : Integer.toString(_generated_id.incrementAndGet()));
    }

    public static synchronized void shutDown() {
        if (!_shutDown) {
            _shutDown = true;
            if (_manualShutdown) {
                Configurator.shutdown((LoggerContext)LogManager.getContext());
            }
        }
    }

    public static synchronized void startUp(boolean manualShutdown) {
        System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        System.setProperty("log4j2.disable.jmx", "true");
        if (manualShutdown) {
            System.setProperty("log4j.shutdownHookEnabled", "false");
        }
        _manualShutdown = manualShutdown;
    }

    public final void debug(@Nonnull Message message) {
        this.log(LogLevel.DEBUG, message);
    }

    public final void debug(@Nonnull Supplier<Message> messageSupplier) {
        this.log(LogLevel.DEBUG, Require.notNull(messageSupplier));
    }

    public final void debug(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.DEBUG, Require.notNull(entry), params);
    }

    @Deprecated
    public final void debug(@Nonnull String format, Object ... params) {
        this.log(LogLevel.DEBUG, Require.notNull(format), params);
    }

    public final void debug(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.DEBUG, cause, Require.notNull(entry), params);
    }

    @Deprecated
    public final void debug(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.DEBUG, cause, Require.notNull(format), params);
    }

    public final void error(@Nonnull Message message) {
        this.log(LogLevel.ERROR, message);
    }

    public final void error(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.ERROR, Require.notNull(entry), params);
    }

    @Deprecated
    public final void error(@Nonnull String format, Object ... params) {
        this.log(LogLevel.ERROR, Require.notNull(format), params);
    }

    public final void error(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.ERROR, cause, Require.notNull(entry), params);
    }

    @Deprecated
    public final void error(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.ERROR, cause, Require.notNull(format), params);
    }

    public final void fatal(@Nonnull Message message) {
        this.log(LogLevel.FATAL, message);
    }

    public final void fatal(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.FATAL, Require.notNull(entry), params);
    }

    @Deprecated
    public final void fatal(@Nonnull String format, Object ... params) {
        this.log(LogLevel.FATAL, Require.notNull(format), params);
    }

    public final void fatal(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.FATAL, cause, Require.notNull(entry), params);
    }

    @Deprecated
    public final void fatal(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.FATAL, cause, Require.notNull(format), params);
    }

    @Nonnull
    @CheckReturnValue
    public final LogLevel getLogLevel() {
        return LogLevel.get(this._log4jLogger.getLevel());
    }

    @Nonnull
    @CheckReturnValue
    public final String getName() {
        return this._log4jLogger.getName();
    }

    @Nonnull
    @CheckReturnValue
    public final PrintWriter getPrintWriter(final @Nonnull LogLevel logLevel) {
        StringWriter logWriter = new StringWriter(){

            @Override
            public void flush() {
                super.flush();
                if (Logger.this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
                    String text = this.toString();
                    while (text.endsWith("\n") || text.endsWith("\r")) {
                        text = text.substring(0, text.length() - 1);
                    }
                    if (text.length() > 0) {
                        Logger.this.log(logLevel, new Message(BaseMessages.VERBATIM, text));
                    }
                    this.getBuffer().setLength(0);
                }
            }
        };
        return new PrintWriter((Writer)logWriter, true);
    }

    @CheckReturnValue
    public final boolean hasLogged(@Nonnull LogLevel logLevel) {
        LogLevel loggedLevel = this._loggedLevel.get();
        return loggedLevel != null && loggedLevel.compareTo(logLevel) <= 0;
    }

    public final void info(@Nonnull Message message) {
        this.log(LogLevel.INFO, message);
    }

    public final void info(@Nonnull Supplier<Message> messageSupplier) {
        this.log(LogLevel.INFO, messageSupplier);
    }

    public final void info(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.INFO, entry, params);
    }

    @Deprecated
    public final void info(@Nonnull String format, Object ... params) {
        this.log(LogLevel.INFO, format, params);
    }

    public final void info(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.INFO, cause, entry, params);
    }

    @Deprecated
    public final void info(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.INFO, cause, format, params);
    }

    @CheckReturnValue
    public final boolean isDebugEnabled() {
        return this.getLog4jLevel().isLessSpecificThan(Level.DEBUG);
    }

    @CheckReturnValue
    public final boolean isEnabledFor(LogLevel logLevel) {
        return this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel());
    }

    @CheckReturnValue
    public final boolean isInfoEnabled() {
        return this.getLog4jLevel().isLessSpecificThan(Level.INFO);
    }

    @CheckReturnValue
    public final boolean isTraceEnabled() {
        return this.getLog4jLevel().isLessSpecificThan(Level.TRACE);
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull Message message) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, Require.notNull(message));
        }
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull Supplier<Message> messageSupplier) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, messageSupplier.get());
        }
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull Messages.Entry entry, Object ... params) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, new Message(entry, params));
        }
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull String format, Object ... params) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, new Message(format, params));
        }
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, new Message(cause, entry, params));
        }
    }

    public final void log(@Nonnull LogLevel logLevel, @Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        if (this.getLog4jLevel().isLessSpecificThan(logLevel.getLevel())) {
            this.doLog(logLevel, new Message(cause, format, params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readExternal(@Nonnull ObjectInput input) throws IOException {
        Field field = _log4jLoggerField;
        synchronized (field) {
            _log4jLoggerField.setAccessible(true);
            try {
                _log4jLoggerField.set(this, LogManager.getLogger(input.readUTF()));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new InternalError(exception);
            }
            _log4jLoggerField.setAccessible(false);
        }
    }

    public final void reset() {
        this._loggedLevel.set(null);
    }

    public final void trace(@Nonnull Message message) {
        this.log(LogLevel.TRACE, message);
    }

    public final void trace(@Nonnull Supplier<Message> messageSupplier) {
        this.log(LogLevel.TRACE, messageSupplier);
    }

    public final void trace(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.TRACE, entry, params);
    }

    @Deprecated
    public final void trace(@Nonnull String format, Object ... params) {
        this.log(LogLevel.TRACE, format, params);
    }

    public final void trace(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.TRACE, cause, entry, params);
    }

    @Deprecated
    public final void trace(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.TRACE, cause, format, params);
    }

    @Override
    public final void uncaughtException(@Nonnull Thread thread, @Nonnull Throwable throwable) {
        if (!_shutDown) {
            Logger.getInstance(Logger.class).fatal(throwable, BaseMessages.THREAD_EXCEPTION, thread.getName(), throwable);
        }
    }

    public final void warn(@Nonnull Message message) {
        this.log(LogLevel.WARN, message);
    }

    public final void warn(@Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.WARN, entry, params);
    }

    @Deprecated
    public final void warn(@Nonnull String format, Object ... params) {
        this.log(LogLevel.WARN, format, params);
    }

    public final void warn(@Nonnull Throwable cause, @Nonnull Messages.Entry entry, Object ... params) {
        this.log(LogLevel.WARN, cause, entry, params);
    }

    @Deprecated
    public final void warn(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this.log(LogLevel.WARN, cause, format, params);
    }

    @Override
    public final void writeExternal(@Nonnull ObjectOutput output) throws IOException {
        output.writeUTF(this.getName());
    }

    protected void doLog(@Nonnull LogLevel logLevel, @Nonnull Message message) {
        if (!_listeners.isEmpty()) {
            for (LogListener listener : _listeners) {
                LogLevel newLevel = listener.onLog(this, logLevel, message).orElse(null);
                if (newLevel == logLevel) continue;
                if (newLevel == null || this.getLog4jLevel().isMoreSpecificThan(newLevel.getLevel())) {
                    return;
                }
                logLevel = newLevel;
            }
        }
        if (_shutDown) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(DateTime.now().toFullString());
            stringBuilder.append(' ');
            stringBuilder.append(logLevel.name());
            if (logLevel.name().length() < 5) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(" [");
            stringBuilder.append(this._log4jLogger.getName());
            stringBuilder.append("] ");
            stringBuilder.append(message.toString());
            System.err.println(stringBuilder);
            Optional<Throwable> messageCause = message.getCause();
            if (messageCause.isPresent()) {
                messageCause.get().printStackTrace(System.err);
            }
            System.err.flush();
        } else {
            LogLevel loggedLevel;
            message.saveFormatted();
            this._log4jLogger.logMessage(_FQCN, logLevel.getLevel(), null, message, message.getCause().orElse(null));
            while (!((loggedLevel = this._loggedLevel.get()) != null && logLevel.compareTo(loggedLevel) >= 0 || this._loggedLevel.compareAndSet(loggedLevel, logLevel))) {
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    protected final Level getLog4jLevel() {
        return this._log4jLogger.getLevel();
    }

    @Nonnull
    @CheckReturnValue
    protected final org.apache.logging.log4j.Logger getLog4jLogger() {
        return this._log4jLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _loggers.computeIfAbsent(this._log4jLogger, logger -> this);
        }
    }

    static {
        _loggers = new IdentityHashMap<org.apache.logging.log4j.Logger, Logger>();
        _listeners = new Listeners();
        _generated_id = new AtomicInteger();
        try {
            _log4jLoggerField = Logger.class.getDeclaredField("_log4jLogger");
        }
        catch (NoSuchFieldException | SecurityException exception) {
            throw new InternalError(exception);
        }
    }

    public static interface LogListener {
        @Nonnull
        @CheckReturnValue
        public Optional<LogLevel> onLog(@Nonnull Logger var1, @Nonnull LogLevel var2, @Nonnull Message var3);
    }

    public static enum LogLevel {
        NONE(Level.OFF),
        FATAL(Level.FATAL),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG),
        TRACE(Level.TRACE),
        ALL(Level.ALL);

        private final Level _level;

        private LogLevel(Level level) {
            this._level = level;
        }

        public static LogLevel get(int ordinal) {
            switch (ordinal) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return FATAL;
                }
                case 2: {
                    return ERROR;
                }
                case 3: {
                    return WARN;
                }
                case 4: {
                    return INFO;
                }
                case 5: {
                    return DEBUG;
                }
                case 6: {
                    return TRACE;
                }
                case 7: {
                    return ALL;
                }
            }
            return DEBUG;
        }

        @Nonnull
        @CheckReturnValue
        public static LogLevel get(@Nonnull String name) {
            return LogLevel.valueOf(LogLevel.class, name.toUpperCase(Locale.ROOT));
        }

        @Nonnull
        @CheckReturnValue
        static LogLevel get(@Nonnull Level level) {
            return LogLevel.get(level.toString());
        }

        @Nonnull
        @CheckReturnValue
        Level getLevel() {
            return this._level;
        }
    }
}

