/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.ValueConverter;

@ThreadSafe
public final class MemoryLogger
implements Runnable {
    private static final MemoryLogger _INSTANCE = new MemoryLogger();
    private static final Logger _LOGGER = Logger.getInstance(MemoryLogger.class);
    private final Deque<ElapsedTime> _activations = new LinkedList<ElapsedTime>();
    private Optional<ElapsedTime> _elapsedTime = Optional.empty();
    private DateTime _lastMidnight;
    private boolean _reset;

    private MemoryLogger() {
    }

    @Nonnull
    @CheckReturnValue
    public static MemoryLogger getInstance() {
        return _INSTANCE;
    }

    public static void logMemoryInfo() {
        if (_LOGGER.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            long max = ValueConverter.roundToMebibytes(runtime.maxMemory());
            long total = ValueConverter.roundToMebibytes(runtime.totalMemory());
            long free = ValueConverter.roundToMebibytes(runtime.freeMemory());
            long used = total - free;
            _LOGGER.debug(BaseMessages.MEMORY, String.valueOf(used), String.valueOf(free), String.valueOf(total), String.valueOf(max));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(@Nonnull Optional<ElapsedTime> logInterval) {
        Deque<ElapsedTime> deque = this._activations;
        synchronized (deque) {
            Optional<ElapsedTime> elapsedTime;
            MemoryLogger.logMemoryInfo();
            Optional<ElapsedTime> optional = elapsedTime = logInterval.isPresent() ? logInterval : this._elapsedTime;
            if (elapsedTime.isPresent()) {
                if (this._elapsedTime.isPresent()) {
                    this._activations.addLast(this._elapsedTime.get());
                    this._elapsedTime = elapsedTime;
                    this._reset();
                } else {
                    Thread thread = new Thread((Runnable)this, "Memory logger");
                    thread.setDaemon(true);
                    this._elapsedTime = elapsedTime;
                    thread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        Deque<ElapsedTime> deque = this._activations;
        synchronized (deque) {
            if (this._elapsedTime.isPresent()) {
                if (this._activations.isEmpty()) {
                    this._elapsedTime = Optional.empty();
                    this._reset();
                } else {
                    this._elapsedTime = Optional.of(this._activations.removeLast());
                }
            }
            MemoryLogger.logMemoryInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMidnightEvent() {
        Deque<ElapsedTime> deque = this._activations;
        synchronized (deque) {
            DateTime midnight = DateTime.now().midnight();
            if (!midnight.equals(this._lastMidnight)) {
                MemoryLogger.logMemoryInfo();
                this._lastMidnight = midnight;
                this._reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Deque<ElapsedTime> deque = this._activations;
        synchronized (deque) {
            try {
                while (this._elapsedTime.isPresent()) {
                    long wakeMillis = DateTime.now().after(this._elapsedTime.get()).toMillis();
                    do {
                        long snoozeMillis;
                        if ((snoozeMillis = wakeMillis - System.currentTimeMillis()) <= 0L) {
                            MemoryLogger.logMemoryInfo();
                            break;
                        }
                        this._activations.wait(snoozeMillis);
                    } while (!this._reset);
                    this._reset = false;
                }
            }
            catch (InterruptedException exception) {
                throw new InternalError(exception);
            }
        }
    }

    private void _reset() {
        this._reset = true;
        this._activations.notifyAll();
    }
}

