/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger;

import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;

@Immutable
public final class StringLogger {
    private final Logger _logger;

    private StringLogger(Logger logger) {
        this._logger = Require.notNull(logger);
    }

    @Nonnull
    @CheckReturnValue
    public static StringLogger getInstance(@Nonnull Class<?> ownerClass) {
        return new StringLogger(Logger.getInstance(ownerClass));
    }

    @Nonnull
    @CheckReturnValue
    public static StringLogger getInstance(@Nonnull org.apache.logging.log4j.Logger log4jLogger) {
        return new StringLogger(Logger.getInstance(log4jLogger));
    }

    @Nonnull
    @CheckReturnValue
    public static StringLogger getInstance(@Nonnull String name) {
        return new StringLogger(Logger.getInstance(name));
    }

    public void debug(@Nonnull Supplier<Message> messageSupplier) {
        this._logger.log(Logger.LogLevel.DEBUG, messageSupplier);
    }

    public void debug(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.DEBUG, format, params);
    }

    public void debug(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.DEBUG, cause, format, params);
    }

    public void error(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.ERROR, format, params);
    }

    public void error(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.ERROR, cause, format, params);
    }

    public void fatal(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.FATAL, format, params);
    }

    public void fatal(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.FATAL, cause, format, params);
    }

    @Nonnull
    @CheckReturnValue
    public Logger.LogLevel getLogLevel() {
        return this._logger.getLogLevel();
    }

    @Nonnull
    @CheckReturnValue
    public Logger getLogger() {
        return this._logger;
    }

    public void info(@Nonnull Supplier<Message> messageSupplier) {
        this._logger.log(Logger.LogLevel.INFO, messageSupplier);
    }

    public void info(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.INFO, format, params);
    }

    public void info(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.INFO, cause, format, params);
    }

    @CheckReturnValue
    public boolean isDebugEnabled() {
        return this._logger.isDebugEnabled();
    }

    @CheckReturnValue
    public boolean isEnabledFor(Logger.LogLevel logLevel) {
        return this._logger.isEnabledFor(logLevel);
    }

    @CheckReturnValue
    public boolean isInfoEnabled() {
        return this._logger.isInfoEnabled();
    }

    @CheckReturnValue
    public boolean isTraceEnabled() {
        return this._logger.isTraceEnabled();
    }

    public void trace(@Nonnull Supplier<Message> messageSupplier) {
        this._logger.log(Logger.LogLevel.TRACE, messageSupplier);
    }

    public void trace(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.TRACE, format, params);
    }

    public void trace(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.TRACE, cause, format, params);
    }

    public void warn(@Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.WARN, format, params);
    }

    public void warn(@Nonnull Throwable cause, @Nonnull String format, Object ... params) {
        this._logger.log(Logger.LogLevel.WARN, cause, format, params);
    }
}

