/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.Serializable;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.util.OptionConverter;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.StringMap;
import org.rvpf.base.logger.log4j.DailyFileManager;

@Plugin(name="DailyFile", category="Core", elementType="appender", printObject=true)
public final class DailyFileAppender
extends AbstractOutputStreamAppender<DailyFileManager> {
    private DailyFileAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, DailyFileManager manager) {
        super(name, layout, filter, ignoreExceptions, true, manager);
    }

    @PluginFactory
    public static DailyFileAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="directory", defaultString=".") String directory, @PluginAttribute(value="fileNamePrefix") String fileNamePrefix, @PluginAttribute(value="dateFormat", defaultString="yyyy-MM-dd") String dateFormat, @PluginAttribute(value="fileNameSuffix", defaultString=".log") String fileNameSuffix, @PluginAttribute(value="maxFileSize", defaultString="0") String maxFileSize, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        DailyFileManager manager;
        if (name == null) {
            LOGGER.error("No name provided for DailyFileAppender");
            return null;
        }
        if (filter == null) {
            filter = ThresholdFilter.createFilter(Level.INFO, null, null);
        }
        if ((manager = DailyFileManager.getFileManager(directory, fileNamePrefix != null ? fileNamePrefix : "", dateFormat, fileNameSuffix, OptionConverter.toFileSize(maxFileSize, 0L), layout)) == null) {
            return null;
        }
        return new DailyFileAppender(name, filter, layout, ignoreExceptions, manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEvent event) {
        DailyFileManager manager;
        DailyFileManager dailyFileManager = manager = (DailyFileManager)this.getManager();
        synchronized (dailyFileManager) {
            if (manager.checkRollover()) {
                if (manager.isOversize()) {
                    if (!manager.isTruncated()) {
                        Log4jLogEvent.Builder eventBuilder = Log4jLogEvent.newBuilder();
                        eventBuilder.setLoggerName(event.getLoggerName());
                        eventBuilder.setLoggerFqcn(this.getClass().getName());
                        eventBuilder.setLevel(Level.INFO);
                        eventBuilder.setMessage(new SimpleMessage("... [truncated]"));
                        StringMap contextData = ContextDataFactory.createContextData();
                        for (Map.Entry<String, String> entry : ThreadContext.getImmutableContext().entrySet()) {
                            contextData.putValue(entry.getKey(), entry.getValue());
                        }
                        eventBuilder.setContextData(contextData);
                        eventBuilder.setContextStack(ThreadContext.getImmutableStack());
                        eventBuilder.setThreadName(Thread.currentThread().getName());
                        eventBuilder.setTimeMillis(System.currentTimeMillis());
                        super.append(eventBuilder.build());
                        manager.setTruncated(true);
                    }
                } else {
                    super.append(event);
                }
            }
        }
    }
}

