/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.annotation.CheckReturnValue;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.util.Constants;
import org.rvpf.base.tool.Require;

public class DailyFileManager
extends FileManager {
    private static final _DailyFileManagerFactory _FACTORY = new _DailyFileManagerFactory();
    private final String _dateFormat;
    private final String _directory;
    private final String _fileNamePrefix;
    private final String _fileNameSuffix;
    private long _fileSize;
    private final long _maxFileSize;
    private File _outputFile;
    private long _tomorrow;
    private boolean _truncated;

    protected DailyFileManager(String fileName, File outputFile, OutputStream outputStream, Layout<? extends Serializable> layout, String directory, String fileNamePrefix, String dateFormat, String fileNameSuffix, long maxFileSize, long fileSize, long tomorrow) {
        super(null, fileName, outputStream, true, false, false, null, layout, layout != null, ByteBuffer.wrap(new byte[Constants.ENCODER_BYTE_BUFFER_SIZE]));
        this._outputFile = outputFile;
        this._directory = directory;
        this._fileNamePrefix = fileNamePrefix;
        this._dateFormat = dateFormat;
        this._fileNameSuffix = fileNameSuffix;
        this._maxFileSize = maxFileSize;
        this._fileSize = fileSize;
        this._tomorrow = tomorrow;
    }

    public static DailyFileManager getFileManager(String directory, String fileNamePrefix, String dateFormat, String fileNameSuffix, long maxFileSize, Layout<? extends Serializable> layout) {
        return (DailyFileManager)DailyFileManager.getManager(directory + '/' + fileNamePrefix + dateFormat + fileNameSuffix, new _FactoryData(directory, fileNamePrefix, dateFormat, fileNameSuffix, maxFileSize, layout), _FACTORY);
    }

    @CheckReturnValue
    public boolean checkRollover() {
        if (this.getOutputStream() == null) {
            return false;
        }
        if (System.currentTimeMillis() >= this._tomorrow) {
            this.close();
            Calendar calendar = DailyFileManager._makeCalendar();
            File outputFile = DailyFileManager._makeOutputFile(this._directory, this._fileNamePrefix, this._dateFormat, this._fileNameSuffix, calendar);
            OutputStream outputStream = DailyFileManager._makeOutputStream(outputFile);
            this.setOutputStream(outputStream);
            if (outputStream == null) {
                return false;
            }
            this._outputFile = outputFile;
            this._fileSize = outputFile.length();
            this._tomorrow = DailyFileManager._tomorrow(calendar);
            this._truncated = false;
        }
        return true;
    }

    @CheckReturnValue
    public boolean isOversize() {
        return this._fileSize > this._maxFileSize;
    }

    @CheckReturnValue
    public boolean isTruncated() {
        return this._truncated;
    }

    public void setTruncated(boolean truncated) {
        this._truncated = truncated;
    }

    @Override
    protected OutputStream getOutputStream() {
        try {
            return super.getOutputStream();
        }
        catch (IOException exception) {
            throw new AppenderLoggingException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void write(byte[] bytes, int offset, int length) {
        this._fileSize += (long)length;
        boolean interrupted = false;
        while (true) {
            FileChannel channel = ((FileOutputStream)this.getOutputStream()).getChannel();
            try {
                FileLock lock = channel.lock();
                try {
                    super.write(bytes, offset, length);
                }
                finally {
                    lock.release();
                }
            }
            catch (FileLockInterruptionException exception) {
                interrupted = true;
                Thread.interrupted();
                this.close();
                this.setOutputStream(DailyFileManager._makeOutputStream(this._outputFile));
                continue;
            }
            catch (IOException exception) {
                throw new AppenderLoggingException("Failed to lock " + this._outputFile.getAbsolutePath(), exception);
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    static Calendar _makeCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    static File _makeOutputFile(String directory, String fileNamePrefix, String dateFormat, String fileNameSuffix, Calendar calendar) {
        File directoryFile = new File(directory);
        if (!directoryFile.mkdirs()) {
            Require.success(directoryFile.isDirectory());
        }
        String dateString = new SimpleDateFormat(dateFormat).format(calendar.getTime());
        return new File(directoryFile, fileNamePrefix + dateString + fileNameSuffix);
    }

    static OutputStream _makeOutputStream(File outputFile) {
        FileOutputStream outputStream;
        try {
            outputStream = new FileOutputStream(outputFile, true);
        }
        catch (FileNotFoundException exception) {
            LOGGER.error("Failed to open log file '" + outputFile + "': " + exception);
            return null;
        }
        return outputStream;
    }

    static long _tomorrow(Calendar calendar) {
        calendar.add(5, 1);
        return calendar.getTimeInMillis();
    }

    private static class _FactoryData {
        final String dateFormat;
        final String directory;
        final String fileNamePrefix;
        final String fileNameSuffix;
        final Layout<? extends Serializable> layout;
        final long maxFileSize;

        _FactoryData(String directory, String fileNamePrefix, String dateFormat, String fileNameSuffix, long maxFileSize, Layout<? extends Serializable> layout) {
            this.directory = directory;
            this.fileNamePrefix = fileNamePrefix;
            this.dateFormat = dateFormat;
            this.fileNameSuffix = fileNameSuffix;
            this.maxFileSize = maxFileSize;
            this.layout = layout;
        }
    }

    private static class _DailyFileManagerFactory
    implements ManagerFactory<FileManager, _FactoryData> {
        _DailyFileManagerFactory() {
        }

        @Override
        public DailyFileManager createManager(String name, _FactoryData data) {
            Calendar calendar = DailyFileManager._makeCalendar();
            File outputFile = DailyFileManager._makeOutputFile(data.directory, data.fileNamePrefix, data.dateFormat, data.fileNameSuffix, calendar);
            OutputStream outputStream = DailyFileManager._makeOutputStream(outputFile);
            if (outputStream == null) {
                return null;
            }
            return new DailyFileManager(name, outputFile, outputStream, data.layout, data.directory, data.fileNamePrefix, data.dateFormat, data.fileNameSuffix, data.maxFileSize, outputFile.length(), DailyFileManager._tomorrow(calendar));
        }
    }
}

