/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.logger.log4j;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.net.SmtpManager;
import org.rvpf.base.logger.log4j.TriggeringPolicy;

@Plugin(name="Mail", category="Core", elementType="appender", printObject=true)
public final class MailAppender
extends AbstractAppender {
    private static final int _DEFAULT_BUFFER_SIZE = 512;
    private final SmtpManager _manager;
    private final TriggeringPolicy _policy;

    private MailAppender(String name, Filter filter, TriggeringPolicy policy, Layout<? extends Serializable> layout, SmtpManager manager, boolean ignoreExceptions) {
        super(name, filter, layout, ignoreExceptions);
        this._policy = policy;
        this._manager = manager;
    }

    @PluginFactory
    public static MailAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="to") String to, @PluginAttribute(value="cc") String cc, @PluginAttribute(value="bcc") String bcc, @PluginAttribute(value="from") String from, @PluginAttribute(value="replyTo") String replyTo, @PluginAttribute(value="subject") String subject, @PluginAttribute(value="smtpProtocol") String smtpProtocol, @PluginAttribute(value="smtpHost") String smtpHost, @PluginAttribute(value="smtpPort", defaultInt=0) int smtpPort, @PluginAttribute(value="smtpUsername") String smtpUsername, @PluginAttribute(value="smtpPassword") String smtpPassword, @PluginAttribute(value="smtpDebug", defaultBoolean=false) boolean smtpDebug, @PluginElement(value="Filter") Filter filter, @PluginElement(value="Policy") TriggeringPolicy policy, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="bufferSize", defaultInt=512) int bufferSize, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) boolean ignoreExceptions) {
        SmtpManager manager;
        if (name == null) {
            LOGGER.error("No name provided for MailAppender");
            return null;
        }
        if (layout == null) {
            layout = HtmlLayout.createDefaultLayout();
        }
        if (filter == null) {
            filter = policy == null ? ThresholdFilter.createFilter(null, null, null) : ThresholdFilter.createFilter(Level.DEBUG, null, null);
        }
        if ((manager = SmtpManager.getSmtpManager(null, to, cc, bcc, from, replyTo, subject, smtpProtocol, smtpHost, smtpPort, smtpUsername, smtpPassword, smtpDebug, filter.toString(), bufferSize)) == null) {
            return null;
        }
        return new MailAppender(name, filter, policy, layout, manager, ignoreExceptions);
    }

    @Override
    public void append(LogEvent event) {
        if (this._policy == null || this._policy.isTriggeringEvent(event)) {
            this._manager.sendEvents(this.getLayout(), event);
        } else {
            this._manager.add(event);
        }
    }

    @Override
    public boolean isFiltered(LogEvent event) {
        boolean filtered = super.isFiltered(event);
        if (filtered && this._policy == null) {
            this._manager.add(event);
        }
        return filtered;
    }
}

