/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.pipe;

import java.io.Serializable;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.pipe.PipeRequest;
import org.rvpf.base.value.PointValue;

@ThreadSafe
public final class PipeEngineRequest
extends PipeRequest {
    public static final int REQUEST_FORMAT_VERSION = 1;
    private final PointValue[] _inputs;
    private final String[] _pointParams;
    private volatile PointValue _result;
    private final Queue<PointValue> _results = new ConcurrentLinkedQueue<PointValue>();
    private final String[] _transformParams;

    private PipeEngineRequest(@Nonnull String requestID, int version, @Nonnull String[] transformParams, @Nonnull String[] pointParams, @Nonnull PointValue[] inputs, @Nonnull PointValue result) {
        super(requestID, version);
        this._transformParams = transformParams;
        this._pointParams = pointParams;
        this._inputs = inputs;
        this._result = result;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<PipeEngineRequest> nextRequest() {
        int i;
        Optional<String> line = PipeEngineRequest.firstLine();
        if (!line.isPresent()) {
            return Optional.empty();
        }
        String[] words = SPACE_PATTERN.split(line.get(), 0);
        if (words.length != 5) {
            throw PipeEngineRequest.error("Unexpected request format: " + line, new Object[0]);
        }
        String requestID = words[0];
        int version = PipeEngineRequest.parseInt(words[1]);
        if (version > 1) {
            throw PipeEngineRequest.error("Unsupported request format version: " + version, new Object[0]);
        }
        String[] transformParams = new String[PipeEngineRequest.parseInt(words[2])];
        String[] pointParams = new String[PipeEngineRequest.parseInt(words[3])];
        PointValue[] inputs = new PointValue[PipeEngineRequest.parseInt(words[4])];
        PointValue result = PipeEngineRequest.nextPointValue(true);
        for (i = 0; i < transformParams.length; ++i) {
            transformParams[i] = PipeEngineRequest.nextLine();
        }
        for (i = 0; i < pointParams.length; ++i) {
            pointParams[i] = PipeEngineRequest.nextLine();
        }
        for (i = 0; i < inputs.length; ++i) {
            inputs[i] = PipeEngineRequest.nextPointValue(false);
        }
        return Optional.of(new PipeEngineRequest(requestID, version, transformParams, pointParams, inputs, result));
    }

    public void addResult(@Nonnull PointValue result) {
        this._results.add(result);
    }

    public synchronized void clearResults() {
        this._result = null;
        this._results.clear();
    }

    @Nonnull
    @CheckReturnValue
    public PointValue[] getInputs() {
        return this._inputs;
    }

    @Nonnull
    @CheckReturnValue
    public String[] getPointParams() {
        return this._pointParams;
    }

    @Nonnull
    @CheckReturnValue
    public PointValue getResult() {
        return this._result;
    }

    @Nonnull
    @CheckReturnValue
    public String[] getTransformParams() {
        return this._transformParams;
    }

    public synchronized void respond() {
        int resultsSize = this._results.size();
        int summary = this._result != null ? (this._result.getValue() != null || resultsSize > 0 ? 1 + resultsSize : 0) : (resultsSize > 0 ? resultsSize : -1);
        PipeEngineRequest.writeLine(this.getRequestID() + " " + summary);
        if (summary > 0) {
            for (int i = 0; i < resultsSize; ++i) {
                PipeEngineRequest.writePointValue(this._results.remove());
            }
            if (this._result != null) {
                PipeEngineRequest.writePointValue(this._result);
            }
        }
    }

    public void setResultState(@Nullable Serializable state) {
        PointValue result = this._result;
        if (result == null) {
            throw PipeEngineRequest.error("Trying to set the state of a cleared result", new Object[0]);
        }
        result.setState(state);
    }

    public void setResultValue(@Nullable Serializable value) {
        PointValue result = this._result;
        if (result == null) {
            throw PipeEngineRequest.error("Trying to set the value of a cleared result", new Object[0]);
        }
        result.setValue(value);
    }
}

