/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.pipe;

import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.logger.Message;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;

@Immutable
public abstract class PipeRequest {
    public static final String DEBUG_LEVEL = "DEBUG";
    public static final String ERROR_LEVEL = "ERROR";
    public static final String FATAL_LEVEL = "FATAL";
    public static final String INFO_LEVEL = "INFO";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    public static final String TRACE_LEVEL = "TRACE";
    public static final String WARN_LEVEL = "WARN";
    private static final Pattern _CLEAN_PATTERN = Pattern.compile("[\\x00-\\x1f]|[\\x7f-\\x9f]");
    private final String _requestID;
    private final int _version;

    protected PipeRequest(@Nonnull String requestID, int version) {
        this._requestID = requestID;
        this._version = version;
    }

    @Nonnull
    @CheckReturnValue
    public static String cleanString(@Nonnull String string) {
        Matcher matcher = _CLEAN_PATTERN.matcher(string.trim());
        return matcher.replaceAll(" ");
    }

    public static void debug(@Nonnull Messages.Entry entry, Object ... params) {
        PipeRequest.log(LogLevel.DEBUG, entry, params);
    }

    public static void debug(@Nonnull String format, Object ... params) {
        PipeRequest.log(LogLevel.DEBUG, format, params);
    }

    @Nonnull
    @CheckReturnValue
    public static RuntimeException error(@Nonnull Messages.Entry entry, Object ... params) {
        return PipeRequest.error(entry.toString(), params);
    }

    @Nonnull
    @CheckReturnValue
    public static RuntimeException error(@Nonnull String format, Object ... params) {
        String text = Message.format(format, params);
        PipeRequest.log(LogLevel.ERROR, BaseMessages.VERBATIM, text);
        return new RuntimeException(text);
    }

    @Nonnull
    @CheckReturnValue
    public static RuntimeException fatal(@Nonnull Messages.Entry entry, Object ... params) {
        return PipeRequest.fatal(entry.toString(), params);
    }

    @Nonnull
    @CheckReturnValue
    public static RuntimeException fatal(@Nonnull String format, Object ... params) {
        String text = Message.format(format, params);
        PipeRequest.log(LogLevel.FATAL, BaseMessages.VERBATIM, text);
        return new RuntimeException(text);
    }

    public static void info(@Nonnull Messages.Entry entry, Object ... params) {
        PipeRequest.log(LogLevel.INFO, entry, params);
    }

    public static void info(@Nonnull String format, Object ... params) {
        PipeRequest.log(LogLevel.INFO, format, params);
    }

    public static void log(@Nonnull LogLevel level, @Nonnull Messages.Entry entry, Object ... params) {
        PipeRequest.log(level, entry.toString(), params);
    }

    public static void log(@Nonnull LogLevel level, @Nonnull String format, Object ... params) {
        System.err.println(level.name() + ' ' + Message.format(format, params));
        System.err.flush();
    }

    @Nonnull
    @CheckReturnValue
    public static String pointValueToString(@Nonnull PointValue pointValue) {
        char c;
        int i;
        String value;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((String)pointValue.getPointName().orElse(null));
        stringBuilder.append(' ');
        stringBuilder.append(pointValue.getStamp().toFullString());
        if (pointValue.getState() != null) {
            value = String.valueOf(pointValue.getState());
            stringBuilder.append(" [");
            for (i = 0; i < value.length(); ++i) {
                c = value.charAt(i);
                if (c == '[') {
                    stringBuilder.append(']');
                } else if (c == ']') {
                    stringBuilder.append('[');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append(']');
        }
        if (pointValue.getValue() != null) {
            value = String.valueOf(pointValue.getValue());
            stringBuilder.append(" \"");
            for (i = 0; i < value.length(); ++i) {
                c = value.charAt(i);
                if (c == '\"') {
                    stringBuilder.append('\"');
                }
                stringBuilder.append(c);
            }
            stringBuilder.append('\"');
        } else if (pointValue.isDeleted()) {
            stringBuilder.append(" -");
        }
        return stringBuilder.toString();
    }

    @Nullable
    @CheckReturnValue
    public static PointValue stringToPointValue(@Nonnull String string) {
        String[] words = SPACE_PATTERN.split(string, 3);
        if (words.length < 1) {
            return null;
        }
        PointValue pointValue = new PointValue(words[0], Optional.empty(), null, null);
        if (words.length >= 2) {
            Optional<DateTime> stamp = DateTime.fromString(Optional.of(words[1]));
            if (stamp.isPresent()) {
                pointValue.setStamp(stamp.get());
            }
            if (words.length > 2) {
                int index;
                StringBuilder stringBuilder = new StringBuilder();
                string = words[2].trim();
                if (string.length() > 0 && string.charAt(0) == '[') {
                    index = 0;
                    boolean leftBracketSeen = false;
                    boolean rightBracketSeen = false;
                    while (true) {
                        if (++index >= string.length()) {
                            if (rightBracketSeen) break;
                            return null;
                        }
                        char c = string.charAt(index);
                        if (rightBracketSeen) {
                            if (c == '[') {
                                stringBuilder.append(c);
                                rightBracketSeen = false;
                                continue;
                            }
                            ++index;
                            break;
                        }
                        if (leftBracketSeen) {
                            if (c == ']') {
                                stringBuilder.append(c);
                                leftBracketSeen = false;
                                continue;
                            }
                            return null;
                        }
                        if (c == '[') {
                            leftBracketSeen = true;
                            continue;
                        }
                        if (c == ']') {
                            rightBracketSeen = true;
                            continue;
                        }
                        stringBuilder.append(c);
                    }
                    pointValue.setState((Serializable)((Object)stringBuilder.toString()));
                    stringBuilder.setLength(0);
                    string = string.substring(index).trim();
                }
                if (string.length() > 0 && string.charAt(0) == '\"') {
                    index = 0;
                    boolean quoteSeen = false;
                    while (true) {
                        if (++index >= string.length()) {
                            if (quoteSeen) break;
                            return null;
                        }
                        char c = string.charAt(index);
                        if (quoteSeen) {
                            if (c == '\"') {
                                stringBuilder.append(c);
                                quoteSeen = false;
                                continue;
                            }
                            return null;
                        }
                        if (c == '\"') {
                            quoteSeen = true;
                            continue;
                        }
                        stringBuilder.append(c);
                    }
                    pointValue.setValue((Serializable)((Object)stringBuilder.toString()));
                } else if (string.length() > 0) {
                    pointValue = string.charAt(0) == '-' ? new VersionedValue.Deleted(pointValue) : null;
                }
            }
        }
        return pointValue;
    }

    public static void trace(@Nonnull Messages.Entry entry, Object ... params) {
        PipeRequest.log(LogLevel.TRACE, entry, params);
    }

    public static void trace(@Nonnull String format, Object ... params) {
        PipeRequest.log(LogLevel.TRACE, format, params);
    }

    public static void warn(@Nonnull Messages.Entry entry, Object ... params) {
        PipeRequest.log(LogLevel.WARN, entry, params);
    }

    public static void warn(@Nonnull String format, Object ... params) {
        PipeRequest.log(LogLevel.WARN, format, params);
    }

    @Nonnull
    @CheckReturnValue
    public final String getRequestID() {
        return this._requestID;
    }

    @Nonnull
    @CheckReturnValue
    public final int getVersion() {
        return this._version;
    }

    @Nonnull
    @CheckReturnValue
    protected static Optional<String> firstLine() {
        String line;
        while ((line = PipeRequest._nextLine(false)) != null && line.indexOf(32) < 0) {
            if ("0".equals(line)) {
                line = null;
                break;
            }
            PipeRequest.writeLine(line);
        }
        return Optional.ofNullable(line);
    }

    @Nonnull
    @CheckReturnValue
    protected static String nextLine() {
        return PipeRequest._nextLine(true);
    }

    @Nonnull
    @CheckReturnValue
    protected static PointValue nextPointValue(boolean stampRequired) {
        String line = PipeRequest._nextLine(true);
        PointValue pointValue = PipeRequest.stringToPointValue(line);
        if (pointValue == null || stampRequired && !pointValue.hasStamp()) {
            throw PipeRequest.error("Unexpected point value format: " + line, new Object[0]);
        }
        return pointValue;
    }

    @CheckReturnValue
    protected static int parseInt(@Nonnull String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException exception) {
            throw PipeRequest.error("Bad number value: " + text, new Object[0]);
        }
    }

    protected static void writeLine(@Nonnull String line) {
        System.out.println(line);
        System.out.flush();
        PipeRequest.trace("Sent: {" + line + "}", new Object[0]);
    }

    protected static void writePointValue(@Nonnull PointValue pointValue) {
        PipeRequest.writeLine(PipeRequest.pointValueToString(pointValue));
    }

    private static String _nextLine(boolean required) {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int next;
            try {
                next = System.in.read();
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            if (next == -1) {
                if (stringBuilder.length() > 0) {
                    PipeRequest.warn("Lost characters at end of input", new Object[0]);
                }
                if (required) {
                    throw PipeRequest.error("Unexpected end of input", new Object[0]);
                }
                line = null;
                break;
            }
            if (LINE_SEPARATOR.endsWith(String.valueOf((char)next))) {
                line = stringBuilder.toString().trim();
                if (line.length() <= 0) continue;
                break;
            }
            if (LINE_SEPARATOR.indexOf(next) >= 0) continue;
            stringBuilder.append((char)next);
        }
        PipeRequest.trace("Received: {" + line + "}", new Object[0]);
        return line;
    }

    public static enum LogLevel {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

