/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.pipe;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.pipe.PipeRequest;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;

@Immutable
public final class PipeSinkRequest
extends PipeRequest {
    public static final String DELETE_REQUEST_TYPE = "-";
    public static final int REQUEST_FORMAT_VERSION = 1;
    public static final String UPDATE_REQUEST_TYPE = "+";
    private final PointValue _pointValue;

    private PipeSinkRequest(String requestID, int version, PointValue pointValue) {
        super(requestID, version);
        this._pointValue = pointValue;
    }

    @Nonnull
    @CheckReturnValue
    public static Optional<PipeSinkRequest> nextRequest() {
        PointValue pointValue;
        Optional<String> line = PipeSinkRequest.firstLine();
        if (!line.isPresent()) {
            return Optional.empty();
        }
        String[] words = SPACE_PATTERN.split(line.get(), 0);
        if (words.length != 3) {
            throw PipeSinkRequest.error("Unexpected request format: " + line, new Object[0]);
        }
        String requestID = words[0];
        int version = PipeSinkRequest.parseInt(words[1]);
        String requestType = words[2];
        if (UPDATE_REQUEST_TYPE.equals(requestType)) {
            pointValue = PipeSinkRequest.nextPointValue(true);
        } else if (DELETE_REQUEST_TYPE.equals(requestType)) {
            pointValue = new VersionedValue.Deleted(PipeSinkRequest.nextPointValue(false));
        } else {
            throw PipeSinkRequest.error("Unsupported request type: " + requestType, new Object[0]);
        }
        return Optional.of(new PipeSinkRequest(requestID, version, pointValue));
    }

    @Nonnull
    @CheckReturnValue
    public PointValue getPointValue() {
        return this._pointValue.copy();
    }

    @Nonnull
    @CheckReturnValue
    public RequestType getRequestType() {
        return this._pointValue.isDeleted() ? RequestType.DELETE : RequestType.UPDATE;
    }

    public void respond(int summary) {
        PipeSinkRequest.writeLine(this.getRequestID() + " " + summary);
    }

    public static enum RequestType {
        UPDATE("Update"),
        DELETE("Delete");

        private final String _name;

        private RequestType(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

