/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.SecureClientSocketFactory;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.tool.Require;

@ThreadSafe
public class ClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final int _WARN_LIMIT = 99;
    private static volatile int _warns;
    private static final long serialVersionUID = 1L;
    private static final Logger _LOGGER;
    private static final Map<UUID, SessionClientContext> _CONTEXTS;
    private transient SessionClientContext _context;
    private final String _logID;
    private final UUID _uuid;

    public ClientSocketFactory(@Nonnull UUID uuid) {
        this._uuid = uuid;
        this._logID = Logger.currentLogID().orElse(null);
    }

    @Override
    public final Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.newSocket(host, port);
        int timeout = this.getContext().getTimeout();
        if (timeout > 0) {
            socket.setSoTimeout(timeout);
            socket.setSoLinger(false, 0);
        }
        return socket;
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this._uuid.equals(((ClientSocketFactory)other)._uuid);
    }

    public final int hashCode() {
        return this._uuid.hashCode();
    }

    @Nonnull
    @CheckReturnValue
    protected synchronized SessionClientContext getContext() throws IOException {
        boolean logged = false;
        if (this._context == null) {
            this._context = _CONTEXTS.get(this._uuid);
            if (this._context != null) {
                Logger.setLogID(Optional.ofNullable(this._logID));
                _LOGGER.debug(BaseMessages.CLIENT_CONTEXT_CACHED, this._context.getServerURI(), this._uuid);
                logged = true;
            }
        }
        if (this._context == null) {
            try {
                throw new ConnectException("Context gone: " + this._uuid);
            }
            catch (ConnectException exception) {
                this._warnContextGone(exception);
                throw exception;
            }
        }
        if (_LOGGER.isTraceEnabled()) {
            if (!logged) {
                Logger.setLogID(Optional.ofNullable(this._logID));
            }
            _LOGGER.trace(BaseMessages.CLIENT_CONTEXT, this._context.getServerURI(), this._uuid);
        }
        return this._context;
    }

    @Nonnull
    @CheckReturnValue
    protected Socket newSocket(@Nonnull String host, int port) throws IOException {
        return new Socket(Require.notNull(host), port);
    }

    @CheckReturnValue
    static boolean register(@Nonnull SessionClientContext context) {
        return _CONTEXTS.put(context.getUUID(), context) == null;
    }

    @CheckReturnValue
    static boolean unregister(@Nonnull SessionClientContext context) {
        return _CONTEXTS.remove(context.getUUID()) != null;
    }

    private synchronized void _warnContextGone(@Nonnull Exception exception) {
        if (_warns <= 99) {
            _LOGGER.warn((Throwable)exception, BaseMessages.CLIENT_CONTEXT_GONE, this._uuid);
            if (++_warns > 99) {
                _LOGGER.warn(BaseMessages.CLIENT_CONTEXT_WARNINGS, new Object[0]);
            }
        }
    }

    static {
        _LOGGER = Logger.getInstance(SecureClientSocketFactory.class);
        _CONTEXTS = new ConcurrentHashMap<UUID, SessionClientContext>();
    }
}

