/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.net.InetSocketAddress;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.util.container.KeyedGroups;

public final class RegistryConfig {
    public static final String ADDRESS_PROPERTY = "address";
    public static final String DEFAULT_ADDRESS = "127.0.0.1";
    public static final String PORT_PROPERTY = "port";
    public static final String PRIVATE_PROPERTY = "private";
    public static final String PROTECTED_PROPERTY = "protected";
    public static final String RMI_REGISTRY_PROPERTIES = "rmi.registry";
    public static final String SHARED_PROPERTY = "shared";
    private final KeyedGroups _rmiRegistryProperties;

    public RegistryConfig(@Nonnull KeyedGroups contextProperties) {
        this._rmiRegistryProperties = contextProperties.getGroup(RMI_REGISTRY_PROPERTIES);
    }

    @CheckReturnValue
    public int getRegistryPort() {
        int registryPort = this._rmiRegistryProperties.getInt(PORT_PROPERTY, 0);
        if (registryPort == 0) {
            InetSocketAddress registrySocketAddress = this.getRegistrySocketAddress();
            if (registrySocketAddress == null) {
                return -1;
            }
            registryPort = registrySocketAddress.getPort();
        }
        return registryPort;
    }

    @Nullable
    @CheckReturnValue
    public InetSocketAddress getRegistrySocketAddress() {
        String addressProperty = this._rmiRegistryProperties.getString(ADDRESS_PROPERTY, Optional.of(DEFAULT_ADDRESS)).get();
        InetSocketAddress registryAddress = Inet.socketAddress(addressProperty).orElse(null);
        if (registryAddress == null) {
            Logger.getInstance(RegistryConfig.class).warn(BaseMessages.BAD_ADDRESS, addressProperty);
        } else if (registryAddress.getPort() != 0) {
            int registryPort = this._rmiRegistryProperties.getInt(PORT_PROPERTY, 0);
            if (registryPort != 0 && registryAddress.getPort() != registryPort) {
                Logger.getInstance(RegistryEntry.class).error(BaseMessages.RMI_REGISTRY_CONFLICT, String.valueOf(registryAddress.getPort()), String.valueOf(registryPort));
                registryAddress = null;
            }
        } else {
            registryAddress = new InetSocketAddress(registryAddress.getAddress(), this._rmiRegistryProperties.getInt(PORT_PROPERTY, 0));
        }
        return registryAddress;
    }

    @CheckReturnValue
    public boolean isRegistryPrivate() {
        return this._rmiRegistryProperties.getBoolean(PRIVATE_PROPERTY);
    }

    @CheckReturnValue
    public boolean isRegistryReadOnly() {
        return this._rmiRegistryProperties.getBoolean(PROTECTED_PROPERTY);
    }

    @CheckReturnValue
    public boolean isRegistryShared() {
        return this._rmiRegistryProperties.getBoolean(SHARED_PROPERTY);
    }
}

