/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.AccessException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Inet;
import org.rvpf.base.tool.Require;

public final class RegistryEntry {
    private static Registry _registry;
    private static boolean _registryIsPrivate;
    private final boolean _local;
    private final boolean _remote;
    private final URI _uri;

    RegistryEntry(@Nonnull URI uri, boolean local) {
        if ("/".equals(uri.getPath())) {
            throw new IllegalArgumentException(Message.format(BaseMessages.MISSING_SERVER_IDENT, new Object[0]));
        }
        this._uri = uri;
        this._local = local;
        this._remote = !Inet.isOnLocalHost(this._uri);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    public static void setRegistry(@Nonnull Registry registry, boolean registryIsPrivate) {
        _registry = Require.notNull(registry);
        _registryIsPrivate = registryIsPrivate;
    }

    @Nonnull
    @CheckReturnValue
    public String getLookupKey() {
        return this._local && _registry != null ? RegistryEntry._getPath(this._uri) : this._uri.getSchemeSpecificPart();
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return RegistryEntry._getName(RegistryEntry._getPath(this._uri));
    }

    @Nonnull
    @CheckReturnValue
    public String getPath() {
        return RegistryEntry._getPath(this._uri);
    }

    @Nonnull
    @CheckReturnValue
    public URI getURI() {
        return this._uri;
    }

    public boolean isPrivate() {
        return this._local && _registryIsPrivate;
    }

    public boolean isRemote() {
        return this._remote;
    }

    @Nonnull
    @CheckReturnValue
    public Remote lookup(@Nonnull String sessionMode, Logger logger) throws AccessException, RemoteException, NotBoundException {
        Remote remote;
        String lookupKey = this.getLookupKey();
        if (sessionMode.length() > 0) {
            sessionMode = " (" + sessionMode + ")";
        }
        logger.debug(BaseMessages.SESSION_SERVER, sessionMode, lookupKey);
        if (this._local && _registry != null) {
            remote = _registry.lookup(lookupKey);
        } else {
            try {
                remote = Naming.lookup(lookupKey);
            }
            catch (MalformedURLException exception) {
                throw new InternalError(exception);
            }
        }
        return remote;
    }

    public String toString() {
        return this.isPrivate() ? RegistryEntry._getPath(this._uri) : this._uri.toString();
    }

    static String _getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    static String _getPath(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            path = "";
        } else if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public static final class Builder {
        private static final Logger _LOGGER = Logger.getInstance(Builder.class);
        private String _binding;
        private String _defaultName;
        private String _defaultPrefix;
        private InetAddress _defaultRegistryAddress;
        private int _defaultRegistryPort;
        private String _name;

        Builder() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        @CheckReturnValue
        public RegistryEntry build() {
            boolean local;
            URI uri;
            if (this._defaultPrefix != null && !this._defaultPrefix.isEmpty() && !this._defaultPrefix.endsWith("/")) {
                this._defaultPrefix = this._defaultPrefix + "/";
            }
            if (this._binding != null) {
                uri = this._absoluteURI(this._binding, null);
                if (uri == null) {
                    return null;
                }
                local = false;
            } else {
                uri = null;
                local = true;
            }
            if (uri == null) {
                if (this._name == null) {
                    this._name = this._defaultName;
                }
                if (this._name == null) {
                    _LOGGER.error(BaseMessages.MISSING_BINDING, new Object[0]);
                    return null;
                }
                uri = this._absoluteURI(this._name, this._defaultPrefix);
                if (uri == null) {
                    return null;
                }
            } else if (this._name == null) {
                String path = uri.getPath();
                this._name = RegistryEntry._getName(path);
                if (this._name.isEmpty()) {
                    if (this._defaultName == null) {
                        _LOGGER.error(BaseMessages.MISSING_NAME, new Object[0]);
                        return null;
                    }
                    path = this._defaultPrefix != null ? this._defaultPrefix + this._defaultName : this._defaultName;
                    uri = uri.resolve(path);
                }
            } else if ("/".equals(uri.getPath())) {
                String path = uri.getPath();
                if (this._defaultPrefix != null && this._name.indexOf(47) < 0) {
                    path = path + this._defaultPrefix;
                }
                path = path + this._name;
                try {
                    uri = uri.resolve(new URI(path));
                }
                catch (URISyntaxException exception) {
                    _LOGGER.error(BaseMessages.BAD_ADDRESS, this._name);
                    return null;
                }
            }
            if (!"rmi".equals(uri.getScheme())) {
                _LOGGER.error(BaseMessages.SCHEME_NOT_SUPPORTED, uri.getScheme());
                return null;
            }
            return new RegistryEntry(uri, local);
        }

        @Nonnull
        public Builder clear() {
            this._binding = null;
            this._defaultName = null;
            this._defaultPrefix = null;
            this._defaultRegistryAddress = null;
            this._defaultRegistryPort = 0;
            return this;
        }

        @Nonnull
        public Builder copyFrom(@Nonnull RegistryEntry registryEntry) {
            this.setServerURI(registryEntry.getURI());
            return this;
        }

        @Nonnull
        public Builder setBinding(@Nonnull Optional<String> binding) {
            this._binding = binding.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setDefaultName(@Nonnull String defaultName) {
            this._defaultName = Require.notNull(defaultName);
            return this;
        }

        @Nonnull
        public Builder setDefaultPrefix(@Nonnull String defaultPrefix) {
            this._defaultPrefix = Require.notNull(defaultPrefix);
            return this;
        }

        @Nonnull
        public Builder setDefaultRegistryAddress(@Nonnull Optional<InetAddress> defaultRegistryAddress) {
            this._defaultRegistryAddress = defaultRegistryAddress.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setDefaultRegistryPort(int defaultRegistryPort) {
            this._defaultRegistryPort = defaultRegistryPort;
            return this;
        }

        @Nonnull
        public Builder setName(@Nonnull Optional<String> name) {
            this._name = name.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setServer(@Nonnull String server) throws URISyntaxException {
            return this.setServerURI(new URI(server));
        }

        @Nonnull
        public Builder setServerURI(@Nonnull URI serverURI) {
            if (serverURI.getRawAuthority() != null) {
                this._binding = serverURI.toString();
                this._name = null;
            } else {
                this._binding = null;
                this._name = RegistryEntry._getPath(serverURI);
            }
            return this;
        }

        private URI _absoluteURI(String string, String defaultPrefix) {
            URI uri;
            if (defaultPrefix != null && !string.contains("/")) {
                string = defaultPrefix + string;
            }
            try {
                uri = new URI(string);
                String scheme = uri.getScheme();
                String authority = uri.getAuthority();
                if (authority == null) {
                    authority = (this._defaultRegistryAddress == null || this._defaultRegistryAddress.isAnyLocalAddress() ? "127.0.0.1" : this._defaultRegistryAddress.getHostAddress()) + (this._defaultRegistryPort > 0 ? ":" + String.valueOf(this._defaultRegistryPort) : "");
                } else if (uri.getPort() < 0 && this._defaultRegistryPort > 0) {
                    authority = authority + ":" + String.valueOf(this._defaultRegistryPort);
                }
                String path = uri.getPath();
                if (path == null) {
                    path = "/";
                } else if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                uri = new URI(scheme != null ? scheme : "rmi", authority, path, null, null);
            }
            catch (URISyntaxException exception) {
                _LOGGER.error(BaseMessages.BAD_ADDRESS, string);
                uri = null;
            }
            return uri;
        }
    }
}

