/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Messages;
import org.rvpf.base.rmi.SessionException;

public interface Session
extends Remote {
    @Nullable
    @CheckReturnValue
    public ConnectionMode getConnectionMode() throws RemoteException;

    public void login(@Nullable String var1, @Nullable char[] var2) throws RemoteException, SessionException;

    public void logout() throws RemoteException, SessionException;

    public static enum ConnectionMode {
        PRIVATE(BaseMessages.CONNECTION_PRIVATE),
        LOCAL(BaseMessages.CONNECTION_LOCAL),
        SECURE(BaseMessages.CONNECTION_SECURE),
        CERTIFIED(BaseMessages.CONNECTION_CERTIFIED);

        private final Messages.Entry _messagesEntry;

        private ConnectionMode(Messages.Entry messagesEntry) {
            this._messagesEntry = messagesEntry;
        }

        @CheckReturnValue
        public boolean isCertified() {
            return this == CERTIFIED;
        }

        @CheckReturnValue
        public boolean isLocal() {
            return this == LOCAL;
        }

        @CheckReturnValue
        public boolean isPrivate() {
            return this == PRIVATE;
        }

        @CheckReturnValue
        public boolean isSecure() {
            return !this.isLocal();
        }

        public String toString() {
            return this._messagesEntry.toString();
        }
    }
}

