/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.net.URI;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.rmi.ClientSocketFactory;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.security.ClientSecurityContext;
import org.rvpf.base.tool.Require;

@ThreadSafe
public final class SessionClientContext {
    private final Logger _logger;
    @GuardedBy(value="this")
    private int _registrations;
    private final RegistryEntry _registryEntry;
    private final ClientSecurityContext _securityContext;
    private volatile int _timeout;
    private final UUID _uuid;

    public SessionClientContext(@Nonnull RegistryEntry registryEntry, @Nonnull Logger logger) {
        this._registryEntry = Require.notNull(registryEntry);
        this._logger = Require.notNull(logger);
        this._uuid = UUID.generate();
        this._securityContext = new ClientSecurityContext(logger);
    }

    @Nonnull
    @CheckReturnValue
    public ClientSecurityContext getSecurityContext() {
        return this._securityContext;
    }

    @Nonnull
    @CheckReturnValue
    public String getServerName() {
        return this._registryEntry.getLookupKey();
    }

    @Nonnull
    @CheckReturnValue
    public URI getServerURI() {
        return this._registryEntry.getURI();
    }

    @Nonnegative
    @CheckReturnValue
    public int getTimeout() {
        return this._timeout;
    }

    @Nonnull
    @CheckReturnValue
    public UUID getUUID() {
        return this._uuid;
    }

    @CheckReturnValue
    public boolean isPrivate() {
        return this._registryEntry.isPrivate();
    }

    @CheckReturnValue
    public boolean isRemote() {
        return this._registryEntry.isRemote();
    }

    @Nonnull
    @CheckReturnValue
    public Remote lookup(@Nonnull String sessionMode) throws AccessException, RemoteException, NotBoundException {
        return this._registryEntry.lookup(sessionMode, this._logger);
    }

    public synchronized boolean register() {
        if (this.isPrivate()) {
            return true;
        }
        String serverName = this.getServerName();
        if (this._registrations == 0) {
            if (!ClientSocketFactory.register(this)) {
                throw new RuntimeException(Message.format(BaseMessages.CONTEXT_REGISTER_FAILED, this.getUUID(), serverName));
            }
            this._logger.debug(BaseMessages.CONTEXT_REGISTERED, this.getUUID(), serverName);
        }
        return ++this._registrations == 1;
    }

    public void setTimeout(@Nonnegative int timeout) {
        this._timeout = timeout;
    }

    public synchronized boolean unregister() {
        if (this.isPrivate()) {
            return true;
        }
        Require.success(this._registrations > 0);
        String serverName = this.getServerName();
        if (this._registrations == 1) {
            if (!ClientSocketFactory.unregister(this)) {
                throw new RuntimeException(Message.format(BaseMessages.CONTEXT_UNREGISTER_FAILED, this.getUUID(), serverName));
            }
            this._logger.debug(BaseMessages.CONTEXT_UNREGISTERED, this.getUUID(), serverName);
        }
        return --this._registrations == 0;
    }

    @Nonnull
    @CheckReturnValue
    Logger getLogger() {
        return this._logger;
    }
}

