/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.rmi;

import java.io.InterruptedIOException;
import java.net.URI;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.CatchedSessionException;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionNotConnectedException;
import org.rvpf.base.security.ClientSecurityContext;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;

@ThreadSafe
public abstract class SessionProxy
implements Session {
    private final boolean _autoconnect;
    private final String _clientName;
    private final ReentrantLock _connectMutex = new ReentrantLock();
    private final SessionClientContext _context;
    private Remote _factory;
    private final Listener _listener;
    private final Logger _logger = Logger.getInstance(this.getClass());
    private final LoginInfo _loginInfo;
    private Session _session;

    protected SessionProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<Listener> listener, boolean autoconnect) {
        this._clientName = Require.notNull(clientName);
        this._loginInfo = loginInfo.orElse(null);
        this._context = Require.notNull(context);
        this._listener = listener.orElse(null);
        this._autoconnect = autoconnect;
    }

    public void connect() throws SessionConnectFailedException {
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            throw new SessionConnectFailedException((Exception)exception.getCause());
        }
        try {
            if (this._context == null || this._session != null) {
                return;
            }
            this._context.register();
            try {
                this._session = this.createSession();
                if (this._loginInfo != null) {
                    this._session.login(this._loginInfo.getUser().orElse(null), this._loginInfo.getPassword().orElse(null));
                }
            }
            catch (SessionConnectFailedException exception) {
                this._session = null;
                throw exception;
            }
            catch (Exception exception) {
                this._session = null;
                throw new SessionConnectFailedException(exception);
            }
            finally {
                if (this._session == null) {
                    this._context.unregister();
                    this._factory = null;
                }
            }
            Listener listener = this._listener;
            if (listener != null && !listener.onSessionConnected(this)) {
                this.disconnect();
                throw new SessionConnectVetoException();
            }
        }
        finally {
            this.unlockConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            Listener listener;
            Session session = this._session;
            if (session != null) {
                try {
                    this._session.logout();
                }
                catch (NoSuchObjectException noSuchObjectException) {
                }
                finally {
                    this._session = null;
                }
                if (this._context != null) {
                    this._context.unregister();
                }
            }
            this._factory = null;
            if (session != null && (listener = this._listener) != null) {
                listener.onSessionDisconnected(this);
            }
        }
        catch (Exception exception) {
            this.getThisLogger().debug((Throwable)exception, BaseMessages.DISCONNECT_FAILED, new Object[0]);
        }
        finally {
            this.unlockConnect();
        }
    }

    @Override
    public Session.ConnectionMode getConnectionMode() {
        Session.ConnectionMode connectionMode;
        this.lockConnect();
        try {
            if (this._session == null) {
                Session.ConnectionMode connectionMode2 = null;
                return connectionMode2;
            }
            try {
                connectionMode = this._session.getConnectionMode();
            }
            catch (RemoteException exception) {
                throw new RuntimeException(exception);
            }
        }
        finally {
            this.unlockConnect();
        }
        return connectionMode;
    }

    @Nonnull
    @CheckReturnValue
    public SessionClientContext getContext() {
        SessionClientContext context;
        this.lockConnect();
        try {
            context = this._context;
        }
        finally {
            this.unlockConnect();
        }
        Require.notNull(context, BaseMessages.PROXY_NOT_SET_UP);
        return context;
    }

    @Nonnull
    @CheckReturnValue
    public UUID getContextUUID() {
        return this.getContext().getUUID();
    }

    @Nonnull
    @CheckReturnValue
    public String getServerName() {
        String serverName;
        this.lockConnect();
        try {
            Require.notNull(this._context, BaseMessages.PROXY_NOT_SET_UP);
            serverName = this._context.getServerName();
        }
        finally {
            this.unlockConnect();
        }
        return serverName;
    }

    @Nonnull
    @CheckReturnValue
    public URI getServerURI() {
        return this.getContext().getServerURI();
    }

    @CheckReturnValue
    public final boolean hasLoginInfo() {
        return this._loginInfo != null;
    }

    @CheckReturnValue
    public boolean isConnected() {
        boolean isConnected;
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            Thread.currentThread().interrupt();
            return false;
        }
        try {
            isConnected = this._session != null;
        }
        finally {
            this.unlockConnect();
        }
        return isConnected;
    }

    @CheckReturnValue
    public boolean isPrivate() {
        return this.getContext().isPrivate();
    }

    @CheckReturnValue
    public boolean isRemote() {
        return this.getContext().isRemote();
    }

    @Override
    public void login(String identifier, char[] password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void logout() {
        throw new UnsupportedOperationException();
    }

    public void tearDown() {
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.disconnect();
        }
        finally {
            this._factory = null;
            this.unlockConnect();
        }
    }

    @Nonnull
    @CheckReturnValue
    protected abstract Session createSession() throws RemoteException, SessionException;

    @Nonnull
    @CheckReturnValue
    protected String getClientName() {
        return this._clientName;
    }

    @Nonnull
    @CheckReturnValue
    protected final Remote getFactory() throws SessionConnectFailedException {
        Remote factory;
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            throw new SessionConnectFailedException((Exception)exception.getCause());
        }
        try {
            if (this._factory == null) {
                Require.notNull(this._context, BaseMessages.PROXY_NOT_SET_UP);
                try {
                    this._factory = this._context.lookup(this.sessionMode());
                }
                catch (Exception exception) {
                    throw new SessionConnectFailedException(exception);
                }
            }
            factory = this._factory;
        }
        finally {
            this.unlockConnect();
        }
        return factory;
    }

    @Nonnull
    @CheckReturnValue
    protected final Session getSession() throws SessionException {
        Session session;
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            Exception exceptionCause = (Exception)exception.getCause();
            if (exceptionCause instanceof InterruptedException) {
                throw new ServiceClosedException(exceptionCause);
            }
            throw new SessionConnectFailedException(exceptionCause);
        }
        try {
            if (this._session == null) {
                if (this._autoconnect) {
                    this.connect();
                }
                if (this._session == null) {
                    throw new SessionNotConnectedException();
                }
            }
            session = this._session;
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        finally {
            this.unlockConnect();
        }
        return session;
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return this._logger;
    }

    protected void lockConnect() {
        this._connectMutex.lock();
    }

    protected void lockConnectInterruptibly() throws CatchedSessionException {
        try {
            this._connectMutex.lockInterruptibly();
        }
        catch (InterruptedException exception) {
            throw new CatchedSessionException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    protected SessionException sessionException(@Nonnull Exception exception) {
        SessionException sessionException = exception instanceof SessionException ? (SessionException)exception : (exception instanceof NoSuchObjectException ? new ServiceClosedException(exception) : (exception instanceof InterruptedException ? new ServiceClosedException(exception) : (exception instanceof RemoteException && exception.getCause() instanceof InterruptedIOException ? new ServiceClosedException((InterruptedIOException)exception.getCause()) : (exception instanceof ServerError ? new SessionException(exception) : new CatchedSessionException(exception)))));
        if (this._autoconnect) {
            this.disconnect();
        }
        return sessionException;
    }

    @Nonnull
    @CheckReturnValue
    protected String sessionMode() {
        return "";
    }

    protected void unlockConnect() {
        this._connectMutex.unlock();
    }

    public static final class SessionConnectVetoException
    extends SessionConnectFailedException {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class Builder {
        private boolean _autoconnect;
        private Logger _clientLogger;
        private String _clientName;
        private KeyedGroups _configProperties;
        private SessionClientContext _context;
        private Listener _listener;
        private LoginInfo _loginInfo;
        private char[] _loginPassword;
        private String _loginUser;
        private RegistryEntry _registryEntry;
        private KeyedGroups _securityProperties;

        @Nullable
        @CheckReturnValue
        public abstract SessionProxy build();

        @Nonnull
        public Builder setAutoconnect(boolean autoconnect) {
            this._autoconnect = autoconnect;
            return this;
        }

        @Nonnull
        public Builder setClientLogger(@Nonnull Logger clientLogger) {
            this._clientLogger = clientLogger;
            return this;
        }

        @Nonnull
        public Builder setClientName(@Nonnull String clientName) {
            this._clientName = clientName;
            return this;
        }

        @Nonnull
        public Builder setConfigProperties(@Nonnull KeyedGroups configProperties) {
            this._configProperties = Require.notNull(configProperties);
            return this;
        }

        @Nonnull
        public Builder setListener(@Nonnull Listener listener) {
            this._listener = Require.notNull(listener);
            return this;
        }

        @Nonnull
        public Builder setLoginInfo(@Nonnull LoginInfo loginInfo) {
            this._loginUser = loginInfo.getUser().orElse(null);
            this._loginPassword = loginInfo.getPassword().orElse(null);
            return this;
        }

        @Nonnull
        public Builder setLoginPassword(@Nonnull Optional<char[]> loginPassword) {
            this._loginPassword = loginPassword.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setLoginUser(@Nonnull Optional<String> loginUser) {
            this._loginUser = loginUser.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setRegistryEntry(@Nonnull RegistryEntry registryEntry) {
            this._registryEntry = registryEntry;
            return this;
        }

        @Nonnull
        public Builder setSecurityProperties(@Nonnull KeyedGroups securityProperties) {
            this._securityProperties = Require.notNull(securityProperties);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        protected String getClientName() {
            return this._clientName;
        }

        @Nonnull
        @CheckReturnValue
        protected SessionClientContext getContext() {
            return this._context;
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<Listener> getListener() {
            return Optional.ofNullable(this._listener);
        }

        @Nonnull
        @CheckReturnValue
        protected Optional<LoginInfo> getLoginInfo() {
            return Optional.ofNullable(this._loginInfo);
        }

        @CheckReturnValue
        protected boolean isAutoconnect() {
            return this._autoconnect;
        }

        @CheckReturnValue
        protected boolean setUp() {
            this._context = new SessionClientContext(this._registryEntry, this._clientLogger);
            ClientSecurityContext securityContext = this._context.getSecurityContext();
            if (!securityContext.setUp(this._configProperties != null ? this._configProperties : KeyedGroups.MISSING_KEYED_GROUP, this._securityProperties != null ? this._securityProperties : KeyedGroups.MISSING_KEYED_GROUP)) {
                return false;
            }
            if (this._loginInfo == null) {
                LoginInfo loginInfo = new LoginInfo(Optional.ofNullable(this._loginUser), Optional.ofNullable(this._loginPassword));
                this._loginInfo = loginInfo.isEnabled() ? loginInfo : null;
            }
            return true;
        }
    }

    public static interface Listener {
        @CheckReturnValue
        public boolean onSessionConnected(@Nonnull SessionProxy var1);

        public void onSessionDisconnected(@Nonnull SessionProxy var1);
    }
}

