/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.security.SecurityContext;

@ThreadSafe
public final class ClientSecurityContext
extends SecurityContext {
    @GuardedBy(value="this")
    private SocketFactory _socketFactory;

    public ClientSecurityContext(@Nonnull Logger logger) {
        super(logger);
    }

    @Nonnull
    @CheckReturnValue
    public synchronized SocketFactory getSSLSocketFactory() throws SSLException {
        if (this._socketFactory == null) {
            this._socketFactory = this.createSSLContext().getSocketFactory();
        }
        return this._socketFactory;
    }

    @Override
    protected synchronized void useDefaults() throws SSLException {
        if (this._socketFactory == null) {
            super.useDefaults();
            if (!this.getTrustStoreConfig().getPath().isPresent() && !this.getKeyStoreConfig().getPath().isPresent()) {
                throw new SSLException(Message.format(BaseMessages.NO_SECURE, new Object[0]));
            }
        }
    }
}

