/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.util.Arrays;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.security.UnixCrypt;
import org.rvpf.base.tool.Require;

public final class Credential {
    public static final String CRYPT_PREFIX = "CRYPT:";
    private final boolean _crypt;
    private final char[] _password;

    public Credential(@Nonnull char[] password) {
        int i = 0;
        while (true) {
            if (i == CRYPT_PREFIX.length()) {
                this._password = Arrays.copyOfRange(password, i, password.length);
                this._crypt = true;
                break;
            }
            if (i >= password.length || password[i] != CRYPT_PREFIX.charAt(i)) {
                this._password = password;
                this._crypt = false;
                break;
            }
            ++i;
        }
    }

    @CheckReturnValue
    boolean check(@Nonnull Object credential) {
        if (Require.notNull(credential) instanceof String) {
            credential = ((String)credential).toCharArray();
        }
        if (credential instanceof char[]) {
            char[] password = (char[])credential;
            if (this._crypt) {
                password = UnixCrypt.crypt(password, new String(this._password, 0, 2)).toCharArray();
            }
            return Arrays.equals(password, this._password);
        }
        return false;
    }
}

