/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ClassDef;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.security.CryptEngineWrapper;
import org.rvpf.base.security.CryptException;
import org.rvpf.base.security.Encrypted;
import org.rvpf.base.security.Signed;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.ProxyReader;
import org.rvpf.base.util.container.KeyedGroups;
import org.rvpf.base.xml.XMLDocument;
import org.rvpf.base.xml.streamer.Streamer;

public final class Crypt {
    public static final String CLASS_PROPERTY = "class";
    public static final String DECRYPT_KEY_PROPERTY = "devrypt.key";
    public static final String DECRYPT_PROPERTY = "decrypt";
    public static final String ENCRYPT_KEY_PROPERTY = "encrypt.key";
    public static final String ENCRYPT_PROPERTY = "encrypt";
    public static final String IDENT_PROPERTY = "ident";
    public static final String KEY_PROPERTIES = "key";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String PATH_PROPERTY = "path";
    public static final String PRIVATE_PROPERTIES = "private";
    public static final String PUBLIC_PROPERTIES = "public";
    public static final String SIGN_KEY_PROPERTY = "sign.key";
    public static final String SIGN_PROPERTY = "sign";
    public static final String VERIFY_KEY_PROPERTY = "verify.key";
    public static final String VERIFY_PROPERTY = "verify";
    private static final Logger _LOGGER = Logger.getInstance(Crypt.class);
    private final AtomicReference<CryptEngineWrapper> _engineWrapper = new AtomicReference();
    private final ByteArrayOutputStream _outputStream = new ByteArrayOutputStream();
    private final ProxyReader _reader = new ProxyReader();
    private final Streamer _streamer = Streamer.newInstance();
    private Streamer.Input _streamerInput;
    private Streamer.Output _streamerOutput;
    private final CharArrayWriter _writer = new CharArrayWriter();

    @Nonnull
    @CheckReturnValue
    public static Class<?> encryptedClass() {
        return Encrypted.class;
    }

    @CheckReturnValue
    public static boolean isEncrypted(@Nonnull Serializable serializable) {
        return serializable instanceof Encrypted;
    }

    @CheckReturnValue
    public static boolean isSigned(@Nonnull Serializable serializable) {
        return serializable instanceof Signed;
    }

    @Nonnull
    @CheckReturnValue
    public static Serializable newEncrypted(@Nonnull String encrypted) {
        return new Encrypted(encrypted);
    }

    @Nonnull
    @CheckReturnValue
    public static Serializable newSigned(@Nonnull Serializable serializable, @Nonnull String signed) {
        return new Signed(serializable, signed);
    }

    @Nonnull
    @CheckReturnValue
    public static Class<?> signedClass() {
        return Signed.class;
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Result decrypt(@Nonnull Serializable serializable, @Nonnull String[] decryptionKeyIdents) {
        Result result;
        block7: {
            if (!(serializable instanceof Encrypted)) {
                return new Result(serializable, false, Optional.empty());
            }
            try {
                String encrypted = ((Encrypted)serializable).getEncrypted();
                _LOGGER.trace(BaseMessages.DECRYPTING, encrypted);
                byte[] encryptedBytes = encrypted.getBytes(StandardCharsets.UTF_8);
                CryptEngineWrapper engineWrapper = this._engineWrapper.get();
                this._outputStream.reset();
                engineWrapper.decrypt(new ByteArrayInputStream(encryptedBytes), Require.notNull(decryptionKeyIdents), this._outputStream);
                try {
                    this._reader.setProxied(Optional.of(new StringReader(this._outputStream.toString(StandardCharsets.UTF_8.name()))));
                }
                catch (UnsupportedEncodingException exception) {
                    throw new InternalError(exception);
                }
                result = new Result(this._streamerInput.next(), false, Optional.empty());
                this._reader.setProxied(Optional.empty());
                if (!_LOGGER.isTraceEnabled()) break block7;
                try {
                    _LOGGER.trace(BaseMessages.DECRYPTED, this._outputStream.toString(StandardCharsets.UTF_8.name()));
                }
                catch (UnsupportedEncodingException exception) {
                    throw new InternalError(exception);
                }
            }
            catch (CryptException exception) {
                result = new Result(null, false, Optional.of(exception));
            }
        }
        return result;
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Result encrypt(@Nullable Serializable serializable, @Nonnull String[] encryptionKeyIdents) {
        Result result;
        try {
            String xmlString = this._toXML(serializable);
            _LOGGER.trace(BaseMessages.ENCRYPTING, xmlString);
            byte[] xmlBytes = xmlString.getBytes(StandardCharsets.UTF_8);
            CryptEngineWrapper engineWrapper = this._engineWrapper.get();
            this._outputStream.reset();
            engineWrapper.encrypt(new ByteArrayInputStream(xmlBytes), Require.notNull(encryptionKeyIdents), this._outputStream);
            try {
                result = new Result(new Encrypted(this._outputStream.toString(StandardCharsets.UTF_8.name())), false, Optional.empty());
            }
            catch (UnsupportedEncodingException exception) {
                throw new InternalError(exception);
            }
            _LOGGER.trace(BaseMessages.ENCRYPTED, result.getSerializable());
        }
        catch (CryptException exception) {
            result = new Result(null, false, Optional.of(exception));
        }
        return result;
    }

    @Nonnull
    @CheckReturnValue
    public Result encryptAndSign(@Nullable Serializable serializable, @Nonnull String[] encryptionKeyIdents, @Nonnull String[] signingKeyIdents) {
        Result result = this.encrypt(serializable, encryptionKeyIdents);
        if (result.isSuccess()) {
            result = this.sign(result.getSerializable(), signingKeyIdents);
        }
        return result;
    }

    @Nonnull
    @CheckReturnValue
    public Streamer getStreamer() {
        return this._streamer;
    }

    @CheckReturnValue
    public synchronized boolean isSecure() {
        CryptEngineWrapper engineWrapper = this._engineWrapper.get();
        return engineWrapper.isSecure();
    }

    @Nullable
    @CheckReturnValue
    public Serializable load(@Nonnull File fromFile, boolean verify, @Nonnull String[] verifyKeyIdents, boolean decrypt, @Nonnull String[] decryptKeyIdents) {
        XMLDocument xmlDocument = XMLDocument.load(fromFile);
        if (xmlDocument == null) {
            return null;
        }
        return this.load(xmlDocument, fromFile.getAbsolutePath(), verify, verifyKeyIdents, decrypt, decryptKeyIdents);
    }

    @Nullable
    @CheckReturnValue
    public Serializable load(@Nonnull XMLDocument xmlDocument, @Nonnull String origin, boolean verify, @Nonnull String[] verifyKeyIdents, boolean decrypt, @Nonnull String[] decryptKeyIdents) {
        Result cryptResult;
        Streamer.Input streamerInput = this._streamer.newInput(xmlDocument);
        if (!streamerInput.hasNext()) {
            _LOGGER.error(BaseMessages.NOTHING_RECOGNIZABLE, origin);
            return null;
        }
        Serializable serializable = streamerInput.next();
        streamerInput.close();
        if (serializable == null) {
            _LOGGER.error(BaseMessages.NOTHING_RECOGNIZABLE, origin);
            return null;
        }
        if (verify) {
            cryptResult = this.verify(serializable, verifyKeyIdents);
            if (cryptResult.isFailure()) {
                CryptException exception = cryptResult.getException();
                if (exception.getCause() != null) {
                    throw new RuntimeException(exception.getCause());
                }
                _LOGGER.warn(BaseMessages.VERIFICATION_FAILED_, exception.getMessage());
                return null;
            }
            if (!cryptResult.isVerified()) {
                _LOGGER.warn(BaseMessages.VERIFICATION_FAILED, new Object[0]);
                return null;
            }
            serializable = cryptResult.getSerializable();
            Require.notNull(serializable);
        }
        if (decrypt) {
            cryptResult = this.decrypt(serializable, decryptKeyIdents);
            if (cryptResult.isFailure()) {
                CryptException exception = cryptResult.getException();
                if (exception.getCause() != null) {
                    throw new RuntimeException(exception.getCause());
                }
                _LOGGER.warn(BaseMessages.DECRYPTION_FAILED_, exception.getMessage());
                return null;
            }
            serializable = Require.notNull(cryptResult.getSerializable());
        }
        return serializable;
    }

    @CheckReturnValue
    public synchronized boolean setUp(@Nonnull KeyedGroups cryptProperties, @Nonnull Optional<KeyedGroups> streamerProperties) {
        if (!this._streamer.setUp(streamerProperties, Optional.empty())) {
            return false;
        }
        this._streamerInput = this._streamer.newInput(this._reader);
        this._streamerOutput = this._streamer.newOutput(this._writer);
        ClassDef cryptClassDef = cryptProperties.getClassDef(CLASS_PROPERTY, CryptEngineWrapper.IMPL);
        CryptEngineWrapper engineWrapper = cryptClassDef.createInstance(CryptEngineWrapper.class);
        if (engineWrapper == null) {
            return false;
        }
        _LOGGER.debug(BaseMessages.CRYPT_ENGINE_WRAPPER, engineWrapper.getClass().getSimpleName());
        if (!engineWrapper.setUp(cryptProperties)) {
            return false;
        }
        this._engineWrapper.set(engineWrapper);
        return true;
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Result sign(@Nullable Serializable serializable, @Nonnull String[] signingKeyIdents) {
        Result result;
        try {
            Signed signed;
            String xmlString = this._toXML(serializable);
            _LOGGER.trace(BaseMessages.SIGNING, xmlString);
            byte[] xmlBytes = xmlString.getBytes(StandardCharsets.UTF_8);
            CryptEngineWrapper engineWrapper = this._engineWrapper.get();
            this._outputStream.reset();
            engineWrapper.sign(new ByteArrayInputStream(xmlBytes), Require.notNull(signingKeyIdents), this._outputStream);
            try {
                signed = new Signed(serializable, this._outputStream.toString(StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException exception) {
                throw new InternalError(exception);
            }
            result = new Result(signed, false, Optional.empty());
            _LOGGER.trace(BaseMessages.SIGNED, signed.getSignature());
        }
        catch (CryptException exception) {
            result = new Result(null, false, Optional.of(exception));
        }
        return result;
    }

    public synchronized void tearDown() {
        CryptEngineWrapper engineWrapper = this._engineWrapper.getAndSet(null);
        if (engineWrapper != null) {
            engineWrapper.tearDown();
            this._streamer.tearDown();
        }
    }

    @Nonnull
    @CheckReturnValue
    public synchronized Result verify(@Nonnull Serializable serializable, @Nonnull String[] verificationKeyIdents) {
        Result result;
        if (!(serializable instanceof Signed)) {
            return new Result(serializable, false, Optional.empty());
        }
        try {
            Signed signed = (Signed)serializable;
            String xmlString = this._toXML(signed.getSigned());
            byte[] xmlBytes = xmlString.getBytes(StandardCharsets.UTF_8);
            byte[] signatureBytes = signed.getSignature().getBytes(StandardCharsets.UTF_8);
            if (_LOGGER.isTraceEnabled()) {
                _LOGGER.trace(BaseMessages.VERIFYING, xmlString, signed.getSignature());
            }
            CryptEngineWrapper engineWrapper = this._engineWrapper.get();
            boolean verified = engineWrapper.verify(new ByteArrayInputStream(xmlBytes), new ByteArrayInputStream(signatureBytes), Require.notNull(verificationKeyIdents));
            result = new Result(signed.getSigned(), verified, Optional.empty());
            _LOGGER.trace(BaseMessages.VERIFIED, verified);
        }
        catch (CryptException exception) {
            result = new Result(null, false, Optional.of(exception));
        }
        return result;
    }

    @Nonnull
    @CheckReturnValue
    public Result verifyAndDecrypt(@Nonnull Serializable serializable, @Nonnull String[] verificationKeyIdents, @Nonnull String[] decryptionKeyIdent) {
        Result result = this.verify(serializable, verificationKeyIdents);
        if (result.isSuccess() && result.isVerified()) {
            serializable = result.getSerializable();
            Result decryptResult = this.decrypt(serializable, decryptionKeyIdent);
            result = decryptResult.isSuccess() ? new Result(decryptResult.getSerializable(), true, Optional.empty()) : new Result(null, true, Optional.of(decryptResult.getException()));
        }
        return result;
    }

    private String _toXML(Serializable serializable) throws CryptException {
        this._writer.reset();
        if (!this._streamerOutput.add(serializable)) {
            throw new CryptException();
        }
        this._streamerOutput.flush();
        return this._writer.toString();
    }

    public static final class Result {
        private final CryptException _exception;
        private final Serializable _serializable;
        private final boolean _verified;

        Result(@Nullable Serializable serializable, boolean verified, @Nonnull Optional<CryptException> exception) {
            this._exception = exception.orElse(null);
            this._serializable = serializable;
            this._verified = verified;
        }

        @Nonnull
        @CheckReturnValue
        public CryptException getException() {
            return Require.notNull(this._exception);
        }

        @Nullable
        @CheckReturnValue
        public Serializable getSerializable() {
            return this._serializable;
        }

        @CheckReturnValue
        public boolean isFailure() {
            return this._exception != null;
        }

        @CheckReturnValue
        public boolean isSuccess() {
            return this._exception == null;
        }

        @CheckReturnValue
        public boolean isVerified() {
            return this._verified;
        }
    }
}

