/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.security.Principal;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.security.Credential;
import org.rvpf.base.tool.Require;

public class Identity
implements Principal {
    private boolean _authenticated;
    private final Credential _credential;
    private final String _identifier;
    private final Set<String> _roles;

    protected Identity(@Nonnull String identifier, @Nonnull Credential credential, @Nonnull Set<String> roles) {
        this._identifier = identifier;
        this._credential = credential;
        this._roles = Require.notNull(roles);
    }

    @CheckReturnValue
    public boolean authenticate(@Nonnull Object credential) {
        this._authenticated = this._credential != null ? this._credential.check(credential) : false;
        return this._authenticated;
    }

    @Nonnull
    @CheckReturnValue
    public String getIdentifier() {
        return this._identifier;
    }

    @Override
    public String getName() {
        return this.getIdentifier();
    }

    @Nonnull
    @CheckReturnValue
    public Set<String> getRoles() {
        return this._roles;
    }

    @CheckReturnValue
    public boolean isAuthenticated() {
        return this._authenticated;
    }

    @CheckReturnValue
    public boolean isInRoles(@Nonnull String[] roles) {
        for (String role : roles) {
            if (!this._roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this._authenticated = false;
    }

    @Override
    public String toString() {
        return this.getIdentifier();
    }
}

