/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.security.StoreConfig;

public final class KeyStoreConfig
extends StoreConfig {
    public static final String KIND = "KeyStore";
    private volatile Optional<String> _keyIdent = Optional.empty();
    private volatile Optional<char[]> _keyPassword = Optional.empty();

    protected KeyStoreConfig(@Nonnull Logger logger) {
        super(logger);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<String> getKeyIdent() {
        return this._keyIdent;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<char[]> getKeyPassword() {
        return this._keyPassword;
    }

    public void setKeyIdent(@Nonnull Optional<String> keyIdent) {
        this._keyIdent = keyIdent;
    }

    public void setKeyPassword(@Nonnull Optional<char[]> keyPassword) {
        this._keyPassword = keyPassword.isPresent() && keyPassword.get().length > 0 ? keyPassword : Optional.empty();
    }

    @Override
    protected String getKind() {
        return KIND;
    }
}

