/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rvpf.base.security.CryptEngineWrapper;
import org.rvpf.base.util.container.KeyedGroups;

public final class NullCryptEngineWrapperImpl
implements CryptEngineWrapper {
    @Override
    public void decrypt(InputStream encryptedStream, String[] decryptionKeyIdents, OutputStream decryptedStream) {
        NullCryptEngineWrapperImpl._copy(encryptedStream, decryptedStream);
    }

    @Override
    public void encrypt(InputStream inputStream, String[] encryptionKeyIdents, OutputStream encryptedStream) {
        NullCryptEngineWrapperImpl._copy(inputStream, encryptedStream);
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public boolean setUp(KeyedGroups cryptProperties) {
        return true;
    }

    @Override
    public void sign(InputStream inputStream, String[] signingKeyIdents, OutputStream signatureStream) {
    }

    @Override
    public void tearDown() {
    }

    @Override
    public boolean verify(InputStream signedStream, InputStream signatureStream, String[] verificationKeyIdents) {
        return true;
    }

    private static void _copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = input.read(buffer)) >= 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

