/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.security.Credential;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.Identity;
import org.rvpf.base.security.SecurityContext;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.ResourceFileFactory;
import org.rvpf.base.util.UnicodeStreamReader;
import org.rvpf.base.util.container.KeyedGroups;

public class Realm {
    public static final String CRYPT_PREFIX = "CRYPT:";
    public static final Identity UNKNOWN_IDENTITY = new Identity("", new Credential(new char[0]), Collections.emptySet());
    private static final Pattern _ROLES_SPLIT_PATTERN = Pattern.compile("\\s*,\\s*");
    private static final String _XML_EXT = ".xml";
    private boolean _configured;
    private final Map<String, Identity> _identities = new HashMap<String, Identity>();

    @Nonnull
    @CheckReturnValue
    public Optional<Identity> authenticate(@Nonnull String identifier, @Nonnull Object credential) {
        Optional<Identity> identity = Optional.ofNullable(this._identities.get(Require.notNull(identifier)));
        return identity.isPresent() && identity.get().authenticate(credential) ? identity : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public Identity getIdentity(@Nonnull Optional<String> identifier) {
        Identity identity = identifier.isPresent() ? this._identities.get(identifier.get()) : null;
        return identity != null ? identity : UNKNOWN_IDENTITY;
    }

    @CheckReturnValue
    public boolean isConfigured() {
        return this._configured;
    }

    @CheckReturnValue
    public boolean isInRoles(@Nonnull Optional<String> identifier, @Nonnull String[] roles) {
        Identity identity = identifier.isPresent() ? this._identities.get(identifier.get()) : null;
        return identity != null && identity.isInRoles(roles);
    }

    @CheckReturnValue
    public boolean setUp(@Nonnull KeyedGroups realmProperties, @Nonnull SecurityContext securityContext) {
        Reader realmReader;
        File realmFile;
        boolean verify = realmProperties.getBoolean("verify");
        boolean decrypt = realmProperties.getBoolean("decrypt");
        String realmPath = realmProperties.getString("path").orElse(null);
        if (realmPath == null || realmPath.trim().isEmpty()) {
            this.getThisLogger().error(BaseMessages.MISSING_PROPERTY_IN, "path", "realm");
            return false;
        }
        if ((verify || decrypt) && !realmPath.endsWith(_XML_EXT)) {
            realmPath = realmPath + _XML_EXT;
        }
        if ((realmFile = ResourceFileFactory.newResourceFile(realmPath)) == null || !realmFile.isFile()) {
            this.getThisLogger().error(BaseMessages.RESOURCE_NOT_FOUND, realmPath);
            return false;
        }
        this.getThisLogger().info(BaseMessages.REALM_RESOURCE, realmFile);
        Properties loadedProperties = new Properties();
        if (verify || decrypt) {
            Crypt crypt = new Crypt();
            if (!crypt.setUp(securityContext.getCryptProperties(), Optional.empty())) {
                return false;
            }
            Serializable serializable = crypt.load(realmFile, verify, realmProperties.getStrings("verify.key"), decrypt, realmProperties.getStrings("devrypt.key"));
            if (serializable == null) {
                return false;
            }
            realmReader = new StringReader(serializable.toString());
        } else {
            try {
                realmReader = new UnicodeStreamReader(realmFile);
            }
            catch (FileNotFoundException exception1) {
                this.getThisLogger().error(BaseMessages.FILE_NOT_FOUND, realmFile.getAbsolutePath());
                return false;
            }
        }
        try {
            loadedProperties.load(realmReader);
        }
        catch (IOException exception) {
            this.getThisLogger().error(BaseMessages.FILE_READ_FAILED, realmFile.getAbsolutePath(), exception);
            return false;
        }
        for (Map.Entry<Object, Object> entry : loadedProperties.entrySet()) {
            String names;
            char[] password;
            String identifier = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            int comma = value.indexOf(44);
            HashSet<String> roles = new HashSet<String>();
            if (comma >= 0) {
                password = value.substring(0, comma).trim().toCharArray();
                names = value.substring(comma + 1).trim();
            } else {
                password = value.toCharArray();
                names = "";
            }
            if (names.length() > 0) {
                roles.addAll(Arrays.asList(_ROLES_SPLIT_PATTERN.split(names)));
            }
            this._identities.put(identifier, this.newIdentity(identifier, new Credential(password), roles));
        }
        this._configured = true;
        return true;
    }

    @Nonnull
    @CheckReturnValue
    protected final Logger getThisLogger() {
        return Logger.getInstance(this.getClass());
    }

    @Nonnull
    @CheckReturnValue
    protected Identity newIdentity(@Nonnull String identifier, @Nonnull Credential credential, @Nonnull Set<String> roles) {
        return new Identity(identifier, credential, roles);
    }
}

