/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.security.Crypt;
import org.rvpf.base.security.KeyStoreConfig;
import org.rvpf.base.security.StoreConfig;
import org.rvpf.base.security.TrustStoreConfig;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.KeyedGroups;

@ThreadSafe
public class SecurityContext {
    public static final String CERTIFIED_PROPERTY = "certified";
    public static final String CRYPT_PROPERTIES = "crypt";
    public static final String IDENT_PROPERTY = "ident";
    public static final String KEYSTORE_PROPERTIES = "keystore";
    public static final String KEY_PROPERTIES = "key";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String PATH_PROPERTY = "path";
    public static final String PROVIDER_PROPERTY = "provider";
    public static final String REALM_PROPERTIES = "realm";
    public static final String SECURE_PROPERTY = "secure";
    public static final String SECURITY_PROPERTIES = "security";
    public static final String TRUSTSTORE_PROPERTIES = "truststore";
    public static final String TYPE_PROPERTY = "type";
    private volatile boolean _certified;
    private volatile KeyedGroups _cryptProperties;
    private final KeyStoreConfig _keyStoreConfig;
    private final Logger _logger;
    private volatile KeyedGroups _realmProperties;
    private volatile boolean _secure;
    private final TrustStoreConfig _trustStoreConfig;

    public SecurityContext(@Nonnull Logger logger) {
        this._logger = logger;
        this._keyStoreConfig = new KeyStoreConfig(logger);
        this._trustStoreConfig = new TrustStoreConfig(logger);
    }

    public final void checkForSecureOperation() throws SSLException {
        this.useDefaults();
        if (!(this._keyStoreConfig.getPath().isPresent() || !this.isServer() && this.getTrustStoreConfig().getPath().isPresent())) {
            throw new SSLException(BaseMessages.NO_SECURE.toString());
        }
        if (this.isCertified() && !this._keyStoreConfig.getPassword().isPresent()) {
            throw new SSLException(BaseMessages.NO_CERTIFIED.toString());
        }
    }

    @Nonnull
    @CheckReturnValue
    public final SSLContext createSSLContext() throws SSLException {
        SSLContext sslContext;
        this.useDefaults();
        try {
            KeyStore keyStore;
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            Optional<String> keyStorePath = this._keyStoreConfig.getPath();
            Optional<char[]> keyStorePassword = this._keyStoreConfig.getPassword();
            Optional<char[]> keyPassword = this._keyStoreConfig.getKeyPassword();
            if (!keyPassword.isPresent()) {
                keyPassword = keyStorePassword;
            }
            if (keyStorePath.isPresent()) {
                if (!keyStorePassword.isPresent()) {
                    throw new SSLException(BaseMessages.NO_KEYSTORE_PASSWORD.toString());
                }
                keyStore = this._loadStore(this._keyStoreConfig);
            } else {
                keyStore = null;
            }
            keyManagerFactory.init(keyStore, keyPassword.orElse(null));
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            Optional<String> trustStorePath = this._trustStoreConfig.getPath();
            KeyStore trustStore = trustStorePath.isPresent() ? this._loadStore(this._trustStoreConfig) : keyStore;
            trustManagerFactory.init(trustStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (SSLException exception) {
            throw exception;
        }
        catch (Exception exception) {
            SSLException ssle = new SSLException(BaseMessages.SSL_INITIALIZE_FAILED.toString());
            ssle.initCause(exception);
            throw ssle;
        }
        return sslContext;
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getCryptProperties() {
        KeyedGroups cryptProperties = this._cryptProperties;
        return cryptProperties != null ? cryptProperties : KeyedGroups.MISSING_KEYED_GROUP;
    }

    @Nonnull
    @CheckReturnValue
    public KeyStoreConfig getKeyStoreConfig() {
        return this._keyStoreConfig;
    }

    @Nonnull
    @CheckReturnValue
    public final Logger getLogger() {
        return this._logger;
    }

    @Nonnull
    @CheckReturnValue
    public KeyedGroups getRealmProperties() {
        KeyedGroups realmProperties = this._realmProperties;
        return realmProperties != null ? realmProperties : KeyedGroups.MISSING_KEYED_GROUP;
    }

    @Nonnull
    @CheckReturnValue
    public TrustStoreConfig getTrustStoreConfig() {
        return this._trustStoreConfig;
    }

    @CheckReturnValue
    public final boolean isCertified() {
        return this._certified;
    }

    @CheckReturnValue
    public final boolean isSecure() {
        return this._secure;
    }

    @CheckReturnValue
    public boolean isServer() {
        return false;
    }

    public final void setCertified(boolean certified) {
        if (certified && this.isServer()) {
            this._logger.debug(BaseMessages.CERTIFIED, new Object[0]);
        }
        this._certified = certified;
    }

    public void setCryptProperties(@Nonnull KeyedGroups cryptProperties) {
        this._cryptProperties = Require.notNull(cryptProperties);
    }

    public void setRealmProperties(@Nonnull KeyedGroups realmProperties) {
        this._realmProperties = Require.notNull(realmProperties);
    }

    public final void setSecure(boolean secure) {
        if (secure && this.isServer()) {
            this._logger.debug(BaseMessages.SECURE, new Object[0]);
        }
        this._secure = secure;
    }

    @CheckReturnValue
    public final boolean setUp(@Nonnull KeyedGroups configProperties, @Nonnull KeyedGroups securityProperties) {
        if (securityProperties.isMissing()) {
            securityProperties = configProperties.getGroup(configProperties.getString(SECURITY_PROPERTIES, Optional.of(SECURITY_PROPERTIES)).get());
        }
        if (!securityProperties.isMissing()) {
            try {
                this._setUpKeyStore(securityProperties.getGroup(KEYSTORE_PROPERTIES));
                this._setUpTrustStore(securityProperties.getGroup(TRUSTSTORE_PROPERTIES));
                this.setSecure(securityProperties.getBoolean(SECURE_PROPERTY));
                this.setCertified(securityProperties.getBoolean(CERTIFIED_PROPERTY));
                this.setCryptProperties(securityProperties.getGroup(CRYPT_PROPERTIES));
                this.setRealmProperties(securityProperties.getGroup(REALM_PROPERTIES));
            }
            catch (FileNotFoundException exception) {
                this._logger.error(BaseMessages.VERBATIM, exception.getMessage());
                return false;
            }
        }
        return true;
    }

    protected void useDefaults() throws SSLException {
        try {
            String password;
            if (!this._keyStoreConfig.getPath().isPresent()) {
                this._keyStoreConfig.setPath(SecurityContext._systemProperty("javax.net.ssl.keyStore"));
            }
            if (!this._keyStoreConfig.getPassword().isPresent()) {
                password = System.getProperty("javax.net.ssl.keyStorePassword", "");
                this._keyStoreConfig.setPassword(Optional.of(password.toCharArray()));
            }
            if (!this._keyStoreConfig.getProvider().isPresent()) {
                this._keyStoreConfig.setProvider(SecurityContext._systemProperty("javax.net.ssl.keyStoreProvider"));
            }
            if (!this._keyStoreConfig.getType().isPresent()) {
                this._keyStoreConfig.setType(SecurityContext._systemProperty("javax.net.ssl.keyStoreType"));
            }
            if (!this._trustStoreConfig.getPath().isPresent()) {
                this._trustStoreConfig.setPath(SecurityContext._systemProperty("javax.net.ssl.trustStore"));
            }
            if (!this._trustStoreConfig.getPassword().isPresent() && (password = System.getProperty("javax.net.ssl.trustStorePassword")) != null) {
                this._trustStoreConfig.setPassword(Optional.of(password.toCharArray()));
            }
            if (!this._trustStoreConfig.getProvider().isPresent()) {
                this._trustStoreConfig.setProvider(SecurityContext._systemProperty("javax.net.ssl.trustStoreProvider"));
            }
            if (!this._trustStoreConfig.getType().isPresent()) {
                this._trustStoreConfig.setType(SecurityContext._systemProperty("javax.net.ssl.trustStoreType"));
            }
        }
        catch (FileNotFoundException exception) {
            throw new SSLException(exception);
        }
    }

    private static void _setUpStore(StoreConfig storeConfig, KeyedGroups storeProperties) throws FileNotFoundException {
        storeConfig.setVerify(storeProperties.getBoolean("verify"));
        if (storeConfig.isVerify()) {
            storeConfig.setVerifyKeyIdents(Optional.of(storeProperties.getStrings("verify.key")));
        } else {
            storeConfig.setVerifyKeyIdents(Optional.empty());
        }
        storeConfig.setDecrypt(storeProperties.getBoolean("decrypt"));
        if (storeConfig.isDecrypt()) {
            storeConfig.setDecryptKeyIdents(Optional.of(storeProperties.getStrings("devrypt.key")));
        } else {
            storeConfig.setDecryptKeyIdents(Optional.empty());
        }
        storeConfig.setPath(storeProperties.getString(PATH_PROPERTY));
        storeConfig.setType(storeProperties.getString(TYPE_PROPERTY));
        storeConfig.setProvider(storeProperties.getString(PROVIDER_PROPERTY));
        storeConfig.setPassword(storeProperties.getPassword(PASSWORD_PROPERTY));
    }

    private static Optional<String> _systemProperty(String propertyName) {
        return Optional.ofNullable(System.getProperty(propertyName));
    }

    private KeyStore _loadStore(StoreConfig storeConfig) throws GeneralSecurityException, IOException {
        Optional<String> provider;
        InputStream storeStream;
        if (storeConfig.isVerify() || storeConfig.isDecrypt()) {
            Crypt crypt = new Crypt();
            if (!crypt.setUp(this.getCryptProperties(), Optional.empty())) {
                throw new GeneralSecurityException();
            }
            Serializable serializable = crypt.load(new File(storeConfig.getPath().get()), storeConfig.isVerify(), storeConfig.getVerifyKeyIdents().orElse(null), storeConfig.isDecrypt(), storeConfig.getDecryptKeyIdents().orElse(null));
            if (!(serializable instanceof byte[])) {
                throw new GeneralSecurityException(Message.format(BaseMessages.NOTHING_RECOGNIZABLE, storeConfig.getPath()));
            }
            storeStream = new ByteArrayInputStream((byte[])serializable);
        } else {
            storeStream = new FileInputStream(storeConfig.getPath().get());
        }
        Optional<String> type = storeConfig.getType();
        if (!type.isPresent()) {
            type = Optional.of(KeyStore.getDefaultType());
        }
        KeyStore store = !(provider = storeConfig.getProvider()).isPresent() ? KeyStore.getInstance(type.get()) : KeyStore.getInstance(type.get(), provider.get());
        store.load(storeStream, storeConfig.getPassword().orElse(null));
        ((InputStream)storeStream).close();
        return store;
    }

    private void _setUpKeyStore(KeyedGroups keystoreProperties) throws FileNotFoundException {
        SecurityContext._setUpStore(this._keyStoreConfig, keystoreProperties);
        KeyedGroups keyProperties = keystoreProperties.getGroup(KEY_PROPERTIES);
        this._keyStoreConfig.setKeyIdent(keyProperties.getString(IDENT_PROPERTY));
        this._keyStoreConfig.setKeyPassword(keyProperties.getPassword(PASSWORD_PROPERTY));
    }

    private void _setUpTrustStore(KeyedGroups truststoreProperties) throws FileNotFoundException {
        SecurityContext._setUpStore(this._trustStoreConfig, truststoreProperties);
    }
}

