/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.ResourceFileFactory;

public abstract class StoreConfig {
    private static final String _XML_EXT = ".xml";
    private volatile boolean _decrypt;
    private volatile Optional<String[]> _decryptKeyIdents = Optional.empty();
    private final Logger _logger;
    private volatile Optional<char[]> _password = Optional.empty();
    private volatile Optional<String> _path = Optional.empty();
    private volatile Optional<String> _provider = Optional.empty();
    private volatile Optional<String> _type = Optional.empty();
    private volatile boolean _verify;
    private volatile Optional<String[]> _verifyKeyIdents = Optional.empty();

    protected StoreConfig(@Nonnull Logger logger) {
        this._logger = Require.notNull(logger);
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<char[]> getPassword() {
        return this._password;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getPath() {
        return this._path;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getProvider() {
        return this._provider;
    }

    @Nonnull
    @CheckReturnValue
    public final Optional<String> getType() {
        return this._type;
    }

    public void setPassword(@Nonnull Optional<char[]> password) {
        this._password = password;
    }

    public final void setPath(@Nonnull Optional<String> path) throws FileNotFoundException {
        File file;
        if (!path.isPresent() || path.get().trim().isEmpty()) {
            this._path = Optional.empty();
            return;
        }
        if ((this._verify || this._decrypt) && !path.get().endsWith(_XML_EXT)) {
            path = Optional.of(path.get() + _XML_EXT);
        }
        if ((file = ResourceFileFactory.newResourceFile(path.get())) == null || !file.isFile()) {
            throw new FileNotFoundException(Message.format(BaseMessages.RESOURCE_NOT_FOUND, path.get()));
        }
        path = Optional.of(file.getAbsolutePath());
        this._logger.debug(BaseMessages.STORE_PATH, this.getKind(), path.get());
        this._path = path;
    }

    public final void setProvider(@Nonnull Optional<String> provider) {
        if (provider.isPresent()) {
            this._logger.debug(BaseMessages.STORE_PROVIDER, this.getKind(), provider.get());
        }
        this._provider = provider;
    }

    public final void setType(@Nonnull Optional<String> type) {
        if (type.isPresent()) {
            this._logger.debug(BaseMessages.STORE_TYPE, this.getKind(), type.get());
        }
        this._type = type;
    }

    @Nonnull
    @CheckReturnValue
    protected abstract String getKind();

    @Nonnull
    @CheckReturnValue
    Optional<String[]> getDecryptKeyIdents() {
        return this._decryptKeyIdents;
    }

    @Nonnull
    @CheckReturnValue
    Optional<String[]> getVerifyKeyIdents() {
        return this._verifyKeyIdents;
    }

    @CheckReturnValue
    boolean isDecrypt() {
        return this._decrypt;
    }

    @CheckReturnValue
    boolean isVerify() {
        return this._verify;
    }

    void setDecrypt(boolean decrypt) {
        this._decrypt = decrypt;
    }

    void setDecryptKeyIdents(@Nonnull Optional<String[]> decryptKeyIdents) {
        this._decryptKeyIdents = decryptKeyIdents;
    }

    void setVerify(boolean verify) {
        this._verify = verify;
    }

    void setVerifyKeyIdents(@Nonnull Optional<String[]> verifyKeyIdents) {
        this._verifyKeyIdents = verifyKeyIdents;
    }
}

