/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.som;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.DateTime;

@ThreadSafe
public final class QueueInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger _fileCount = new AtomicInteger();
    private final AtomicLong _filesSize = new AtomicLong();
    private volatile DateTime _lastReceiverCommit;
    private volatile DateTime _lastSenderCommit;
    private final AtomicLong _messageCount = new AtomicLong();
    private final AtomicLong _messagesDropped = new AtomicLong();
    private volatile DateTime _receiverConnectTime;
    private final AtomicInteger _senderCount = new AtomicInteger();

    public void clearFilesSize() {
        this._filesSize.set(0L);
    }

    public void clearMessageCount() {
        this._messageCount.set(0L);
    }

    @Nonnegative
    @CheckReturnValue
    public int getFileCount() {
        return this._fileCount.get();
    }

    @Nonnegative
    @CheckReturnValue
    public long getFilesSize() {
        return this._filesSize.get();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getLastReceiverCommit() {
        return Optional.ofNullable(this._lastReceiverCommit);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getLastSenderCommit() {
        return Optional.ofNullable(this._lastSenderCommit);
    }

    @Nonnegative
    @CheckReturnValue
    public long getMessageCount() {
        return this._messageCount.get();
    }

    @Nonnegative
    @CheckReturnValue
    public long getMessagesDropped() {
        return this._messagesDropped.get();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getReceiverConnectTime() {
        return Optional.ofNullable(this._receiverConnectTime);
    }

    @Nonnegative
    @CheckReturnValue
    public int getSenderCount() {
        return this._senderCount.get();
    }

    public void setLastReceiverCommit(@Nonnull DateTime lastReceiverCommit) {
        this._lastReceiverCommit = lastReceiverCommit;
    }

    public void setLastSenderCommit(@Nonnull DateTime lastSenderCommit) {
        this._lastSenderCommit = lastSenderCommit;
    }

    public void setReceiverConnectTime(@Nonnull Optional<DateTime> receiverConnecTime) {
        this._receiverConnectTime = receiverConnecTime.orElse(null);
    }

    public void updateFileCount(int delta) {
        this._fileCount.addAndGet(delta);
    }

    public void updateFilesSize(long delta) {
        this._filesSize.addAndGet(delta);
    }

    public void updateMessageCount(long delta) {
        this._messageCount.addAndGet(delta);
    }

    public void updateMessagesDropped(long delta) {
        this._messagesDropped.addAndGet(delta);
    }

    public void updateSenderCount(int delta) {
        this._senderCount.addAndGet(delta);
    }
}

