/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.som;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.som.QueueInfo;
import org.rvpf.base.som.QueueServer;
import org.rvpf.base.som.ReceiverSession;
import org.rvpf.base.som.SOMProxy;
import org.rvpf.base.som.SenderSession;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;

@ThreadSafe
public class QueueProxy
extends SOMProxy {
    final AtomicBoolean _inTransaction = new AtomicBoolean();

    QueueProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull Optional<ElapsedTime> timeout) {
        super(clientName, loginInfo, context, listener, autoconnect, timeout);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public final void connect() throws SessionConnectFailedException {
        super.connect();
        this._inTransaction.set(false);
    }

    @Nonnull
    @CheckReturnValue
    public final QueueInfo getInfo() throws SessionConnectFailedException {
        try {
            return ((QueueServer)this.getFactory()).getInfo();
        }
        catch (RemoteException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected Session createSession() throws RemoteException, SessionException {
        throw new UnsupportedOperationException();
    }

    public static final class Sender
    extends QueueProxy
    implements SenderSession {
        Sender(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect) {
            super(clientName, loginInfo, context, listener, autoconnect, Optional.empty());
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public void commit() throws SessionException {
            if (this._inTransaction.compareAndSet(true, false)) {
                try {
                    this._getSenderSession().commit();
                }
                catch (Exception exception) {
                    this.disconnect();
                    throw this.sessionException(exception);
                }
            }
        }

        @Override
        public void rollback() throws SessionException {
            if (this._inTransaction.compareAndSet(true, false)) {
                try {
                    this._getSenderSession().rollback();
                }
                catch (Exception exception) {
                    this.disconnect();
                    throw this.sessionException(exception);
                }
            }
        }

        @Override
        public void send(@Nonnull Serializable[] messages, boolean commit) throws SessionException {
            try {
                this._getSenderSession().send(messages, commit);
            }
            catch (Exception exception) {
                this.disconnect();
                throw this.sessionException(exception);
            }
            this._inTransaction.set(true);
        }

        @Override
        protected Session createSession() throws RemoteException, SessionException {
            return ((QueueServer)this.getFactory()).createSenderSession(this.getContextUUID(), this.getClientName());
        }

        @Override
        protected String sessionMode() {
            return BaseMessages.SEND_MODE.toString();
        }

        private SenderSession _getSenderSession() throws SessionException {
            return (SenderSession)this.getSession();
        }

        public static final class Builder
        extends org.rvpf.base.som.QueueProxy$Builder {
            @Override
            public Sender build() {
                if (!this.setUp()) {
                    return null;
                }
                return new Sender(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect());
            }

            @Override
            public Builder prepare(KeyedGroups configProperties, KeyedGroups somProperties, String clientName, Logger clientLogger) {
                return (Builder)super.prepare(configProperties, somProperties, clientName, clientLogger);
            }

            @Override
            public Builder setAutoconnect(boolean autoconnect) {
                super.setAutoconnect(autoconnect);
                return this;
            }
        }
    }

    public static final class Receiver
    extends QueueProxy
    implements ReceiverSession {
        Receiver(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull Optional<ElapsedTime> timeout) {
            super(clientName, loginInfo, context, listener, autoconnect, timeout);
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public void commit() throws SessionException {
            if (this._inTransaction.compareAndSet(true, false)) {
                try {
                    this._getReceiverSession().commit();
                }
                catch (Exception exception) {
                    this.disconnect();
                    throw this.sessionException(exception);
                }
            }
        }

        @Override
        public long purge() throws SessionException {
            long purged;
            try {
                purged = this._getReceiverSession().purge();
            }
            catch (Exception exception) {
                this.disconnect();
                throw this.sessionException(exception);
            }
            this._inTransaction.set(false);
            return purged;
        }

        @Override
        public Serializable[] receive(int limit, long timeout) throws SessionException {
            Serializable[] messages;
            try {
                while ((messages = this._getReceiverSession().receive(limit, timeout)).length == 0 && timeout < 0L) {
                }
            }
            catch (Exception exception) {
                throw this.sessionException(exception);
            }
            this._inTransaction.set(true);
            return messages;
        }

        @Override
        public void rollback() throws SessionException {
            if (this._inTransaction.compareAndSet(true, false)) {
                try {
                    this._getReceiverSession().rollback();
                }
                catch (Exception exception) {
                    this.disconnect();
                    throw this.sessionException(exception);
                }
            }
        }

        @Override
        protected Session createSession() throws RemoteException, SessionException {
            this.confirmTimeout();
            return ((QueueServer)this.getFactory()).createReceiverSession(this.getContextUUID(), this.getClientName());
        }

        @Override
        protected String sessionMode() {
            return BaseMessages.RECEIVE_MODE.toString();
        }

        private ReceiverSession _getReceiverSession() throws SessionException {
            return (ReceiverSession)this.getSession();
        }

        public static final class Builder
        extends org.rvpf.base.som.QueueProxy$Builder {
            Builder() {
            }

            @Override
            public Receiver build() {
                if (!this.setUp()) {
                    return null;
                }
                return new Receiver(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect(), this.getTimeout());
            }

            @Override
            public Builder prepare(KeyedGroups configProperties, KeyedGroups queueProperties, String clientName, Logger clientLogger) {
                Optional<ElapsedTime> timeout = queueProperties.getElapsed("timeout", Optional.empty(), Optional.of(ElapsedTime.EMPTY));
                return (Builder)super.prepare(configProperties, queueProperties, clientName, clientLogger).setTimeout(timeout);
            }

            @Override
            public Builder setAutoconnect(boolean autoconnect) {
                super.setAutoconnect(autoconnect);
                return this;
            }
        }
    }

    public static class Builder
    extends SOMProxy.Builder {
        @Override
        public QueueProxy build() {
            if (!this.setUp()) {
                return null;
            }
            return new QueueProxy(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect(), Optional.empty());
        }

        @Override
        public Builder prepare(KeyedGroups configProperties, KeyedGroups somProperties, String clientName, Logger clientLogger) {
            return (Builder)super.prepare(configProperties, somProperties, clientName, clientLogger);
        }

        @Override
        protected String getDefaultBindPrefix() {
            return "queue/";
        }
    }
}

