/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.som;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.rmi.RemoteException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.CatchedSessionException;
import org.rvpf.base.rmi.RegistryConfig;
import org.rvpf.base.rmi.RegistryEntry;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.som.SOMServer;
import org.rvpf.base.som.SOMSession;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;

@ThreadSafe
public abstract class SOMProxy
extends SessionProxy
implements SOMSession {
    public static final String PASSWORD_PROPERTY = "password";
    public static final String TIMEOUT_PROPERTY = "timeout";
    public static final String USER_PROPERTY = "user";
    private final AtomicBoolean _closed = new AtomicBoolean();
    private volatile String _somName;
    private volatile ElapsedTime _timeout;

    SOMProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull Optional<ElapsedTime> timeout) {
        super(clientName, loginInfo, context, listener, autoconnect);
        if (timeout.isPresent()) {
            this._timeout = timeout.get();
            this.getThisLogger().debug(BaseMessages.TIMEOUT, this.getSOMName(), this._timeout);
        } else {
            this._timeout = null;
        }
    }

    @Override
    public void close() throws SessionException {
        this.disconnect();
    }

    @Override
    public void connect() throws SessionConnectFailedException {
        super.connect();
        this._closed.set(false);
        this.getThisLogger().debug(BaseMessages.SOM_PROXY_CONNECTED, this.getServerName(), this.sessionMode());
    }

    @Override
    public final void disconnect() {
        try {
            this.lockConnectInterruptibly();
        }
        catch (CatchedSessionException exception) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            if (this.isConnected()) {
                this._somName = null;
                super.disconnect();
                this.getThisLogger().debug(BaseMessages.SOM_PROXY_DISCONNECTED, this.getServerName(), this.sessionMode());
            }
        }
        finally {
            this.unlockConnect();
        }
    }

    @Nonnull
    @CheckReturnValue
    public final String getSOMName() {
        String somName = this._somName;
        if (somName == null) {
            try {
                this._somName = somName = ((SOMServer)this.getFactory()).getName();
            }
            catch (RemoteException exception) {
                throw new RuntimeException(exception);
            }
            catch (SessionConnectFailedException exception) {
                somName = this.getServerURI().toString();
            }
        }
        return somName;
    }

    @CheckReturnValue
    public final boolean isClosed() {
        return this._closed.get();
    }

    protected void confirmTimeout() throws RemoteException, SessionConnectFailedException {
        SessionClientContext context;
        if (this._timeout == null) {
            ElapsedTime keepAlive = ((SOMServer)this.getFactory()).getKeepAlive();
            this._timeout = keepAlive.add(keepAlive);
            this.getThisLogger().debug(BaseMessages.TIMEOUT, this.getSOMName(), this._timeout);
        }
        if ((context = this.getContext()) == null) {
            throw new SessionConnectFailedException();
        }
        context.setTimeout((int)this._timeout.toMillis());
    }

    @NotThreadSafe
    public static final class ContextProperties
    extends KeyedGroups {
        private static final long serialVersionUID = 1L;

        public ContextProperties() {
        }

        private ContextProperties(ContextProperties other) {
            super(other);
        }

        @Override
        public ContextProperties copy() {
            return new ContextProperties(this);
        }

        @Override
        public ContextProperties freeze() {
            super.freeze();
            return this;
        }

        public void setCertified(boolean certified) {
            this._setSecurity("certified", String.valueOf(certified), new String[0]);
        }

        public void setKeyPassword(@Nonnull Optional<char[]> keyPassword) {
            this._setSecurity(SOMProxy.PASSWORD_PROPERTY, keyPassword.isPresent() ? String.valueOf(keyPassword) : null, "keystore", "key");
        }

        public void setKeyStore(@Nonnull Optional<String> keyStore) {
            this._setSecurity("path", keyStore.orElse(null), "keystore");
        }

        public void setKeyStorePassword(@Nonnull Optional<char[]> keyStorePassword) {
            this._setSecurity(SOMProxy.PASSWORD_PROPERTY, keyStorePassword.isPresent() ? String.valueOf(keyStorePassword.get()) : null, "keystore", "key");
        }

        public void setKeyStoreProvider(@Nonnull Optional<String> provider) {
            this._setSecurity("provider", provider.orElse(null), "keystore");
        }

        public void setKeyStoreType(@Nonnull Optional<String> type) {
            this._setSecurity("type", type.orElse(null), "keystore");
        }

        public void setRegistryPort(int registryPort) {
            KeyedGroups rmiRegistryProperties = new KeyedGroups();
            if (registryPort >= 0) {
                rmiRegistryProperties.setValue("port", String.valueOf(registryPort));
            }
            this.setGroup("rmi.registry", rmiRegistryProperties);
        }

        public void setSecurityProperties(@Nonnull KeyedGroups properties) {
            this.setGroup("security", properties);
        }

        public void setTrustStore(@Nonnull Optional<String> trustStore) {
            this._setSecurity("path", trustStore.orElse(null), "truststore");
        }

        public void setTrustStoreProvider(@Nonnull Optional<String> provider) {
            this._setSecurity("provider", provider.orElse(null), "truststore");
        }

        public void setTrustStoreType(@Nonnull Optional<String> type) {
            this._setSecurity("type", type.orElse(null), "truststore");
        }

        private void _setSecurity(String key, String value, String ... groups) {
            KeyedGroups securityProperties = this.getGroup("security");
            if (securityProperties.isMissing()) {
                securityProperties = new KeyedGroups();
                this.setSecurityProperties(securityProperties);
            }
            for (String group : groups) {
                KeyedGroups groupProperties = securityProperties.getGroup(group);
                if (!groupProperties.isMissing()) continue;
                groupProperties = new KeyedGroups();
                securityProperties.setGroup(group, groupProperties);
                securityProperties = groupProperties;
            }
            if (value != null) {
                securityProperties.setValue(key, value);
            } else {
                securityProperties.removeValue(key);
            }
        }
    }

    public static abstract class Builder
    extends SessionProxy.Builder {
        private ElapsedTime _timeout;

        public Builder setTimeout(@Nonnull Optional<ElapsedTime> timeout) {
            this._timeout = timeout.orElse(null);
            return this;
        }

        @Nonnull
        @CheckReturnValue
        protected abstract String getDefaultBindPrefix();

        @Nonnull
        @CheckReturnValue
        protected Optional<ElapsedTime> getTimeout() {
            return Optional.ofNullable(this._timeout);
        }

        @Nullable
        @CheckReturnValue
        protected Builder prepare(@Nonnull KeyedGroups configProperties, @Nonnull KeyedGroups somProperties, @Nonnull String clientName, @Nonnull Logger clientLogger) {
            RegistryConfig registryConfig = new RegistryConfig(configProperties);
            InetSocketAddress registrySocketAddress = registryConfig.getRegistrySocketAddress();
            InetAddress defaultRegistryAddress = registrySocketAddress != null ? registrySocketAddress.getAddress() : InetAddress.getLoopbackAddress();
            int defaultRegistryPort = registryConfig.getRegistryPort();
            if (defaultRegistryPort < 0) {
                return null;
            }
            RegistryEntry registryEntry = RegistryEntry.newBuilder().setBinding(somProperties.getString("binding")).setName(somProperties.getString("name")).setDefaultPrefix(this.getDefaultBindPrefix()).setDefaultRegistryAddress(defaultRegistryAddress.isAnyLocalAddress() ? Optional.empty() : Optional.of(defaultRegistryAddress)).setDefaultRegistryPort(defaultRegistryPort).build();
            if (registryEntry == null) {
                return null;
            }
            return (Builder)this.setRegistryEntry(registryEntry).setConfigProperties(configProperties).setSecurityProperties(somProperties.getGroup("security")).setLoginUser(somProperties.getString(SOMProxy.USER_PROPERTY)).setLoginPassword(somProperties.getPassword(SOMProxy.PASSWORD_PROPERTY)).setClientName(clientName).setClientLogger(clientLogger);
        }
    }
}

