/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.som;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.DateTime;

@ThreadSafe
public final class TopicInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private volatile DateTime _lastPublish;
    private final AtomicInteger _publisherCount = new AtomicInteger();
    private final AtomicInteger _subscriberCount = new AtomicInteger();

    @CheckReturnValue
    public DateTime getLastPublish() {
        return this._lastPublish;
    }

    @Nonnegative
    @CheckReturnValue
    public int getPublisherCount() {
        return this._publisherCount.get();
    }

    @Nonnegative
    @CheckReturnValue
    public int getSubscriberCount() {
        return this._subscriberCount.get();
    }

    public void setLastPublish(@Nonnull DateTime lastPublish) {
        this._lastPublish = lastPublish;
    }

    public void updatePublisherCount(@Nonnegative int delta) {
        this._publisherCount.addAndGet(delta);
    }

    public void updateSubscriberCount(@Nonnegative int delta) {
        this._subscriberCount.addAndGet(delta);
    }
}

