/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.som;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionConnectFailedException;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.som.PublisherSession;
import org.rvpf.base.som.SOMProxy;
import org.rvpf.base.som.SubscriberSession;
import org.rvpf.base.som.TopicInfo;
import org.rvpf.base.som.TopicServer;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.util.container.KeyedGroups;

@ThreadSafe
public class TopicProxy
extends SOMProxy {
    TopicProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull Optional<ElapsedTime> timeout) {
        super(clientName, loginInfo, context, listener, autoconnect, timeout);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Nonnull
    @CheckReturnValue
    public final TopicInfo getInfo() throws SessionConnectFailedException {
        try {
            return ((TopicServer)this.getFactory()).getInfo();
        }
        catch (RemoteException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected Session createSession() throws RemoteException, SessionException {
        throw new UnsupportedOperationException();
    }

    public static final class Subscriber
    extends TopicProxy
    implements SubscriberSession {
        Subscriber(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect, @Nonnull Optional<ElapsedTime> timeout) {
            super(clientName, loginInfo, context, listener, autoconnect, timeout);
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public Serializable[] receive(int limit, long timeout) throws SessionException {
            Serializable[] messages;
            try {
                while ((messages = this._getSubscriber().receive(limit, timeout)).length == 0 && timeout < 0L) {
                }
            }
            catch (Exception exception) {
                this.disconnect();
                throw this.sessionException(exception);
            }
            return messages;
        }

        @Override
        protected Session createSession() throws RemoteException, SessionException {
            this.confirmTimeout();
            return ((TopicServer)this.getFactory()).createSubscriberSession(this.getContextUUID(), this.getClientName());
        }

        @Override
        protected String sessionMode() {
            return BaseMessages.SUBSCRIBE_MODE.toString();
        }

        private SubscriberSession _getSubscriber() throws SessionException {
            return (SubscriberSession)this.getSession();
        }

        public static final class Builder
        extends org.rvpf.base.som.TopicProxy$Builder {
            @Override
            public Subscriber build() {
                if (!this.setUp()) {
                    return null;
                }
                return new Subscriber(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect(), this.getTimeout());
            }

            @Override
            public Builder prepare(KeyedGroups configProperties, KeyedGroups somProperties, String clientName, Logger clientLogger) {
                return (Builder)super.prepare(configProperties, somProperties, clientName, clientLogger);
            }

            @Override
            public Builder setAutoconnect(boolean autoconnect) {
                super.setAutoconnect(autoconnect);
                return this;
            }
        }
    }

    public static final class Publisher
    extends TopicProxy
    implements PublisherSession {
        Publisher(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect) {
            super(clientName, loginInfo, context, listener, autoconnect, Optional.empty());
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        @Override
        public void send(@Nonnull Serializable[] messages) throws SessionException {
            try {
                this._getPublisherSession().send(messages);
            }
            catch (Exception exception) {
                this.disconnect();
                throw this.sessionException(exception);
            }
        }

        @Override
        protected Session createSession() throws RemoteException, SessionException {
            return ((TopicServer)this.getFactory()).createPublisherSession(this.getContextUUID(), this.getClientName());
        }

        @Override
        protected String sessionMode() {
            return BaseMessages.PUBLISH_MODE.toString();
        }

        private PublisherSession _getPublisherSession() throws SessionException {
            return (PublisherSession)this.getSession();
        }

        public static final class Builder
        extends org.rvpf.base.som.TopicProxy$Builder {
            @Override
            public Publisher build() {
                if (!this.setUp()) {
                    return null;
                }
                return new Publisher(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect());
            }

            @Override
            public Builder prepare(KeyedGroups configProperties, KeyedGroups somProperties, String clientName, Logger clientLogger) {
                return (Builder)super.prepare(configProperties, somProperties, clientName, clientLogger);
            }

            @Override
            public Builder setAutoconnect(boolean autoconnect) {
                super.setAutoconnect(autoconnect);
                return this;
            }
        }
    }

    public static class Builder
    extends SOMProxy.Builder {
        @Override
        public TopicProxy build() {
            if (!this.setUp()) {
                return null;
            }
            return new TopicProxy(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect(), Optional.empty());
        }

        @Override
        public Builder prepare(KeyedGroups configProperties, KeyedGroups somProperties, String clientName, Logger clientLogger) {
            return (Builder)super.prepare(configProperties, somProperties, clientName, clientLogger);
        }

        @Override
        protected String getDefaultBindPrefix() {
            return "topic/";
        }
    }
}

