/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.UUID;
import org.rvpf.base.tool.Require;
import org.rvpf.base.tool.ValueConverter;

@ThreadSafe
public final class PointBinding
implements Serializable,
Comparable<PointBinding> {
    private static final long serialVersionUID = 1L;
    private final byte[] _clientUUID;
    private final String _name;
    private final transient byte[] _serverUUID;

    public PointBinding(@Nonnull String name, @Nonnull UUID clientUUID, @Nonnull Optional<UUID> serverUUID) {
        this._name = Require.notNull(name);
        this._clientUUID = clientUUID.toBytes();
        this._serverUUID = serverUUID.isPresent() ? serverUUID.get().toBytes() : null;
    }

    @Override
    public int compareTo(PointBinding other) {
        int comparison = PointBinding.compareBytes(this._serverUUID, other._serverUUID);
        if (comparison == 0) {
            comparison = PointBinding.compareBytes(this._clientUUID, other._clientUUID);
        }
        return comparison;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PointBinding) {
            return Arrays.equals(this._serverUUID, ((PointBinding)other)._serverUUID) && Arrays.equals(this._clientUUID, ((PointBinding)other)._clientUUID);
        }
        return false;
    }

    @Nonnull
    @CheckReturnValue
    public String getName() {
        return this._name;
    }

    @Nonnull
    @CheckReturnValue
    public UUID getServerUUID() {
        return UUID.fromBytes(this._serverUUID != null ? this._serverUUID : this._clientUUID);
    }

    @Nonnull
    @CheckReturnValue
    public UUID getUUID() {
        return UUID.fromBytes(this._clientUUID);
    }

    public int hashCode() {
        return Arrays.hashCode(this._serverUUID) ^ Arrays.hashCode(this._clientUUID);
    }

    public String toString() {
        return this.getName() + "[" + this.getUUID() + ":" + this.getServerUUID() + "]";
    }

    private static int compareBytes(byte[] left, byte[] right) {
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        int comparison = 0;
        for (int i = 0; i < left.length && (comparison = left[i] - right[i]) == 0; ++i) {
        }
        return comparison;
    }

    @NotThreadSafe
    public static final class Request
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Object _selection;
        private final UUID _uuid;

        Request(Object selection, UUID uuid) {
            this._selection = selection;
            this._uuid = uuid;
        }

        @Nonnull
        @CheckReturnValue
        public static Builder newBuilder() {
            return new Builder();
        }

        @Nonnull
        @CheckReturnValue
        public Optional<UUID> getClientUUID() {
            return Optional.ofNullable(this._uuid);
        }

        @Nonnull
        @CheckReturnValue
        public Optional<String> getSelectionName() {
            return this._selection instanceof String ? Optional.of((String)this._selection) : Optional.empty();
        }

        @Nonnull
        @CheckReturnValue
        public Optional<Pattern> getSelectionPattern() {
            if (this._selection == null) {
                return Optional.of(Pattern.compile(".*"));
            }
            return this._selection instanceof Pattern ? Optional.of((Pattern)this._selection) : Optional.empty();
        }

        @Nonnull
        @CheckReturnValue
        public Optional<UUID> getSelectionUUID() {
            return this._selection instanceof UUID ? Optional.of((UUID)this._selection) : Optional.empty();
        }

        Object _getSelection() {
            return this._selection;
        }

        UUID _getUUID() {
            return this._uuid;
        }

        public static final class Builder {
            private Object _selection;
            private UUID _uuid;

            Builder() {
            }

            public Builder bindTo(@Nonnull UUID uuid) {
                Require.success(this._selection instanceof String);
                this._uuid = uuid;
                return this;
            }

            public Request build() {
                return new Request(this._selection, this._uuid);
            }

            @Nonnull
            public Builder copyFrom(@Nonnull Request request) {
                this._selection = request._getSelection();
                this._uuid = request._getUUID();
                return this;
            }

            public Builder selectName(@Nonnull String name) {
                this._selection = name;
                return this;
            }

            public Builder selectPattern(@Nonnull Pattern pattern) {
                Require.equal(null, this._uuid);
                this._selection = pattern;
                return this;
            }

            public Builder selectUUID(@Nonnull UUID uuid) {
                Require.equal(null, this._uuid);
                this._selection = uuid;
                return this;
            }

            public Builder selectWild(@Nonnull String wild) {
                this.selectPattern(ValueConverter.wildToPattern(wild));
                return this;
            }
        }
    }
}

