/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.Params;
import org.rvpf.base.Point;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.UUID;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.value.PointValue;

public interface Store
extends Comparable<Store> {
    public static final String ARCHIVE_TIME_PARAM = "ArchiveTime";
    public static final String BINDING_PARAM = "Binding";
    public static final String BIND_POINTS_PARAM = "BindPoints";
    public static final String CONFIRM_PARAM = "Confirm";
    public static final String CONFIRM_RETRIES_PARAM = "ConfirmRetries";
    public static final String CONFIRM_RETRY_DELAY_PARAM = "ConfirmRetryDelay";
    public static final String DEFAULT_STORE_NAME = "Store";
    public static final String LIFE_TIME_PARAM = "LifeTime";
    public static final String NAME_PARAM = "Name";
    public static final String NULL_REMOVES_PARAM = "NullRemoves";
    public static final String PASSWORD_PARAM = "Password";
    public static final String QUEUE_PARAM = "Queue";
    public static final String RESPECT_VERSION_PARAM = "RespectVersion";
    public static final String SECURITY_PARAM = "Security";
    public static final String USER_PARAM = "User";

    @CheckReturnValue
    public boolean addQuery(@Nonnull StoreValuesQuery var1);

    public void addUpdate(@Nonnull PointValue var1);

    public void bind(@Nonnull Point var1);

    @CheckReturnValue
    public boolean canConfirm();

    public void close();

    @CheckReturnValue
    public boolean confirm(@Nonnull PointValue var1, boolean var2) throws InterruptedException, StoreAccessException;

    public void connect() throws StoreAccessException;

    @Nonnull
    @CheckReturnValue
    public StoreValues deliver(int var1, long var2) throws InterruptedException, StoreAccessException;

    @Nonnull
    @CheckReturnValue
    public Optional<Exception[]> getExceptions();

    @Nonnull
    @CheckReturnValue
    public String getName();

    @Nonnull
    @CheckReturnValue
    public Params getParams();

    @CheckReturnValue
    public int getQueriesBatchLimit();

    @CheckReturnValue
    public int getResponseLimit();

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues[]> getSubscribedValues();

    @Nonnull
    @CheckReturnValue
    public UUID getUUID();

    @CheckReturnValue
    public int getUpdateCount();

    @Nonnull
    @CheckReturnValue
    public Collection<PointValue> getUpdates();

    public void impersonate(@Nonnull Optional<String> var1) throws StoreAccessException;

    @CheckReturnValue
    public boolean isNullRemoves();

    @Nonnull
    @CheckReturnValue
    public Iterable<PointValue> iterate(@Nonnull StoreValuesQuery var1);

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues> nextValues() throws InterruptedException, StoreAccessException;

    @CheckReturnValue
    public boolean probe() throws StoreAccessException;

    @Nonnull
    @CheckReturnValue
    public StoreValues pull(@Nonnull StoreValuesQuery var1, long var2) throws InterruptedException, StoreAccessException;

    @CheckReturnValue
    public int purge(@Nonnull UUID[] var1, @Nonnull TimeInterval var2) throws StoreAccessException;

    @Nonnull
    @CheckReturnValue
    public StoreValues select(@Nonnull StoreValuesQuery var1) throws InterruptedException, StoreAccessException;

    @CheckReturnValue
    public boolean sendUpdates() throws StoreAccessException;

    @CheckReturnValue
    public boolean sendUpdates(@Nonnull Collection<PointValue> var1) throws StoreAccessException;

    @CheckReturnValue
    public boolean subscribe(@Nonnull Collection<UUID> var1) throws StoreAccessException;

    @CheckReturnValue
    public boolean subscribe(@Nonnull UUID[] var1) throws StoreAccessException;

    @Nonnull
    @CheckReturnValue
    public EnumSet<Externalizer.ValueType> supportedValueTypes() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsCount() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsDelete() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsDeliver() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsPull() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsPurge() throws StoreAccessException;

    @CheckReturnValue
    public boolean supportsSubscribe() throws StoreAccessException;

    @CheckReturnValue
    public boolean unsubscribe(@Nonnull UUID[] var1) throws StoreAccessException;
}

