/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.UUID;
import org.rvpf.base.exception.ServiceNotAvailableException;
import org.rvpf.base.rmi.SessionException;

public final class StoreAccessException
extends ServiceNotAvailableException {
    private static final long serialVersionUID = 1L;
    private final UUID _storeUUID;

    public StoreAccessException(@Nonnull Optional<UUID> storeUUID, @Nonnull SessionException cause) {
        super(cause);
        this._storeUUID = storeUUID.orElse(null);
    }

    @Override
    public synchronized SessionException getCause() {
        return (SessionException)super.getCause();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<UUID> getStoreUUID() {
        return Optional.ofNullable(this._storeUUID);
    }
}

