/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.Point;
import org.rvpf.base.Points;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.UUID;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.rmi.ServiceClosedException;
import org.rvpf.base.rmi.Session;
import org.rvpf.base.rmi.SessionClientContext;
import org.rvpf.base.rmi.SessionException;
import org.rvpf.base.rmi.SessionProxy;
import org.rvpf.base.store.PointBinding;
import org.rvpf.base.store.StoreSession;
import org.rvpf.base.store.StoreSessionFactory;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.LoginInfo;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.State;

@ThreadSafe
public final class StoreSessionProxy
extends SessionProxy
implements StoreSession {
    private static final Exception[] _EMPTY_EXCEPTIONS = new Exception[0];
    private static final StoreValues[] _EMPTY_RESPONSES = new StoreValues[0];
    private volatile Exception[] _exceptions;
    private volatile StoreValues[] _responses;
    private volatile State.Group[] _stateGroups;
    private volatile Map<String, State.Group> _stateGroupsMap;
    private volatile EnumSet<Externalizer.ValueType> _supportedValueTypes;

    StoreSessionProxy(@Nonnull String clientName, @Nonnull Optional<LoginInfo> loginInfo, @Nonnull SessionClientContext context, @Nonnull Optional<SessionProxy.Listener> listener, boolean autoconnect) {
        super(clientName, loginInfo, context, listener, autoconnect);
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public StoreValues deliver(int limit, long timeout) throws SessionException {
        try {
            this._setResponse(this._getStoreSession().deliver(limit, timeout));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getResponse().orElse(null);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Exception> getException() {
        Optional<Exception[]> exceptions = this.getExceptions();
        return exceptions.isPresent() && exceptions.get().length == 1 ? Optional.ofNullable(exceptions.get()[0]) : Optional.of(new ServiceClosedException());
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Exception[]> getExceptions() {
        Optional<StoreValues[]> responses;
        if (this._exceptions == null && (responses = this.getResponses()).isPresent()) {
            Exception[] exceptions = new Exception[responses.get().length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = responses.get()[i].getException().orElse(null);
            }
            this._exceptions = exceptions;
        }
        return Optional.of(this._exceptions);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<List<PointBinding>> getPointBindings(@Nonnull Collection<PointBinding.Request> bindingRequests) throws SessionException {
        PointBinding[] pointBindings = this.getPointBindings(bindingRequests.toArray(new PointBinding.Request[bindingRequests.size()]));
        return pointBindings != null ? Optional.of(Arrays.asList(pointBindings)) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PointBinding[]> getPointBindings(@Nonnull PointBinding.Request bindingRequest) throws SessionException {
        return Optional.ofNullable(this.getPointBindings(new PointBinding.Request[]{bindingRequest}));
    }

    @Override
    public PointBinding[] getPointBindings(PointBinding.Request[] bindingRequests) throws SessionException {
        try {
            return this._getStoreSession().getPointBindings(bindingRequests);
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues> getResponse() {
        StoreValues[] responses = this._responses;
        return responses != null && responses.length == 1 ? Optional.ofNullable(responses[0]) : Optional.empty();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues[]> getResponses() {
        return Optional.ofNullable(this._responses);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<State.Group> getStateGroup(@Nonnull Optional<String> name) throws SessionException {
        if (this._stateGroupsMap == null) {
            HashMap<String, State.Group> stateGroupMap = new HashMap<String, State.Group>();
            State.Group[] stateGroups = this.getStateGroups();
            if (stateGroups == null) {
                throw new ServiceClosedException();
            }
            for (State.Group stateGroup : stateGroups) {
                stateGroupMap.put(stateGroup.getName(), stateGroup);
            }
            this._stateGroupsMap = stateGroupMap;
        }
        return Optional.ofNullable(this._stateGroupsMap.get(name.isPresent() ? name.get().trim() : ""));
    }

    @Override
    public State.Group[] getStateGroups() throws SessionException {
        if (this._stateGroups == null) {
            try {
                this._stateGroups = this._getStoreSession().getStateGroups();
            }
            catch (Exception exception) {
                throw this.sessionException(exception);
            }
        }
        return this._stateGroups;
    }

    @Override
    public void impersonate(String user) throws SessionException {
        if (this.hasLoginInfo()) {
            try {
                this._getStoreSession().impersonate(user);
            }
            catch (Exception exception) {
                throw this.sessionException(exception);
            }
        }
    }

    @Override
    public void interrupt() throws SessionException {
        try {
            this._getStoreSession().interrupt();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public Iterable<PointValue> iterate(@Nonnull StoreValuesQuery storeQuery, @Nonnull Optional<Points> points) {
        return new ValuesIterator(storeQuery, points);
    }

    @Override
    public boolean probe() throws SessionException {
        try {
            return this._getStoreSession().probe();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public StoreValues pull(StoreValuesQuery query, long timeout) throws SessionException {
        try {
            this._setResponse(this._getStoreSession().pull(query, timeout));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getResponse().orElse(null);
    }

    @CheckReturnValue
    public int purge(@Nonnull UUID pointUUID, @Nonnull TimeInterval timeInterval) throws SessionException {
        return this.purge(new UUID[]{pointUUID}, timeInterval);
    }

    @Override
    public int purge(UUID[] pointUUIDs, TimeInterval timeInterval) throws SessionException {
        try {
            return this._getStoreSession().purge(pointUUIDs, timeInterval);
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nullable
    @CheckReturnValue
    public State resolve(@Nonnull State state) throws SessionException {
        return this.resolve(state, (UUID)null);
    }

    @Nullable
    @CheckReturnValue
    public State resolve(@Nonnull State state, @Nullable Point point) throws SessionException {
        return this.resolve(state, point != null ? point.getUUID().get() : null);
    }

    @Override
    public State resolve(State state, UUID pointUUID) throws SessionException {
        try {
            return this._getStoreSession().resolve(state, pointUUID);
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nullable
    @CheckReturnValue
    public List<StoreValues> select(@Nonnull Collection<StoreValuesQuery> queries) throws SessionException {
        StoreValues[] responses = this.select(queries.toArray(new StoreValuesQuery[queries.size()]));
        return responses != null ? Arrays.asList(responses) : null;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues> select(@Nonnull StoreValuesQuery storeQuery) throws SessionException {
        this.select(new StoreValuesQuery[]{storeQuery});
        return this.getResponse();
    }

    @Override
    public StoreValues[] select(StoreValuesQuery[] queries) throws SessionException {
        try {
            this._setResponses(this._getStoreSession().select(queries));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getResponses().orElse(null);
    }

    @Nullable
    @CheckReturnValue
    public List<StoreValues> subscribe(@Nonnull Collection<UUID> pointUUIDs) throws SessionException {
        StoreValues[] storeValues = this.subscribe(pointUUIDs.toArray(new UUID[pointUUIDs.size()]));
        return storeValues != null ? Arrays.asList(storeValues) : null;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValues> subscribe(@Nullable UUID pointUUID) throws SessionException {
        this.subscribe(new UUID[]{pointUUID});
        return this.getResponse();
    }

    @Override
    public StoreValues[] subscribe(UUID[] pointUUIDs) throws SessionException {
        try {
            this._setResponses(this._getStoreSession().subscribe(pointUUIDs));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getResponses().orElse(null);
    }

    @CheckReturnValue
    public boolean subscribeAndCheck(@Nonnull Collection<UUID> pointUUIDs, @Nonnull Logger logger) throws SessionException {
        return this.subscribeAndCheck(pointUUIDs.toArray(new UUID[pointUUIDs.size()]), logger);
    }

    @CheckReturnValue
    public boolean subscribeAndCheck(@Nonnull UUID pointUUID, @Nonnull Logger logger) throws SessionException {
        return this.subscribeAndCheck(new UUID[]{pointUUID}, logger);
    }

    @CheckReturnValue
    public boolean subscribeAndCheck(@Nonnull UUID[] pointUUIDs, @Nonnull Logger logger) throws SessionException {
        boolean success = true;
        if (pointUUIDs.length > 0) {
            StoreValues[] responses;
            if (logger.isTraceEnabled()) {
                Arrays.stream(pointUUIDs).forEach(pointUUID -> logger.trace(BaseMessages.SENDING_POINT_SUBSCRIBE, pointUUID));
            }
            if ((responses = this.subscribe(pointUUIDs)) == null) {
                return false;
            }
            for (int i = 0; i < responses.length; ++i) {
                Optional<Exception> exception = responses[i].getException();
                if (!exception.isPresent()) continue;
                logger.warn(BaseMessages.POINT_SUBSCRIBE_FAILED, pointUUIDs[i], exception.get());
                success = false;
            }
            if (success) {
                logger.trace(BaseMessages.POINT_SUBSCRIBES_SUCCEEDED, new Object[0]);
            }
        } else {
            this._setResponses(_EMPTY_RESPONSES);
        }
        return success;
    }

    @Override
    public String supportedValueTypeCodes() throws SessionException {
        try {
            return this._getStoreSession().supportedValueTypeCodes();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nonnull
    @CheckReturnValue
    public EnumSet<Externalizer.ValueType> supportedValueTypes() throws SessionException {
        if (this._supportedValueTypes == null) {
            String valueTypeCodes = this.supportedValueTypeCodes();
            this._supportedValueTypes = Externalizer.ValueType.stringToSet(valueTypeCodes);
        }
        return this._supportedValueTypes;
    }

    @Override
    public boolean supportsCount() throws SessionException {
        try {
            return this._getStoreSession().supportsCount();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public boolean supportsDelete() throws SessionException {
        try {
            return this._getStoreSession().supportsDelete();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public boolean supportsDeliver() throws SessionException {
        try {
            return this._getStoreSession().supportsDeliver();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public boolean supportsPull() throws SessionException {
        try {
            return this._getStoreSession().supportsPull();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public boolean supportsPurge() throws SessionException {
        try {
            return this._getStoreSession().supportsPurge();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Override
    public boolean supportsSubscribe() throws SessionException {
        try {
            return this._getStoreSession().supportsSubscribe();
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
    }

    @Nullable
    @CheckReturnValue
    public List<Exception> unsubscribe(@Nonnull Collection<UUID> pointUUIDs) throws SessionException {
        Exception[] exceptions = this.unsubscribe(pointUUIDs.toArray(new UUID[pointUUIDs.size()]));
        return exceptions != null ? Arrays.asList(exceptions) : null;
    }

    @Nullable
    @CheckReturnValue
    public Exception unsubscribe(@Nonnull UUID pointUUID) throws SessionException {
        Exception[] exceptions = this.unsubscribe(new UUID[]{pointUUID});
        if (exceptions == null) {
            throw new ServiceClosedException();
        }
        return exceptions[0];
    }

    @Override
    public Exception[] unsubscribe(UUID[] pointUUIDs) throws SessionException {
        try {
            this._setExceptions(this._getStoreSession().unsubscribe(pointUUIDs));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getExceptions().orElse(null);
    }

    @CheckReturnValue
    public boolean unsubscribeAndCheck(@Nonnull Collection<UUID> pointUUIDs, @Nonnull Logger logger) throws SessionException {
        return this.unsubscribeAndCheck(pointUUIDs.toArray(new UUID[pointUUIDs.size()]), logger);
    }

    @CheckReturnValue
    public boolean unsubscribeAndCheck(@Nonnull UUID pointUUID, @Nonnull Logger logger) throws SessionException {
        return this.unsubscribeAndCheck(new UUID[]{pointUUID}, logger);
    }

    @CheckReturnValue
    public boolean unsubscribeAndCheck(@Nonnull UUID[] pointUUIDs, @Nonnull Logger logger) throws SessionException {
        boolean success = true;
        if (pointUUIDs.length > 0) {
            Exception[] exceptions;
            if (logger.isTraceEnabled()) {
                Arrays.stream(pointUUIDs).forEach(pointUUID -> logger.trace(BaseMessages.SENDING_POINT_UNSUBSCRIBE, pointUUID));
            }
            if ((exceptions = this.unsubscribe(pointUUIDs)) == null) {
                return false;
            }
            for (int i = 0; i < pointUUIDs.length; ++i) {
                if (exceptions[i] == null) continue;
                logger.warn(BaseMessages.POINT_UNSUBSCRIBE_FAILED, pointUUIDs[i], exceptions[i]);
                success = false;
            }
            if (success) {
                logger.trace(BaseMessages.POINT_UNSUBSCRIBES_SUCCEEDED, new Object[0]);
            }
        } else {
            this._setExceptions(_EMPTY_EXCEPTIONS);
        }
        return success;
    }

    @Nullable
    @CheckReturnValue
    public List<Exception> update(@Nonnull Collection<PointValue> pointValues) throws SessionException {
        Exception[] exceptions = this.update(pointValues.toArray(new PointValue[pointValues.size()]));
        return exceptions != null ? Arrays.asList(exceptions) : null;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Exception> update(@Nonnull PointValue pointValue) throws SessionException {
        this.update(new PointValue[]{pointValue});
        return this.getException();
    }

    @Override
    public Exception[] update(PointValue[] pointValues) throws SessionException {
        this._setExceptions(null);
        try {
            this._setExceptions(this._getStoreSession().update(pointValues));
        }
        catch (Exception exception) {
            throw this.sessionException(exception);
        }
        return this.getExceptions().orElse(null);
    }

    @CheckReturnValue
    public boolean updateAndCheck(@Nonnull Collection<PointValue> pointValues, @Nonnull Logger logger) throws SessionException {
        return this.updateAndCheck(pointValues.toArray(new PointValue[pointValues.size()]), logger);
    }

    @CheckReturnValue
    public boolean updateAndCheck(PointValue pointValue, Logger logger) throws SessionException {
        return this.updateAndCheck(new PointValue[]{pointValue}, logger);
    }

    @CheckReturnValue
    public boolean updateAndCheck(@Nonnull PointValue[] pointValues, @Nonnull Logger logger) throws SessionException {
        boolean warned = false;
        if (pointValues.length > 0) {
            if (logger.isTraceEnabled()) {
                Arrays.stream(pointValues).forEach(update -> logger.trace(BaseMessages.SENDING_POINT_UPDATE, update));
            }
            this.update(pointValues);
            Optional<Exception[]> optionalExceptions = this.getExceptions();
            if (!optionalExceptions.isPresent()) {
                return false;
            }
            Exception[] exceptions = optionalExceptions.get();
            for (int i = 0; i < pointValues.length; ++i) {
                if (exceptions[i] == null) continue;
                logger.warn(BaseMessages.POINT_UPDATE_FAILED, pointValues[i].pointString(), exceptions[i]);
                warned = true;
            }
            if (!warned) {
                logger.trace(BaseMessages.POINT_UPDATES_SUCCEEDED, new Object[0]);
            }
        } else {
            this._setExceptions(_EMPTY_EXCEPTIONS);
        }
        return true;
    }

    @Override
    protected Session createSession() throws RemoteException, SessionException {
        return ((StoreSessionFactory)this.getFactory()).createStoreSession(this.getContextUUID(), this.getClientName());
    }

    private StoreSession _getStoreSession() throws SessionException {
        return (StoreSession)this.getSession();
    }

    private void _setExceptions(Exception[] exceptions) {
        this._exceptions = exceptions;
        this._responses = null;
    }

    private void _setResponse(StoreValues response) {
        this._setResponses(new StoreValues[]{response});
    }

    private void _setResponses(StoreValues[] responses) {
        this._responses = responses;
        this._exceptions = null;
    }

    public final class ValuesIterator
    implements Iterable<PointValue>,
    Iterator<PointValue> {
        private final Optional<Points> _points;
        private final StoreValuesQuery _storeQuery;
        private StoreValues _storeValues;
        private Iterator<PointValue> _storeValuesIterator;

        ValuesIterator(@Nonnull StoreValuesQuery storeQuery, Optional<Points> points) {
            this._storeQuery = storeQuery;
            this._points = points;
        }

        @Nonnull
        @CheckReturnValue
        public StoreValues getStoreValues() {
            return Require.notNull(this._storeValues);
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this._storeValues != null && this._storeValuesIterator.hasNext();
            while (!hasNext) {
                StoreValuesQuery storeQuery;
                if (this._storeValues == null) {
                    storeQuery = this._storeQuery;
                } else {
                    if (this._storeValues.isComplete()) break;
                    storeQuery = this._storeValues.createQuery();
                }
                try {
                    this._storeValues = StoreSessionProxy.this.select(storeQuery).orElse(null);
                }
                catch (SessionException exception) {
                    throw new StoreValuesQuery.IterationException(exception);
                }
                if (this._storeValues == null || Thread.currentThread().isInterrupted()) {
                    throw new StoreValuesQuery.IterationException(new InterruptedException());
                }
                this._storeValuesIterator = this._storeValues.iterator();
                hasNext = this._storeValuesIterator.hasNext();
            }
            return hasNext;
        }

        @Override
        public Iterator<PointValue> iterator() {
            return this;
        }

        @Override
        public PointValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Optional<Point> point = this._storeQuery.getPoint();
            PointValue pointValue = this._storeValuesIterator.next();
            if (point.isPresent()) {
                pointValue = pointValue.restore(point.get());
            } else if (this._points.isPresent()) {
                pointValue = pointValue.restore(this._points.get());
            }
            return pointValue;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Builder
    extends SessionProxy.Builder {
        @Override
        public StoreSessionProxy build() {
            if (!this.setUp()) {
                return null;
            }
            return new StoreSessionProxy(this.getClientName(), this.getLoginInfo(), this.getContext(), this.getListener(), this.isAutoconnect());
        }
    }
}

