/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.Points;
import org.rvpf.base.UUID;
import org.rvpf.base.store.StoreValuesQuery;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;
import org.rvpf.base.value.VersionedValue;

@NotThreadSafe
public final class StoreValues
extends AbstractCollection<PointValue>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private long _count = -1L;
    private Exception _exception;
    private StoreValuesQuery.Mark _mark;
    private final ArrayList<PointValue> _pointValues = new ArrayList();
    private transient StoreValuesQuery _query;

    public StoreValues() {
    }

    public StoreValues(@Nonnull Exception exception) {
        this._exception = exception;
    }

    public StoreValues(@Nonnull StoreValuesQuery query) {
        this._query = query;
    }

    @Override
    public boolean add(PointValue pointValue) {
        return this._pointValues.add(Require.notNull(pointValue));
    }

    @Override
    public void clear() {
        this._pointValues.clear();
    }

    @Nonnull
    @CheckReturnValue
    public StoreValuesQuery createQuery() {
        return this._mark.createQuery();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof StoreValues)) {
            return false;
        }
        StoreValues other = (StoreValues)object;
        if (this.size() != other.size()) {
            return false;
        }
        Iterator iterator = other.iterator();
        for (PointValue pointValue : this) {
            PointValue otherValue = (PointValue)iterator.next();
            if (!Objects.equals(pointValue.getPoint(), otherValue.getPoint())) {
                return false;
            }
            if (!Objects.equals(pointValue.getPointUUID(), otherValue.getPointUUID())) {
                return false;
            }
            if (!Objects.equals(pointValue.getStamp(), otherValue.getStamp())) {
                return false;
            }
            if (!Objects.equals(pointValue.getState(), otherValue.getState())) {
                return false;
            }
            if (Objects.equals(pointValue.getValue(), otherValue.getValue())) continue;
            return false;
        }
        return true;
    }

    @CheckReturnValue
    public long getCount() {
        return this._count;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<Exception> getException() {
        return Optional.ofNullable(this._exception);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PointValue> getFirstPointValue() {
        return this._pointValues.isEmpty() ? Optional.empty() : Optional.ofNullable(this._pointValues.get(0));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PointValue> getLastPointValue() {
        return this._pointValues.isEmpty() ? Optional.empty() : Optional.ofNullable(this._pointValues.get(this._pointValues.size() - 1));
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValuesQuery.Mark> getMark() {
        return Optional.ofNullable(this._mark);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<PointValue> getPointValue() {
        Require.failure(this._pointValues.size() > 1, (Object)"Multiples values in Response");
        return this.getFirstPointValue();
    }

    @CheckReturnValue
    public PointValue getPointValue(int index) {
        return this._pointValues.get(index);
    }

    @CheckReturnValue
    public List<PointValue> getPointValues() {
        return Collections.unmodifiableList(this._pointValues);
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValuesQuery> getQuery() {
        return Optional.ofNullable(this._query);
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @CheckReturnValue
    public boolean isComplete() {
        return this._mark == null;
    }

    @Override
    public boolean isEmpty() {
        return this._pointValues.isEmpty();
    }

    @CheckReturnValue
    public boolean isSuccess() {
        return this._exception == null;
    }

    @Override
    public ListIterator<PointValue> iterator() {
        return this._pointValues.listIterator();
    }

    @Nonnull
    @CheckReturnValue
    public Optional<StoreValuesQuery.Mark> mark(int limit) {
        Require.success(this._query == null || this._query.isPull() && this._query.getPointUUID() == null);
        if (this._mark == null && !this._pointValues.isEmpty()) {
            VersionedValue lastValue = (VersionedValue)this.getLastPointValue().get();
            StoreValuesQuery.Builder storeQueryBuilder = StoreValuesQuery.newBuilder();
            if (this._query != null) {
                storeQueryBuilder.copyFrom(this._query);
            }
            this._query = storeQueryBuilder.setPull(true).setLimit(limit).build();
            this._mark = this._query.newMark(Optional.empty(), lastValue.getVersion().after(), 0);
        }
        return Optional.ofNullable(this._mark);
    }

    public void mark(@Nonnull PointValue pointValue, int done) {
        DateTime stamp;
        if (this._query.isPull()) {
            Require.success(pointValue instanceof VersionedValue);
            stamp = ((VersionedValue)pointValue).getVersion();
        } else {
            stamp = pointValue.getStamp();
        }
        this._mark = this._query.newMark(this._query.getPointUUID(), stamp, done);
    }

    public void mark(@Nonnull Optional<UUID> pointUUID, @Nonnull DateTime stamp, int done) {
        this._mark = this._query.newMark(pointUUID, stamp, done);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        this._exception = (Exception)input.readObject();
        this._count = input.readLong();
        int valuesSize = input.readInt();
        for (int i = 0; i < valuesSize; ++i) {
            this._pointValues.add((PointValue)input.readObject());
        }
        this._mark = StoreValuesQuery.Builder.readMark(input).orElse(null);
    }

    public void restore(@Nonnull Points points) {
        ListIterator<PointValue> iterator = this._pointValues.listIterator();
        while (iterator.hasNext()) {
            PointValue pointValue = iterator.next();
            if (pointValue == null) continue;
            iterator.set(pointValue.restore(points));
        }
    }

    public void reverse() {
        Collections.reverse(this._pointValues);
    }

    public void setCount(long count) {
        this._count = count;
    }

    public void setException(@Nonnull Exception exception) {
        this._exception = exception;
    }

    public void setQuery(@Nonnull Optional<StoreValuesQuery> query) {
        this._query = query.orElse(null);
    }

    @Override
    public int size() {
        return this._pointValues.size();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getException().isPresent()) {
            stringBuilder.append("Exception: ");
            stringBuilder.append(this.getException().get());
        } else {
            stringBuilder.append("Values size: ");
            stringBuilder.append(this.size());
            stringBuilder.append(" (");
            if (this.isComplete()) {
                stringBuilder.append("complete");
            } else {
                stringBuilder.append("next: ");
                stringBuilder.append(this.getMark().get().getStamp());
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this._exception);
        output.writeLong(this._count);
        output.writeInt(this._pointValues.size());
        for (PointValue pointValue : this._pointValues) {
            output.writeObject(pointValue);
        }
        StoreValuesQuery.Builder.writeMark(Optional.ofNullable(this._mark), output);
    }
}

