/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.store;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Point;
import org.rvpf.base.PointValuesQuery;
import org.rvpf.base.Points;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.UUID;
import org.rvpf.base.store.StoreAccessException;
import org.rvpf.base.store.StoreValues;
import org.rvpf.base.sync.Sync;
import org.rvpf.base.tool.Externalizer;
import org.rvpf.base.tool.Require;
import org.rvpf.base.value.PointValue;

@ThreadSafe
public final class StoreValuesQuery
extends PointValuesQuery.Abstract
implements Serializable {
    static final int _AFTER = 2;
    static final int _ANY = 4;
    static final int _BEFORE = 8;
    static final int _COUNT = 16;
    static final int _DELETED = 32;
    static final int _EXTRAPOLATED = 64;
    static final int _FORWARD = 128;
    static final int _INTERPOLATED = 512;
    static final int _MARKED = 1024;
    static final int _MULTIPLE = 2048;
    static final int _NORMALIZED = 4096;
    static final int _PULL = 256;
    static final int _REVERSE = 8192;
    static final int _ROWS = 16384;
    static final int _SYNCED = 32768;
    static final int _VALUE = 65536;
    private static final long serialVersionUID = 1L;
    private transient boolean _cancelled;
    private final int _limit;
    private final Optional<UUID> _pointUUID;
    private final Optional<ElapsedTime> _polatorTimeLimit;
    private final int _rows;
    private final int _type;

    StoreValuesQuery(@Nonnull Optional<Point> point, @Nonnull TimeInterval interval, @Nonnull Optional<Sync> sync, @Nonnull Optional<UUID> pointUUID, int rows, int limit, @Nonnull Optional<ElapsedTime> polatorTimeLimit, int type) {
        super(point, interval, sync);
        this._pointUUID = pointUUID;
        this._rows = rows;
        this._limit = limit;
        this._polatorTimeLimit = polatorTimeLimit;
        this._type = type;
        if (this.isPolated() && !this.getInterval().isInstant()) {
            Require.success(this.getSync().isPresent());
        }
    }

    @Nonnull
    @CheckReturnValue
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StoreValuesQuery other = (StoreValuesQuery)object;
        if (!this._pointUUID.equals(other._pointUUID)) {
            return false;
        }
        if (this.getPoint().isPresent()) {
            if (!other.getPoint().isPresent()) {
                return false;
            }
            if (!Objects.equals(this.getPoint().get().getName(), other.getPoint().get().getName())) {
                return false;
            }
        } else if (other.getPoint().isPresent()) {
            return false;
        }
        if (!Objects.equals(this.getInterval(), other.getInterval())) {
            return false;
        }
        if (!Objects.equals(this._getSync(), other._getSync())) {
            return false;
        }
        return this._rows == other._rows && this._type == other._type;
    }

    @CheckReturnValue
    public int getLimit() {
        return this._limit;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<UUID> getPointUUID() {
        return this._pointUUID;
    }

    @Nonnull
    @CheckReturnValue
    public Optional<ElapsedTime> getPolatorTimeLimit() {
        return this._polatorTimeLimit;
    }

    @Nonnull
    @CheckReturnValue
    public StoreValues getResponse() throws InterruptedException, StoreAccessException {
        if (this.isCancelled()) {
            return new StoreValues(this);
        }
        return this.getPoint().get().getStore().get().select(this);
    }

    @CheckReturnValue
    public int getRows() {
        int rows = (this._type & 0x4000) == 0 ? ((this._type & 0x800) == 0 ? 1 : Integer.MAX_VALUE) : this._rows;
        return rows;
    }

    @Override
    public Optional<Sync> getSync() {
        Optional<Sync> sync = (this._type & 0x8000) == 0 ? Optional.empty() : (super.getSync().isPresent() ? super.getSync() : (this.getPoint().isPresent() ? this.getPoint().get().getSync() : Optional.empty()));
        return sync.isPresent() ? Optional.of(((Sync)sync.get()).copy()) : sync;
    }

    @CheckReturnValue
    public int getType() {
        return this._type;
    }

    @Override
    public int hashCode() {
        int hash = this._pointUUID.isPresent() ? this._pointUUID.get().hashCode() : (this.getPoint().isPresent() ? Objects.hashCode(this.getPoint().get().getName()) : 0);
        hash ^= this.getInterval().hashCode();
        hash ^= Objects.hashCode(this._getSync());
        hash ^= this._rows;
        return hash ^= this._type;
    }

    @CheckReturnValue
    public boolean isAll() {
        return (this._type & 0x4000) == 0;
    }

    @CheckReturnValue
    public boolean isAny() {
        return (this._type & 4) != 0;
    }

    @CheckReturnValue
    public boolean isCancelled() {
        return this._cancelled;
    }

    @CheckReturnValue
    public boolean isCount() {
        return (this._type & 0x10) != 0;
    }

    @Override
    public boolean isExtrapolated() {
        return (this._type & 0x40) != 0;
    }

    @CheckReturnValue
    public boolean isFixed() {
        return (this._type & 0x18000) == 0 && ((this._type & 0x4000) != 0 || !this.isMultiple());
    }

    @CheckReturnValue
    public boolean isForward() {
        return (this._type & 0x2000) == 0;
    }

    @CheckReturnValue
    public boolean isIncludeDeleted() {
        return (this._type & 0x20) != 0;
    }

    @Override
    public boolean isInterpolated() {
        return (this._type & 0x200) != 0;
    }

    @CheckReturnValue
    public boolean isMarked() {
        return (this._type & 0x400) != 0;
    }

    @CheckReturnValue
    public boolean isMultiple() {
        return (this.getType() & 0x800) != 0;
    }

    @CheckReturnValue
    public boolean isNormalized() {
        return (this._type & 0x1000) != 0;
    }

    @Override
    public boolean isNotNull() {
        return (this.getType() & 0x10000) != 0;
    }

    @Override
    public boolean isPolated() {
        return (this._type & 0x240) != 0;
    }

    @CheckReturnValue
    public boolean isPull() {
        return (this.getType() & 0x100) != 0;
    }

    @CheckReturnValue
    public boolean isReverse() {
        return (this.getType() & 0x2000) != 0;
    }

    @CheckReturnValue
    public boolean isSynced() {
        return (this.getType() & 0x8000) != 0;
    }

    @Nonnull
    @CheckReturnValue
    public Iterable<PointValue> iterate() {
        return this.getPoint().get().getStore().get().iterate(this);
    }

    @Nonnull
    @CheckReturnValue
    public Mark newMark(@Nonnull Optional<UUID> pointUUID, @Nonnull DateTime stamp, int done) {
        return new Mark(pointUUID, stamp, done);
    }

    public void setCancelled(boolean cancelled) {
        this._cancelled = cancelled;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if ((this._type & 0x110) == 0) {
            stringBuilder.append("get ");
        } else {
            if ((this._type & 0x10) != 0) {
                stringBuilder.append("count ");
            }
            if ((this._type & 0x100) != 0) {
                stringBuilder.append("pull ");
            }
        }
        if ((this._type & 0x800) != 0) {
            if ((this._type & 0x4000) != 0 && this._rows < Integer.MAX_VALUE) {
                if ((this._type & 0x2000) != 0) {
                    stringBuilder.append("last ");
                } else {
                    stringBuilder.append("first ");
                }
                stringBuilder.append(this._rows);
                stringBuilder.append(' ');
            } else {
                stringBuilder.append("all ");
            }
        } else if ((this._type & 0x2000) != 0) {
            stringBuilder.append("last ");
        } else if (!this.getInterval().isInstant()) {
            stringBuilder.append("first ");
        }
        if ((this._type & 0x10000) != 0) {
            stringBuilder.append("non null ");
        }
        if (this._pointUUID.isPresent() && this._pointUUID.get().isDeleted()) {
            stringBuilder.append("deleted ");
        }
        if ((this._type & 0x240) != 0) {
            if ((this._type & 0x200) != 0) {
                stringBuilder.append("inter");
                if ((this._type & 0x40) != 0) {
                    stringBuilder.append("/extra-");
                }
            } else {
                stringBuilder.append("extra");
            }
            stringBuilder.append("polated ");
        } else if ((this._type & 0x8000) != 0) {
            stringBuilder.append("sync ");
        }
        if ((this._type & 0x1000) != 0) {
            stringBuilder.append("normalized ");
        }
        stringBuilder.append("value");
        if ((this._type & 0x800) != 0) {
            stringBuilder.append('s');
        }
        if ((this._type & 0x20) != 0) {
            stringBuilder.append(" including deleted");
        }
        if (this._pointUUID.isPresent() || this.getPoint().isPresent()) {
            stringBuilder.append(" of '").append(this.getPoint().isPresent() ? this.getPoint().get().toString() : this._pointUUID.get().toString()).append("'");
        }
        stringBuilder.append(this.getInterval().toString());
        if (this._limit > 0) {
            stringBuilder.append(" limit ");
            stringBuilder.append(this._limit);
        }
        return stringBuilder.toString();
    }

    private Sync _getSync() {
        return super.getSync().orElse(null);
    }

    private Object writeReplace() {
        return StoreValuesQuery.newBuilder().copyFrom(this);
    }

    public final class Mark
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int _done;
        private final UUID _queryPointUUID;
        private final DateTime _stamp;

        Mark(@Nonnull Optional<UUID> pointUUID, DateTime stamp, int done) {
            this._queryPointUUID = StoreValuesQuery.this.getPointUUID().isPresent() ? null : (UUID)pointUUID.orElse(null);
            this._stamp = stamp;
            this._done = done;
        }

        @Nonnull
        @CheckReturnValue
        public StoreValuesQuery createQuery() {
            UUID pointUUID;
            Builder builder = StoreValuesQuery.newBuilder().copyFrom(StoreValuesQuery.this);
            UUID uUID = pointUUID = this._queryPointUUID == null ? (UUID)StoreValuesQuery.this.getPointUUID().orElse(null) : this._queryPointUUID;
            if (pointUUID != null) {
                builder.setPointUUID(pointUUID);
            } else {
                builder.clearPointUUID();
            }
            if (StoreValuesQuery.this.isReverse()) {
                builder.setNotAfter(this.getStamp());
            } else {
                builder.setNotBefore(this.getStamp());
            }
            if (StoreValuesQuery.this.getRows() > 0) {
                builder.setRows(StoreValuesQuery.this.getRows() - this.getDone());
            }
            builder.setMarked(true);
            return builder.build();
        }

        @CheckReturnValue
        public int getDone() {
            return this._done;
        }

        @Nonnull
        @CheckReturnValue
        public StoreValuesQuery getQuery() {
            return StoreValuesQuery.this;
        }

        @Nonnull
        @CheckReturnValue
        public Optional<UUID> getQueryPointUUID() {
            return Optional.ofNullable(this._queryPointUUID);
        }

        @Nonnull
        @CheckReturnValue
        public DateTime getStamp() {
            return this._stamp;
        }
    }

    public static final class IterationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public IterationException(@Nonnull Exception exception) {
            super(exception);
        }

        @Override
        public Exception getCause() {
            return (Exception)super.getCause();
        }
    }

    @NotThreadSafe
    public static final class Builder
    implements Externalizable {
        private static final int _FLAG_BITS = -16;
        private int _flags;
        private final TimeInterval.Builder _intervalBuilder = TimeInterval.newBuilder();
        private int _limit;
        private Point _point;
        private UUID _pointUUID;
        private ElapsedTime _polatorTimeLimit;
        private int _rows;
        private Sync _sync;

        @Nonnull
        @CheckReturnValue
        public static Optional<Mark> readMark(@Nonnull ObjectInput input) throws IOException {
            if (!input.readBoolean()) {
                return Optional.empty();
            }
            Builder queryBuilder = StoreValuesQuery.newBuilder();
            queryBuilder.readExternal(input);
            Optional<UUID> pointUUID = UUID.readExternal(input);
            DateTime stamp = DateTime.readExternal(input).get();
            int done = input.readInt();
            return Optional.of(queryBuilder.build().newMark(pointUUID, stamp, done));
        }

        public static void writeMark(@Nonnull Optional<Mark> optionalMark, @Nonnull ObjectOutput output) throws IOException {
            if (optionalMark.isPresent()) {
                Mark mark = optionalMark.get();
                output.writeBoolean(true);
                StoreValuesQuery.newBuilder().copyFrom(mark.getQuery()).writeExternal(output);
                UUID.writeExternal(mark.getQueryPointUUID(), output);
                DateTime.writeExternal(Optional.of(mark.getStamp()), output);
                output.writeInt(mark.getDone());
            } else {
                output.writeBoolean(false);
            }
        }

        @Nonnull
        @CheckReturnValue
        public StoreValuesQuery build() {
            if ((this._flags & 0x240) != 0 && !this._intervalBuilder.isInstant()) {
                this.setSynced(true);
            }
            Require.ignored(this.limit(this._rows));
            TimeInterval interval = this._intervalBuilder.build();
            int type = this._flags | 1;
            if (this._pointUUID == null && this._point == null) {
                type |= 0x104;
            }
            if (interval.getAfter().isPresent()) {
                type |= 2;
            }
            if (interval.getBefore().isPresent()) {
                type |= 8;
            }
            if ((type & 0xA) == 10) {
                type = interval.isInstant() ? (type &= 0xFFFFF7FF) : (type |= 0x800);
            } else if ((type & 0x982) == 0) {
                type |= 0x2000;
            }
            if ((this._flags & 0x4000) != 0) {
                type = this._rows <= 1 ? (type &= 0xFFFFF7FF) : (type |= 0x4800);
            } else if ((type & 0x100) != 0) {
                type |= 0x800;
            }
            if (this._sync == null && (type & 0x8000) != 0 && this._point != null && this._point.getUUID().isPresent() && !this._point.isSynced()) {
                type &= 0xFFFF7FFF;
            }
            boolean cancelled = false;
            if (this._sync != null) {
                this._intervalBuilder.trim(this._sync.getDefaultLimits());
                if ((type & 0x2000) != 0) {
                    Optional<DateTime> before = this._intervalBuilder.getBefore();
                    if (before.isPresent()) {
                        Optional<DateTime> previous = this._sync.getPreviousStamp(before.get());
                        if (previous.isPresent() && previous.get().isNotBefore(interval)) {
                            this.setBefore(previous.get().after());
                        } else {
                            cancelled = true;
                        }
                    }
                } else {
                    Optional<DateTime> after = this._intervalBuilder.getAfter();
                    if (after.isPresent()) {
                        Optional<DateTime> next = this._sync.getNextStamp(after.get());
                        if (next.isPresent() && next.get().isNotAfter(interval)) {
                            this.setAfter(next.get().before());
                        } else {
                            cancelled = true;
                        }
                    }
                }
            }
            StoreValuesQuery query = new StoreValuesQuery(Optional.ofNullable(this._point), this._intervalBuilder.build(), Optional.ofNullable(this._sync), Optional.ofNullable(this._pointUUID), this._rows, this._limit, Optional.ofNullable(this._polatorTimeLimit), type);
            query.setCancelled(cancelled);
            return query;
        }

        @Nonnull
        public Builder clear() {
            this._intervalBuilder.clear();
            this._rows = 0;
            this._flags = 0;
            this._limit = 0;
            this._sync = null;
            this._polatorTimeLimit = null;
            return this;
        }

        @Nonnull
        public Builder clearPointUUID() {
            this._point = null;
            this._pointUUID = null;
            return this;
        }

        @Nonnull
        public Builder clearSync() {
            this._sync = null;
            return this;
        }

        @Nonnull
        public Builder copyFrom(@Nonnull StoreValuesQuery storeValuesQuery) {
            this._point = storeValuesQuery.getPoint().orElse(null);
            this._pointUUID = storeValuesQuery.getPointUUID().orElse(null);
            this._intervalBuilder.copyFrom(storeValuesQuery.getInterval());
            this._rows = storeValuesQuery.getRows();
            this._flags = storeValuesQuery.getType() & 0xFFFFFFF0;
            this._limit = storeValuesQuery.getLimit();
            this._sync = storeValuesQuery.getSync().orElse(null);
            this._polatorTimeLimit = storeValuesQuery.getPolatorTimeLimit().orElse(null);
            return this;
        }

        @CheckReturnValue
        public boolean isIntervalValid() {
            return this._intervalBuilder.isValid();
        }

        @CheckReturnValue
        public boolean limit(int limit) {
            if (limit > 0 && (this._limit == 0 || this._limit > limit)) {
                this._limit = limit;
                return true;
            }
            return false;
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            Optional<String> pointName;
            this._pointUUID = UUID.readExternal(input).orElse(null);
            if (this._pointUUID == null && (pointName = Externalizer.readString(input)).isPresent()) {
                this._point = new Point.Named(pointName.get());
            }
            this._intervalBuilder.readExternal(input);
            this._rows = input.readInt();
            this._flags = input.readInt();
            this._limit = input.readInt();
            try {
                this._sync = (Sync)input.readObject();
            }
            catch (ClassNotFoundException exception) {
                throw new RuntimeException(exception);
            }
            this._polatorTimeLimit = ElapsedTime.readExternal(input).orElse(null);
        }

        @CheckReturnValue
        public boolean restore(Points points) {
            if (this._point == null) {
                if (this._pointUUID == null) {
                    return true;
                }
                this._point = points.getPointByUUID(this._pointUUID).orElse(null);
            } else {
                Optional<Point> optionalPoint = points.getPointByName(this._point.getName().orElse(null));
                if (!optionalPoint.isPresent()) {
                    return false;
                }
                this._point = optionalPoint.get();
                this._pointUUID = this._point.getUUID().get();
            }
            return true;
        }

        @Nonnull
        public Builder setAfter(@Nonnull DateTime after) {
            this._intervalBuilder.setAfter(after);
            return this;
        }

        @Nonnull
        public Builder setAll(boolean all) {
            if (all) {
                this._rows = 0;
                this._flags &= 0xFFFFBFFF;
                this._flags |= 0x800;
            } else {
                this._flags &= 0xFFFFF7FF;
            }
            return this;
        }

        @Nonnull
        public Builder setAt(@Nonnull DateTime at) {
            this._intervalBuilder.setAt(at);
            return this;
        }

        @Nonnull
        public Builder setBefore(@Nonnull DateTime before) {
            this._intervalBuilder.setBefore(before);
            return this;
        }

        @Nonnull
        public Builder setCount(boolean count) {
            this._flags = count ? (this._flags |= 0x10) : (this._flags &= 0xFFFFFFEF);
            return this;
        }

        @Nonnull
        public Builder setExtrapolated(boolean extrapolated) {
            if (extrapolated) {
                this._flags &= 0xFFFFFEDF;
                this._flags |= 0x40;
            } else {
                this._flags &= 0xFFFFFFBF;
            }
            return this;
        }

        @Nonnull
        public Builder setIncludeDeleted(boolean includeDeleted) {
            if (includeDeleted) {
                this._flags &= 0xFFFF5DBF;
                this._flags |= 0x20;
            } else {
                this._flags &= 0xFFFFFFDF;
            }
            return this;
        }

        @Nonnull
        public Builder setInterpolated(boolean interpolated) {
            if (interpolated) {
                this._flags &= 0xFFFFFEDF;
                this._flags |= 0x200;
            } else {
                this._flags &= 0xFFFFFDFF;
            }
            return this;
        }

        @Nonnull
        public Builder setInterval(@Nonnull TimeInterval interval) {
            this._intervalBuilder.copyFrom(interval);
            return this;
        }

        @Nonnull
        public Builder setLimit(int limit) {
            this._limit = limit;
            return this;
        }

        @Nonnull
        public Builder setMarked(boolean marked) {
            this._flags = marked ? (this._flags |= 0x400) : (this._flags &= 0xFFFFFBFF);
            return this;
        }

        @Nonnull
        public Builder setNormalized(boolean normalized) {
            this._flags = normalized ? (this._flags |= 0x1000) : (this._flags &= 0xFFFFEFFF);
            return this;
        }

        @Nonnull
        public Builder setNotAfter(@Nonnull DateTime notAfter) {
            this._intervalBuilder.setNotAfter(notAfter);
            return this;
        }

        @Nonnull
        public Builder setNotBefore(@Nonnull DateTime notBefore) {
            this._intervalBuilder.setNotBefore(notBefore);
            return this;
        }

        @Nonnull
        public Builder setNotNull(boolean notNull) {
            this._flags = notNull ? (this._flags |= 0x10000) : (this._flags &= 0xFFFEFFFF);
            return this;
        }

        @Nonnull
        public Builder setPoint(@Nonnull Point point) {
            this._point = point;
            this._pointUUID = point.getUUID().orElse(null);
            if (this._pointUUID != null && point.isSynced()) {
                this._flags |= 0x8000;
            }
            return this;
        }

        @Nonnull
        public Builder setPointUUID(@Nonnull UUID pointUUID) {
            this._point = null;
            this._pointUUID = Require.notNull(pointUUID);
            return this;
        }

        @Nonnull
        public Builder setPolatorTimeLimit(@Nonnull Optional<ElapsedTime> polatorTimeLimit) {
            this._polatorTimeLimit = polatorTimeLimit.orElse(null);
            return this;
        }

        @Nonnull
        public Builder setPull(boolean pull) {
            if (pull) {
                this._flags &= 0xFFFF5DBF;
                this._flags |= 0x100;
            } else {
                this._flags &= 0xFFFFFEFF;
            }
            return this;
        }

        @Nonnull
        public Builder setReverse(boolean reverse) {
            if (reverse) {
                this._flags &= 0xFFFFFE7F;
                this._flags |= 0x2000;
            } else {
                this._flags &= 0xFFFFDFFF;
                this._flags |= 0x80;
            }
            return this;
        }

        @Nonnull
        public Builder setRows(int rows) {
            if (rows <= 0) {
                this.setAll(true);
            } else {
                this._rows = rows;
                this._flags |= 0x4000;
            }
            return this;
        }

        @Nonnull
        public Builder setSync(@Nonnull Sync sync) {
            this._sync = Require.notNull(sync);
            this.setSynced(true);
            return this;
        }

        @Nonnull
        public Builder setSynced(boolean synced) {
            if (synced) {
                this._flags &= 0xFFFFFEDF;
                this._flags |= 0x8000;
            } else {
                this._flags &= 0xFFFF7FFF;
            }
            return this;
        }

        @Nonnull
        @CheckReturnValue
        public Builder unlink() {
            if (this._point != null && !(this._point instanceof Point.Named)) {
                this._point = null;
            }
            if (this._sync != null) {
                this._sync = this._sync.copy();
            }
            return this;
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            UUID.writeExternal(Optional.ofNullable(this._pointUUID), output);
            if (this._pointUUID == null) {
                Externalizer.writeString(this._point != null ? this._point.getName() : Optional.empty(), output);
            }
            this._intervalBuilder.writeExternal(output);
            output.writeInt(this._rows);
            output.writeInt(this._flags);
            output.writeInt(this._limit);
            output.writeObject(this._sync);
            ElapsedTime.writeExternal(Optional.ofNullable(this._polatorTimeLimit), output);
        }

        private Object readResolve() {
            return this.build();
        }
    }
}

