/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.DateTime;
import org.rvpf.base.tool.Require;

@Immutable
public final class Crontab {
    private static final String _ALL_VALUES = "*";
    private static final int _BEGIN_GROUP = 2;
    private static final Pattern _CRONTAB_SPLITTER = Pattern.compile("\\s");
    private static final int _DAYS_INDEX = 2;
    private static final int _DAYS_IN_MONTH = 31;
    private static final int _DAYS_IN_WEEK = 7;
    private static final int _DAYS_OF_WEEK_INDEX = 4;
    private static final int _END_GROUP = 3;
    private static final int _HOURS_INDEX = 1;
    private static final int _HOURS_IN_DAY = 24;
    private static final Pattern _ITEM_PATTERN = Pattern.compile("(\\*+|(\\d++)(?:-(\\d++))?)(?:/(\\d+))?");
    private static final Pattern _LIST_SPLITTER = Pattern.compile(",");
    private static final int _MINUTES_INDEX = 0;
    private static final int _MINUTES_IN_HOUR = 60;
    private static final int _MONTHS_INDEX = 3;
    private static final int _MONTHS_IN_YEAR = 12;
    private static final int _RANGE_GROUP = 1;
    private static final int _STEP_GROUP = 4;
    private final boolean[] _days;
    private final boolean[] _daysOfWeek;
    private final String _entry;
    private final boolean[] _hours;
    private final boolean[] _minutes;
    private final boolean[] _months;

    private Crontab(String entry, boolean[] minutes, boolean[] hours, boolean[] days, boolean[] months, boolean[] daysOfWeek) {
        this._entry = entry;
        this._minutes = minutes;
        this._hours = hours;
        this._days = days;
        this._months = months;
        this._daysOfWeek = daysOfWeek;
    }

    @Nonnull
    @CheckReturnValue
    public static Crontab parse(@Nonnull String entry) throws BadItemException {
        String[] lists = _CRONTAB_SPLITTER.split(entry.trim());
        boolean[] minutes = Crontab._parseList(Crontab._getList(lists, 0), 0, 59, false);
        boolean[] hours = Crontab._parseList(Crontab._getList(lists, 1), 0, 23, false);
        boolean[] days = Crontab._parseList(Crontab._getList(lists, 2), 1, 31, false);
        boolean[] months = Crontab._parseList(Crontab._getList(lists, 3), 1, 12, false);
        boolean[] daysOfWeek = Crontab._parseList(Crontab._getList(lists, 4), 0, 6, true);
        if (lists.length <= 4 || lists[4].equals(_ALL_VALUES)) {
            Arrays.fill(daysOfWeek, false);
        } else if (lists[2].equals(_ALL_VALUES)) {
            Arrays.fill(days, false);
        }
        return new Crontab(entry, minutes, hours, days, months, daysOfWeek);
    }

    @Nonnull
    @CheckReturnValue
    public static Crontab readExternal(@Nonnull ObjectInput input) throws IOException {
        String entry = input.readUTF();
        boolean[] minutes = Crontab._readBooleans(60, input);
        boolean[] hours = Crontab._readBooleans(24, input);
        boolean[] days = Crontab._readBooleans(31, input);
        boolean[] months = Crontab._readBooleans(12, input);
        boolean[] daysOfWeek = Crontab._readBooleans(7, input);
        return new Crontab(entry, minutes, hours, days, months, daysOfWeek);
    }

    public static void writeExternal(@Nonnull Crontab crontab, @Nonnull ObjectOutput output) throws IOException {
        output.writeUTF(crontab._entry);
        Crontab._writeBooleans(crontab._minutes, output);
        Crontab._writeBooleans(crontab._hours, output);
        Crontab._writeBooleans(crontab._days, output);
        Crontab._writeBooleans(crontab._months, output);
        Crontab._writeBooleans(crontab._daysOfWeek, output);
    }

    public DateTime change(@Nonnull DateTime dateTime, @Nonnull ZoneId zoneId, boolean forward) {
        _Pad pad = new _Pad(dateTime, zoneId, forward);
        if (!this._settle(pad)) {
            this._changeMinute(pad);
        }
        return pad.getDateTime();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Crontab)) {
            return false;
        }
        Crontab otherCrontab = (Crontab)other;
        return Arrays.equals(this._days, otherCrontab._days) && Arrays.equals(this._daysOfWeek, otherCrontab._daysOfWeek) && Arrays.equals(this._hours, otherCrontab._hours) && Arrays.equals(this._minutes, otherCrontab._minutes) && Arrays.equals(this._months, otherCrontab._months);
    }

    @Nonnull
    @CheckReturnValue
    public boolean[] getDays() {
        return this._days;
    }

    @Nonnull
    @CheckReturnValue
    public boolean[] getDaysOfWeek() {
        return this._daysOfWeek;
    }

    @Nonnull
    @CheckReturnValue
    public String getEntry() {
        return this._entry;
    }

    @Nonnull
    @CheckReturnValue
    public boolean[] getHours() {
        return this._hours;
    }

    @Nonnull
    @CheckReturnValue
    public boolean[] getMinutes() {
        return this._minutes;
    }

    @Nonnull
    @CheckReturnValue
    public boolean[] getMonths() {
        return this._months;
    }

    public int hashCode() {
        return Objects.hash(this._days, this._daysOfWeek, this._hours, this._minutes, this._months);
    }

    @CheckReturnValue
    public boolean isInSchedule(@Nonnull DateTime dateTime, @Nonnull ZoneId zoneId) {
        DateTime.Fields dateTimeFields = new DateTime.Context(zoneId).toFields(dateTime);
        return dateTimeFields.second == 0 && dateTimeFields.nano == 0 && this._minutes[dateTimeFields.minute] && this._hours[dateTimeFields.hour] && this._months[dateTimeFields.month - 1] && this._isDaySet(LocalDate.of(dateTimeFields.year, dateTimeFields.month, dateTimeFields.day));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }

    private static void _changeYear(_Pad pad) {
        pad.changeYear();
    }

    private static String _getList(String[] lists, int index) {
        if (index < lists.length) {
            return lists[index];
        }
        return _ALL_VALUES;
    }

    private static void _parseItem(String item, int origin, boolean[] mask, boolean wrap) throws BadItemException {
        Matcher matcher = _ITEM_PATTERN.matcher(item);
        int length = mask.length;
        int begin = origin;
        int end = begin + length - 1;
        int step = 1;
        if (!matcher.matches()) {
            throw new BadItemException(item);
        }
        if (!_ALL_VALUES.equals(matcher.group(1))) {
            begin = Integer.parseInt(matcher.group(2));
            if (matcher.group(3) != null) {
                end = Integer.parseInt(matcher.group(3));
            } else if (matcher.group(4) == null) {
                end = begin;
            }
        }
        if (matcher.group(4) != null) {
            step = Integer.parseInt(matcher.group(4));
        }
        if (wrap && (begin -= origin) == length) {
            begin = 0;
        }
        if (begin > (end -= origin) || begin < 0 || end == length && !wrap || end > length || step <= 0 || step >= length) {
            throw new BadItemException(item);
        }
        for (int i = begin; i <= end; i += step) {
            mask[i < length ? i : 0] = true;
        }
    }

    private static boolean[] _parseList(String list, int origin, int limit, boolean wrap) throws BadItemException {
        String[] items = _LIST_SPLITTER.split(list);
        boolean[] mask = new boolean[1 + limit - origin];
        for (String item : items) {
            if (item.isEmpty()) {
                item = _ALL_VALUES;
            }
            Crontab._parseItem(item, origin, mask, wrap);
        }
        return mask;
    }

    private static boolean[] _readBooleans(int length, ObjectInput input) throws IOException {
        boolean[] items = new boolean[length];
        for (int i = 0; i < length; ++i) {
            items[i] = input.readBoolean();
        }
        return items;
    }

    private static void _writeBooleans(boolean[] items, ObjectOutput output) throws IOException {
        for (boolean item : items) {
            output.writeBoolean(item);
        }
    }

    private void _changeDay(_Pad pad) {
        int daysInMonth = pad.getDaysInMonth();
        int day = pad.getDay();
        int dayOfWeek = pad.getDayOfWeek();
        Require.success(daysInMonth <= this._days.length);
        if (pad.isForward()) {
            while (++day < daysInMonth) {
                if (++dayOfWeek >= this._daysOfWeek.length) {
                    dayOfWeek = 0;
                }
                pad.changeDay();
                if (!this._isDaySet(pad.getLocalDate())) continue;
                this._settleMonth(pad);
                return;
            }
        } else {
            while (--day >= 0) {
                if (--dayOfWeek < 0) {
                    dayOfWeek = this._daysOfWeek.length - 1;
                }
                pad.changeDay();
                if (!this._days[day] && !this._daysOfWeek[dayOfWeek]) continue;
                this._settleMonth(pad);
                return;
            }
        }
        this._changeMonth(pad);
        pad.resetDay();
        this._settleDay(pad);
    }

    private void _changeHour(_Pad pad) {
        int hour = pad.getHour();
        if (pad.isForward()) {
            while (++hour < this._hours.length) {
                pad.changeHour();
                if (!this._hours[hour]) continue;
                this._settleDay(pad);
                return;
            }
        } else {
            while (--hour >= 0) {
                pad.changeHour();
                if (!this._hours[hour]) continue;
                this._settleDay(pad);
                return;
            }
        }
        this._changeDay(pad);
        pad.resetHour();
        this._settleHour(pad);
    }

    private void _changeMinute(_Pad pad) {
        int hour = pad.getHour();
        int minute = pad.getMinute();
        if (pad.isForward()) {
            while (++minute < this._minutes.length) {
                pad.changeMinute();
                if (pad.getHour() != hour) {
                    pad.resetMinute();
                    this._settleHour(pad);
                    this._settleMinute(pad);
                    return;
                }
                if (!this._minutes[minute]) continue;
                this._settleHour(pad);
                return;
            }
        } else {
            while (--minute >= 0) {
                pad.changeMinute();
                if (pad.getHour() != hour) {
                    this._settleHour(pad);
                    this._settleMinute(pad);
                    return;
                }
                if (!this._minutes[minute]) continue;
                this._settleHour(pad);
                return;
            }
        }
        pad.resetMinute();
        this._changeHour(pad);
        this._settleMinute(pad);
    }

    private void _changeMonth(_Pad pad) {
        int month = pad.getMonth();
        if (pad.isForward()) {
            while (++month <= this._months.length) {
                pad.changeMonth();
                if (!this._months[month - 1]) continue;
                return;
            }
        } else {
            while (--month > 0) {
                pad.changeMonth();
                if (!this._months[month - 1]) continue;
                return;
            }
        }
        Crontab._changeYear(pad);
        pad.resetMonth();
        this._settleMonth(pad);
    }

    private boolean _isDaySet(LocalDate localDate) {
        int dayOfMonth = localDate.getDayOfMonth();
        if (this._days[dayOfMonth - 1] || this._daysOfWeek[localDate.getDayOfWeek().getValue() % 7]) {
            return true;
        }
        if (dayOfMonth == localDate.lengthOfMonth()) {
            for (int i = dayOfMonth; i < this._days.length; ++i) {
                if (!this._days[i]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _settle(_Pad pad) {
        boolean settled = false;
        if (pad.getNanosecond() > 0 || pad.getSecond() > 0) {
            pad.setSecond(0);
            if (pad.isForward()) {
                pad.changeMinute();
            }
            settled = true;
        }
        settled |= this._settleMonth(pad);
        settled |= this._settleDay(pad);
        settled |= this._settleHour(pad);
        return settled |= this._settleMinute(pad);
    }

    private boolean _settleDay(_Pad pad) {
        if (this._isDaySet(pad.getLocalDate())) {
            return false;
        }
        this._changeDay(pad);
        return true;
    }

    private boolean _settleHour(_Pad pad) {
        if (this._hours[pad.getHour()]) {
            return false;
        }
        this._changeHour(pad);
        return true;
    }

    private boolean _settleMinute(_Pad pad) {
        if (this._minutes[pad.getMinute()]) {
            return false;
        }
        this._changeMinute(pad);
        return true;
    }

    private boolean _settleMonth(_Pad pad) {
        if (this._months[pad.getMonth() - 1]) {
            return false;
        }
        this._changeMonth(pad);
        return true;
    }

    private static final class _Pad {
        private ZonedDateTime _currentDateTime;
        private final boolean _forward;

        _Pad(DateTime reference, ZoneId zoneId, boolean forward) {
            this._currentDateTime = ZonedDateTime.ofInstant(reference.toInstant(), zoneId);
            this._forward = forward;
        }

        void changeDay() {
            this._currentDateTime = this._currentDateTime.plusDays(this._forward ? 1L : -1L);
        }

        void changeHour() {
            this._currentDateTime = this._currentDateTime.plusHours(this._forward ? 1L : -1L);
        }

        void changeMinute() {
            this._currentDateTime = this._currentDateTime.plusMinutes(this._forward ? 1L : -1L);
        }

        void changeMonth() {
            this._currentDateTime = this._currentDateTime.plusMonths(this._forward ? 1L : -1L);
        }

        void changeYear() {
            this._currentDateTime = this._currentDateTime.plusYears(this._forward ? 1L : -1L);
        }

        DateTime getDateTime() {
            return DateTime.fromInstant(this._currentDateTime.toInstant());
        }

        int getDay() {
            return this._currentDateTime.getDayOfMonth();
        }

        int getDayOfWeek() {
            return this._currentDateTime.getDayOfWeek().getValue() % 7;
        }

        int getDaysInMonth() {
            return this._currentDateTime.toLocalDate().lengthOfMonth();
        }

        int getHour() {
            return this._currentDateTime.getHour();
        }

        LocalDate getLocalDate() {
            return this._currentDateTime.toLocalDate();
        }

        int getMinute() {
            return this._currentDateTime.getMinute();
        }

        int getMonth() {
            return this._currentDateTime.getMonthValue();
        }

        int getNanosecond() {
            return this._currentDateTime.getNano();
        }

        int getSecond() {
            return this._currentDateTime.getSecond();
        }

        boolean isForward() {
            return this._forward;
        }

        void resetDay() {
            this._currentDateTime = this._currentDateTime.withDayOfMonth(this._forward ? 1 : this.getDaysInMonth());
        }

        void resetHour() {
            this._currentDateTime = this._currentDateTime.withHour(this._forward ? 0 : 23);
        }

        void resetMinute() {
            this._currentDateTime = this._currentDateTime.withMinute(this._forward ? 0 : 59);
        }

        void resetMonth() {
            this._currentDateTime = this._currentDateTime.withMonth(this._forward ? 1 : 12);
        }

        void setSecond(int second) {
            this._currentDateTime = this._currentDateTime.withSecond(second);
            this._currentDateTime = this._currentDateTime.withNano(0);
        }
    }

    public static final class BadItemException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadItemException(String item) {
            super(item);
        }
    }
}

