/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.ZoneId;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Params;
import org.rvpf.base.sync.Crontab;
import org.rvpf.base.sync.Sync;

@NotThreadSafe
public final class CrontabSync
extends Sync.Abstract {
    private static final long serialVersionUID = 1L;
    private Optional<Crontab> _crontab;

    public CrontabSync() {
        this._crontab = Optional.empty();
    }

    public CrontabSync(@Nonnull String entry) {
        this(entry, DateTime.getZoneId());
    }

    public CrontabSync(@Nonnull String entry, @Nonnull ZoneId zoneId) {
        super(zoneId);
        try {
            this._setCrontab(Crontab.parse(entry));
        }
        catch (Crontab.BadItemException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    private CrontabSync(CrontabSync other) {
        super(other);
        this._crontab = other._crontab;
    }

    @Override
    public Sync copy() {
        return new CrontabSync(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CrontabSync)) {
            return false;
        }
        return this._crontab.equals(((CrontabSync)object)._crontab);
    }

    @Override
    public Optional<DateTime> getNextStamp() {
        if (!this._crontab.isPresent()) {
            return Optional.empty();
        }
        this.setCurrentStamp(this._crontab.get().change(this.getCurrentStamp(), this.getZoneId(), true), 1);
        return this.nextStamp();
    }

    @Override
    public Optional<DateTime> getPreviousStamp() {
        if (!this._crontab.isPresent()) {
            return Optional.empty();
        }
        this.setCurrentStamp(this._crontab.get().change(this.getCurrentStamp(), this.getZoneId(), false), -1);
        return this.previousStamp();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInSync() {
        return this._crontab.isPresent() ? this._crontab.get().isInSchedule(this.getCurrentStamp(), this.getZoneId()) : false;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        this._setCrontab(Crontab.readExternal(input));
    }

    @Override
    public boolean setUp(Params params) {
        if (!super.setUp(params)) {
            return false;
        }
        Optional<String> entry = params.getString("Crontab");
        if (!entry.isPresent()) {
            this.getThisLogger().error(BaseMessages.MISSING_PARAMETER, "Crontab");
            return false;
        }
        return this.setUp(entry.get());
    }

    @CheckReturnValue
    public boolean setUp(String entry) {
        try {
            this._setCrontab(Crontab.parse(entry));
        }
        catch (Crontab.BadItemException exception) {
            this.getThisLogger().error(BaseMessages.BAD_CRONTAB_ENTRY, entry);
            return false;
        }
        return true;
    }

    @Override
    public void tearDown() {
        this._crontab = Optional.empty();
        super.tearDown();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._crontab.get().getEntry() + ")";
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        Crontab.writeExternal(this._crontab.get(), output);
    }

    private void _setCrontab(Crontab crontab) {
        this._crontab = Optional.of(crontab);
        this.freeze();
    }
}

