/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.ElapsedTime;
import org.rvpf.base.Params;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.logger.Message;
import org.rvpf.base.sync.Sync;

@NotThreadSafe
public final class ElapsedSync
extends Sync.Abstract {
    private static final long serialVersionUID = 1L;
    private ElapsedTime _elapsed;
    private Optional<ElapsedTime> _offset;
    private ElapsedTime _trim;

    public ElapsedSync() {
    }

    public ElapsedSync(@Nonnull ElapsedTime elapsed, @Nonnull Optional<ElapsedTime> offset) {
        this(DateTime.getZoneId(), elapsed, offset);
    }

    public ElapsedSync(@Nonnull String elapsed, @Nonnull Optional<String> offset) {
        this(DateTime.getZoneId(), elapsed, offset);
    }

    public ElapsedSync(@Nonnull ZoneId zoneId, @Nonnull ElapsedTime elapsed, @Nonnull Optional<ElapsedTime> offset) {
        super(zoneId);
        this._setElapsed(elapsed, offset);
    }

    public ElapsedSync(@Nonnull ZoneId zoneId, @Nonnull String elapsed, @Nonnull Optional<String> offset) {
        this(zoneId, ElapsedTime.fromString(elapsed), ElapsedTime.fromString(offset));
    }

    private ElapsedSync(ElapsedSync other) {
        super(other);
        this._elapsed = other._elapsed;
        this._offset = other._offset;
        this._trim = other._trim;
    }

    @Override
    public Sync copy() {
        return new ElapsedSync(this);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ElapsedSync)) {
            return false;
        }
        ElapsedSync other = (ElapsedSync)object;
        if (!(this._elapsed == null ? other._elapsed == null : this._elapsed.equals(other._elapsed))) {
            return false;
        }
        if (!this._offset.equals(other._offset)) {
            return false;
        }
        return this._trim == null ? other._trim == null : this._trim.equals(other._trim);
    }

    @Override
    public Optional<DateTime> getNextStamp() {
        return this.getNextStamp(1);
    }

    @Override
    public Optional<DateTime> getNextStamp(int intervals) {
        if (this._elapsed == null) {
            return Optional.empty();
        }
        long elapsed = this._elapsed.toRaw() * (long)intervals;
        DateTime current = this.getCurrentStamp();
        DateTime nextStamp = current.isBefore(this.getLimits()) ? this._trim(this.getLimits().getBeginning(true)) : this._trim(this._floor(current).after(elapsed));
        this.setCurrentStamp(nextStamp, 1);
        return this.nextStamp();
    }

    @Override
    public Optional<DateTime> getPreviousStamp() {
        return this.getPreviousStamp(1);
    }

    @Override
    public Optional<DateTime> getPreviousStamp(int intervals) {
        DateTime floor;
        if (this._elapsed == null) {
            return Optional.empty();
        }
        long elapsed = this._elapsed.toRaw() * (long)intervals;
        DateTime current = this.getCurrentStamp();
        DateTime previousStamp = current.isAfter(this.getLimits()) ? this._trim(this._floor(this.getLimits().getEnd(true))) : this._trim((floor = this._floor(current)).equals(current) ? floor.before(elapsed) : floor);
        this.setCurrentStamp(previousStamp, -1);
        return this.previousStamp();
    }

    public int hashCode() {
        return Objects.hash(this._elapsed, this._offset, this._trim);
    }

    @Override
    public boolean isInSync() {
        TimeInterval limits;
        DateTime current = this.getCurrentStamp();
        if (current.isBefore(limits = this.getLimits()) || current.isAfter(limits)) {
            return false;
        }
        return this._floor(current).equals(current);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        this._elapsed = ElapsedTime.readExternal(input).orElse(null);
        this._offset = ElapsedTime.readExternal(input);
        this._trim = ElapsedTime.readExternal(input).orElse(null);
    }

    @Override
    public void setLimits(TimeInterval limits) {
        if (this._trim != null) {
            DateTime end;
            TimeInterval.Builder limitsBuilder = TimeInterval.newBuilder().copyFrom(limits);
            DateTime beginning = limits.getBeginning(true);
            if (!beginning.isBeginningOfTime()) {
                if ((beginning = this._trim(beginning.after(this._trim.toRaw() - 1L))).isBefore(limits)) {
                    beginning = beginning.after(this._trim);
                }
                limitsBuilder.setNotBefore(beginning);
            }
            if (!(end = limits.getEnd(true)).isEndOfTime()) {
                limitsBuilder.setNotAfter(this._trim(end));
            }
            limits = limitsBuilder.build();
        }
        super.setLimits(limits);
    }

    @Override
    public boolean setUp(Params params) {
        if (!super.setUp(params)) {
            return false;
        }
        Optional<ElapsedTime> elapsed = params.getElapsed("Elapsed", Optional.empty(), Optional.empty());
        Optional<ElapsedTime> offset = params.getElapsed("Offset", Optional.empty(), Optional.empty());
        if (!elapsed.isPresent()) {
            this.getThisLogger().error(BaseMessages.MISSING_PARAMETER, "Elapsed");
            return false;
        }
        try {
            this._setElapsed(elapsed.get(), offset);
        }
        catch (IllegalArgumentException exception) {
            this.getThisLogger().error(BaseMessages.VERBATIM, exception.getMessage());
            return false;
        }
        this._trim = this._offset.isPresent() ? this._offset.get() : this._elapsed;
        super.setLimits(this.getDefaultLimits());
        return true;
    }

    @Override
    public void tearDown() {
        this._elapsed = null;
        this._trim = null;
        super.tearDown();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._elapsed + (this._offset.isPresent() ? ", " + this._offset.get() : "") + ")";
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        ElapsedTime.writeExternal(Optional.ofNullable(this._elapsed), output);
        ElapsedTime.writeExternal(this._offset, output);
        ElapsedTime.writeExternal(Optional.ofNullable(this._trim), output);
    }

    private DateTime _floor(DateTime current) {
        DateTime floor;
        if (this.getLimits().getBeginning(true).isBeginningOfTime()) {
            if (this.getLimits().getEnd(true).isEndOfTime()) {
                if (this._offset.isPresent()) {
                    current = current.before(this._offset.get());
                }
                floor = current.floored(this._elapsed);
                if (this._offset.isPresent()) {
                    floor = floor.after(this._offset.get());
                }
            } else {
                long offset = this.getLimits().getEnd(true).sub(current).toRaw() % this._elapsed.toRaw();
                floor = offset != 0L ? current.before(this._elapsed.toRaw() - offset) : current;
            }
        } else {
            long offset = current.sub(this.getLimits().getBeginning(true)).toRaw() % this._elapsed.toRaw();
            floor = current.before(offset);
        }
        return floor;
    }

    private void _setElapsed(ElapsedTime elapsed, Optional<ElapsedTime> offset) {
        if (elapsed.toMillis() < 1L) {
            throw new IllegalArgumentException(Message.format(BaseMessages.ELAPSED_TOO_SMALL, elapsed));
        }
        if (offset.isPresent() && offset.get().compareTo(elapsed) >= 0) {
            throw new IllegalArgumentException(Message.format(BaseMessages.OFFSET_TOO_LARGE, offset, elapsed));
        }
        this._elapsed = elapsed;
        this._offset = offset;
    }

    private DateTime _trim(DateTime stamp) {
        return this._trim != null ? stamp.floored(this._trim) : stamp;
    }
}

