/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.util.ListIterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.rvpf.base.DateTime;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.sync.Sync;

public final class ReverseSync
implements Sync {
    private static final long serialVersionUID = 1L;
    private final Sync _sync;

    public ReverseSync(@Nonnull Sync sync) {
        this._sync = sync;
    }

    private ReverseSync(ReverseSync other) {
        this._sync = other._sync.copy();
    }

    @Override
    public ReverseSync copy() {
        return new ReverseSync(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReverseSync)) {
            return false;
        }
        return this._sync.equals(((ReverseSync)other)._sync);
    }

    @Override
    public DateTime getCurrentStamp() {
        return this._sync.getCurrentStamp();
    }

    @Override
    public TimeInterval getDefaultLimits() {
        return this._sync.getDefaultLimits();
    }

    @Override
    public DateTime getFirstStamp() {
        return this._sync.getLastStamp();
    }

    @Override
    public DateTime getLastStamp() {
        return this._sync.getFirstStamp();
    }

    @Override
    public TimeInterval getLimits() {
        return this._sync.getLimits();
    }

    @Override
    public Optional<DateTime> getNextStamp() {
        return this._sync.getPreviousStamp();
    }

    @Override
    public Optional<DateTime> getNextStamp(DateTime stamp) {
        return this._sync.getPreviousStamp(stamp);
    }

    @Override
    public Optional<DateTime> getNextStamp(int intervals) {
        return this._sync.getPreviousStamp(intervals);
    }

    @Override
    public Optional<DateTime> getNextStamp(DateTime stamp, int intervals) {
        return this._sync.getPreviousStamp(stamp, intervals);
    }

    @Override
    public Optional<DateTime> getPreviousStamp() {
        return this._sync.getNextStamp();
    }

    @Override
    public Optional<DateTime> getPreviousStamp(DateTime stamp) {
        return this._sync.getNextStamp(stamp);
    }

    @Override
    public Optional<DateTime> getPreviousStamp(int intervals) {
        return this._sync.getNextStamp(intervals);
    }

    @Override
    public Optional<DateTime> getPreviousStamp(DateTime stamp, int intervals) {
        return this._sync.getNextStamp(stamp, intervals);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBounded() {
        return this._sync.isBounded();
    }

    @Override
    public boolean isInSync() {
        return this._sync.isInSync();
    }

    @Override
    public boolean isInSync(DateTime stamp) {
        return this._sync.isInSync(stamp);
    }

    @Override
    public ListIterator<DateTime> iterator() {
        return this._sync.reverseIterator();
    }

    @Override
    public ListIterator<DateTime> iterator(DateTime stamp) {
        return this._sync.reverseIterator(stamp);
    }

    @Override
    public ListIterator<DateTime> reverseIterator() {
        return this._sync.iterator();
    }

    @Override
    public ListIterator<DateTime> reverseIterator(DateTime stamp) {
        return this._sync.iterator(stamp);
    }

    @Override
    public void seed(DateTime stamp) {
        this._sync.seed(stamp);
    }

    @Override
    public void setLimits(TimeInterval limits) {
        this._sync.setLimits(limits);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._sync.toString() + ")";
    }
}

