/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Params;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.sync.Sync;

@NotThreadSafe
public final class StampsSync
extends Sync.Abstract {
    private static final long serialVersionUID = 1L;
    private long[] _rawStamps;

    public StampsSync() {
    }

    public StampsSync(DateTime[] stamps) {
        this(stamps, DateTime.getZoneId());
    }

    public StampsSync(String[] stampStrings) {
        this(stampStrings, DateTime.getZoneId());
    }

    public StampsSync(@Nonnull DateTime[] stamps, @Nonnull ZoneId zoneId) {
        super(zoneId);
        this._setStamps(stamps);
    }

    public StampsSync(@Nonnull String[] stamps, @Nonnull ZoneId zoneId) {
        super(zoneId);
        this._setStamps(stamps);
    }

    private StampsSync(StampsSync other) {
        super(other);
        this._rawStamps = other._rawStamps;
    }

    @Override
    public Sync copy() {
        return new StampsSync(this);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StampsSync)) {
            return false;
        }
        return Arrays.equals(this._rawStamps, ((StampsSync)other)._rawStamps);
    }

    @Override
    public TimeInterval getDefaultLimits() {
        TimeInterval defaultLimits;
        if (this._rawStamps.length > 0) {
            TimeInterval.Builder limitsBuilder = TimeInterval.newBuilder();
            limitsBuilder.setNotBefore(DateTime.fromRaw(this._rawStamps[0]));
            limitsBuilder.setNotAfter(DateTime.fromRaw(this._rawStamps[this._rawStamps.length - 1]));
            defaultLimits = limitsBuilder.build();
        } else {
            defaultLimits = TimeInterval.UNLIMITED;
        }
        return defaultLimits;
    }

    @Override
    public Optional<DateTime> getNextStamp() {
        int index = Arrays.binarySearch(this._rawStamps, this.getCurrentStamp().toRaw());
        int n = index = index >= 0 ? index + 1 : -index - 1;
        if (index >= this._rawStamps.length) {
            return Optional.empty();
        }
        this.setCurrentStamp(DateTime.fromRaw(this._rawStamps[index]), 1);
        return this.nextStamp();
    }

    @Override
    public Optional<DateTime> getPreviousStamp() {
        int index = Arrays.binarySearch(this._rawStamps, this.getCurrentStamp().toRaw());
        if (index < 0) {
            index = -index - 1;
        }
        if (--index < 0) {
            return Optional.empty();
        }
        this.setCurrentStamp(DateTime.fromRaw(this._rawStamps[index]), -1);
        return this.previousStamp();
    }

    public int hashCode() {
        long[] rawStamps = this._rawStamps;
        return rawStamps != null ? Arrays.hashCode(this._rawStamps) : 0;
    }

    @Override
    public boolean isInSync() {
        return Arrays.binarySearch(this._rawStamps, this.getCurrentStamp().toRaw()) >= 0;
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        super.readExternal(input);
        long[] stamps = new long[input.readInt()];
        for (int i = 0; i < stamps.length; ++i) {
            stamps[i] = input.readLong();
        }
        this._setStamps(stamps);
    }

    @Override
    public boolean setUp(Params params) {
        if (!super.setUp(params)) {
            return false;
        }
        String[] stamps = params.getStrings("Stamp");
        if (stamps.length == 0) {
            this.getThisLogger().error(BaseMessages.MISSING_PARAMETER, "Stamp");
            return false;
        }
        try {
            this._setStamps(stamps);
        }
        catch (IllegalArgumentException exception) {
            this.getThisLogger().error(BaseMessages.VERBATIM, exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void tearDown() {
        this._rawStamps = null;
        super.tearDown();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._rawStamps.length + ")";
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        super.writeExternal(output);
        output.writeInt(this._rawStamps.length);
        for (long stamp : this._rawStamps) {
            output.writeLong(stamp);
        }
    }

    private void _setStamps(DateTime[] stamps) {
        long[] raws = new long[stamps.length];
        for (int i = 0; i < raws.length; ++i) {
            raws[i] = stamps[i].toRaw();
        }
        this._setStamps(raws);
    }

    private void _setStamps(long[] rawStamps) {
        Arrays.sort(rawStamps);
        this._rawStamps = rawStamps;
        this.freeze();
    }

    private void _setStamps(String[] stampStrings) {
        DateTime.Context dateTimeContext = new DateTime.Context(this.getZoneId());
        DateTime[] stamps = new DateTime[stampStrings.length];
        for (int i = 0; i < stamps.length; ++i) {
            stamps[i] = dateTimeContext.fromString(stampStrings[i]);
        }
        this._setStamps(stamps);
    }
}

