/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.sync;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TimeZone;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.rvpf.base.BaseMessages;
import org.rvpf.base.DateTime;
import org.rvpf.base.Params;
import org.rvpf.base.TimeInterval;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.tool.Require;
import org.rvpf.base.util.container.ReverseListIterator;

public interface Sync
extends Serializable {
    public static final String CRONTAB_PARAM = "Crontab";
    public static final String ELAPSED_PARAM = "Elapsed";
    public static final String OFFSET_PARAM = "Offset";
    public static final String STAMP_PARAM = "Stamp";
    public static final String TIME_ZONE_PARAM = "TimeZone";

    @Nonnull
    @CheckReturnValue
    public Sync copy();

    @Nonnull
    @CheckReturnValue
    public DateTime getCurrentStamp();

    @Nonnull
    @CheckReturnValue
    public TimeInterval getDefaultLimits();

    @Nonnull
    @CheckReturnValue
    public DateTime getFirstStamp();

    @Nonnull
    @CheckReturnValue
    public DateTime getLastStamp();

    @Nonnull
    @CheckReturnValue
    public TimeInterval getLimits();

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNextStamp();

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNextStamp(@Nonnull DateTime var1);

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNextStamp(int var1);

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getNextStamp(@Nonnull DateTime var1, int var2);

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getPreviousStamp();

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getPreviousStamp(@Nonnull DateTime var1);

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getPreviousStamp(int var1);

    @Nonnull
    @CheckReturnValue
    public Optional<DateTime> getPreviousStamp(@Nonnull DateTime var1, int var2);

    @CheckReturnValue
    public boolean isBounded();

    @CheckReturnValue
    public boolean isInSync();

    @CheckReturnValue
    public boolean isInSync(@Nonnull DateTime var1);

    @Nonnull
    @CheckReturnValue
    public ListIterator<DateTime> iterator();

    @Nonnull
    @CheckReturnValue
    public ListIterator<DateTime> iterator(@Nonnull DateTime var1);

    @Nonnull
    @CheckReturnValue
    public ListIterator<DateTime> reverseIterator();

    @Nonnull
    @CheckReturnValue
    public ListIterator<DateTime> reverseIterator(@Nonnull DateTime var1);

    public void seed(@Nonnull DateTime var1);

    public void setLimits(@Nonnull TimeInterval var1);

    public static abstract class Abstract
    implements Sync,
    Externalizable {
        private static final long serialVersionUID = 1L;
        private DateTime _backupStamp;
        private DateTime _currentStamp;
        private transient boolean _frozen;
        private transient TimeInterval _limits;
        private ZoneId _zoneId;

        protected Abstract() {
            this(DateTime.getZoneId());
        }

        protected Abstract(@Nonnull Abstract other) {
            this._zoneId = other._zoneId;
            this._backupStamp = other._backupStamp;
            this._currentStamp = other._currentStamp;
            this._limits = other._limits;
            this._frozen = other._frozen;
        }

        protected Abstract(@Nonnull ZoneId zoneId) {
            this._zoneId = zoneId;
        }

        @Override
        public final DateTime getCurrentStamp() {
            return Require.notNull(this._currentStamp);
        }

        @Override
        public TimeInterval getDefaultLimits() {
            return TimeInterval.UNLIMITED;
        }

        @Override
        public DateTime getFirstStamp() {
            DateTime beginning = this.getLimits().getBeginning(true);
            return this.isInSync(beginning) ? beginning : this.getNextStamp(beginning).get();
        }

        @Override
        public DateTime getLastStamp() {
            DateTime end = this.getLimits().getEnd(true);
            return this.isInSync(end) ? end : this.getPreviousStamp(end).get();
        }

        @Override
        public final TimeInterval getLimits() {
            if (this._limits == null) {
                this._limits = this.getDefaultLimits();
            }
            return this._limits;
        }

        @Override
        public final Optional<DateTime> getNextStamp(DateTime stamp) {
            this.seed(stamp);
            return this.getNextStamp();
        }

        @Override
        public Optional<DateTime> getNextStamp(int intervals) {
            Optional<DateTime> stamp = Optional.empty();
            for (int i = 0; i < intervals; ++i) {
                stamp = this.getNextStamp();
            }
            return stamp;
        }

        @Override
        public final Optional<DateTime> getNextStamp(DateTime stamp, int intervals) {
            this.seed(stamp);
            return this.getNextStamp(intervals);
        }

        @Override
        public final Optional<DateTime> getPreviousStamp(DateTime stamp) {
            this.seed(stamp);
            return this.getPreviousStamp();
        }

        @Override
        public Optional<DateTime> getPreviousStamp(int intervals) {
            Optional<DateTime> stamp = Optional.empty();
            for (int i = 0; i < intervals; ++i) {
                stamp = this.getPreviousStamp();
            }
            return stamp;
        }

        @Override
        public Optional<DateTime> getPreviousStamp(DateTime stamp, int intervals) {
            this.seed(stamp);
            return this.getPreviousStamp(intervals);
        }

        @Override
        public final boolean isBounded() {
            TimeInterval limits = this.getLimits();
            return limits.isFromBeginningOfTime() && limits.isToEndOfTime();
        }

        @Override
        public final boolean isInSync(DateTime stamp) {
            this.seed(stamp);
            return this.isInSync();
        }

        @Override
        public ListIterator<DateTime> iterator() {
            return this.iterator(this.getFirstStamp());
        }

        @Override
        public ListIterator<DateTime> iterator(DateTime stamp) {
            return new _Iterator(this, stamp);
        }

        @Override
        public void readExternal(ObjectInput input) throws IOException {
            this.checkNotFrozen();
            this._zoneId = TimeZone.getTimeZone(input.readUTF()).toZoneId();
        }

        @Override
        public ListIterator<DateTime> reverseIterator() {
            return this.reverseIterator(this.getLastStamp());
        }

        @Override
        public ListIterator<DateTime> reverseIterator(DateTime stamp) {
            return new ReverseListIterator<DateTime>(new _Iterator(this, stamp));
        }

        @Override
        public final void seed(DateTime stamp) {
            this.setCurrentStamp(stamp, 0);
        }

        @Override
        public void setLimits(TimeInterval limits) {
            this._limits = limits;
        }

        @CheckReturnValue
        public boolean setUp(@Nonnull Params params) {
            this.checkNotFrozen();
            Optional<String> timeZoneParam = params.getString(Sync.TIME_ZONE_PARAM);
            if (timeZoneParam.isPresent()) {
                TimeZone timeZone = TimeZone.getTimeZone(timeZoneParam.get());
                if ("GMT".equals(timeZone.getID()) && !"GMT".equals(timeZoneParam.get())) {
                    this.getThisLogger().warn(BaseMessages.UNKNOWN_TIME_ZONE, timeZoneParam.get());
                    return false;
                }
                this.setZoneId(timeZone.toZoneId());
            } else {
                this.setZoneId(DateTime.getZoneId());
            }
            return true;
        }

        public void tearDown() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
        }

        @Override
        public void writeExternal(ObjectOutput output) throws IOException {
            output.writeUTF(TimeZone.getTimeZone(this._zoneId).getID());
        }

        protected final void checkNotFrozen() {
            Require.failure(this._frozen, (Object)BaseMessages.FROZEN);
        }

        protected final void freeze() {
            this.getLimits();
            this._frozen = true;
        }

        @Nonnull
        @CheckReturnValue
        protected final Logger getThisLogger() {
            return Logger.getInstance(this.getClass());
        }

        @Nonnull
        @CheckReturnValue
        protected final ZoneId getZoneId() {
            return this._zoneId;
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<DateTime> nextStamp() {
            DateTime stamp = this.getCurrentStamp();
            Optional<DateTime> endStamp = this.getLimits().getNotAfter();
            if (endStamp.isPresent() && stamp.isAfter(endStamp.get())) {
                this._currentStamp = this._backupStamp;
                return Optional.empty();
            }
            return Optional.of(stamp);
        }

        @Nonnull
        @CheckReturnValue
        protected final Optional<DateTime> previousStamp() {
            DateTime stamp = this.getCurrentStamp();
            Optional<DateTime> beginStamp = this.getLimits().getNotBefore();
            if (beginStamp.isPresent() && stamp.isBefore(beginStamp.get())) {
                this._currentStamp = this._backupStamp;
                return Optional.empty();
            }
            return Optional.of(stamp);
        }

        protected final void setCurrentStamp(@Nonnull DateTime stamp, int direction) {
            if (direction != 0) {
                if (direction > 0) {
                    Require.success(stamp.isAfter(this._currentStamp));
                } else {
                    Require.success(stamp.isBefore(this._currentStamp));
                }
            }
            this._backupStamp = this._currentStamp;
            this._currentStamp = stamp;
        }

        protected final void setZoneId(@Nonnull ZoneId zoneId) {
            this._zoneId = Require.notNull(zoneId);
        }

        private static class _Iterator
        implements ListIterator<DateTime> {
            private DateTime _nextStamp;
            private DateTime _previousStamp;
            private final Sync _sync;

            _Iterator(Sync sync, DateTime stamp) {
                this._sync = sync.copy();
                this._sync.seed(stamp);
            }

            @Override
            public void add(DateTime stamp) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this._previousStamp != null) {
                    this._nextStamp = this._sync.getNextStamp(this._previousStamp).orElse(null);
                    this._previousStamp = null;
                } else if (this._nextStamp == null) {
                    this._nextStamp = this._sync.getNextStamp().orElse(null);
                }
                return this._nextStamp != null;
            }

            @Override
            public boolean hasPrevious() {
                if (this._nextStamp != null) {
                    this._previousStamp = this._sync.getPreviousStamp(this._nextStamp).orElse(null);
                    this._nextStamp = null;
                } else if (this._previousStamp == null) {
                    this._previousStamp = this._sync.getPreviousStamp().orElse(null);
                }
                return this._previousStamp != null;
            }

            @Override
            public DateTime next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                DateTime nextStamp = this._nextStamp;
                this._nextStamp = null;
                return nextStamp;
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public DateTime previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                DateTime previousStamp = this._previousStamp;
                this._previousStamp = null;
                return previousStamp;
            }

            @Override
            public int previousIndex() {
                return 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(DateTime stamp) {
                throw new UnsupportedOperationException();
            }

            @Nonnull
            @CheckReturnValue
            protected final Sync getSync() {
                return this._sync;
            }
        }
    }
}

