/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.rvpf.base.tool.Require;

@NotThreadSafe
public final class Coder {
    private static final byte[] _EMPTY_BYTE_ARRAY = new byte[0];
    private ByteBuffer _byteBuffer;
    private CharBuffer _charBuffer;
    private Charset _charset = Charset.defaultCharset();
    private CharsetDecoder _decoder;
    private CharsetEncoder _encoder;

    public Coder() {
        this(StandardCharsets.UTF_8);
    }

    public Coder(@Nonnull Charset charset) {
        this.setCharset(charset);
    }

    @Nonnull
    @CheckReturnValue
    public String decode(@Nonnull byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    @Nonnull
    @CheckReturnValue
    public String decode(@Nonnull byte[] bytes, int offset, int length) {
        CoderResult result;
        if (length == 0) {
            return "";
        }
        CharsetDecoder decoder = this._getDecoder();
        ByteBuffer input = this._getByteBuffer(length);
        CharBuffer output = this._getCharBuffer((int)((float)length * decoder.averageCharsPerByte()));
        input.put(bytes, offset, length);
        input.flip();
        decoder.reset();
        while (!(result = input.hasRemaining() ? decoder.decode(input, output, true) : decoder.flush(output)).isUnderflow()) {
            if (!result.isOverflow()) continue;
            CharBuffer buffer = this._getCharBuffer(output.capacity() * 2);
            output.flip();
            buffer.put(output);
            output = buffer;
        }
        output.flip();
        return output.toString();
    }

    @Nonnull
    @CheckReturnValue
    public byte[] encode(@Nonnull String string) {
        CoderResult result;
        if (string.isEmpty()) {
            return _EMPTY_BYTE_ARRAY;
        }
        CharsetEncoder encoder = this._getEncoder();
        CharBuffer input = this._getCharBuffer(string.length());
        ByteBuffer output = this._getByteBuffer((int)((float)string.length() * encoder.averageBytesPerChar()));
        input.put(string, 0, string.length());
        input.flip();
        encoder.reset();
        while (!(result = input.hasRemaining() ? encoder.encode(input, output, true) : encoder.flush(output)).isUnderflow()) {
            if (!result.isOverflow()) continue;
            ByteBuffer buffer = this._getByteBuffer(output.capacity() * 2);
            output.flip();
            buffer.put(output);
            output = buffer;
        }
        output.flip();
        byte[] bytes = new byte[output.limit()];
        output.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Nonnull
    @CheckReturnValue
    public Charset getCharset() {
        return this._charset;
    }

    public void setCharset(@Nonnull Charset charset) {
        this._charset = Require.notNull(charset);
        this._decoder = null;
        this._encoder = null;
        this._byteBuffer = null;
        this._charBuffer = null;
    }

    private ByteBuffer _getByteBuffer(int capacity) {
        if (this._byteBuffer == null || this._byteBuffer.capacity() < capacity) {
            this._byteBuffer = ByteBuffer.allocate(capacity);
        } else {
            this._byteBuffer.clear();
        }
        return this._byteBuffer;
    }

    private CharBuffer _getCharBuffer(int capacity) {
        if (this._charBuffer == null || this._charBuffer.capacity() < capacity) {
            this._charBuffer = CharBuffer.allocate(capacity);
        } else {
            this._charBuffer.clear();
        }
        return this._charBuffer;
    }

    private CharsetDecoder _getDecoder() {
        if (this._decoder == null) {
            this._decoder = this.getCharset().newDecoder();
            this._decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this._decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this._decoder;
    }

    private CharsetEncoder _getEncoder() {
        if (this._encoder == null) {
            this._encoder = this.getCharset().newEncoder();
            this._encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this._encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return this._encoder;
    }
}

