/*
 * Decompiled with CFR 0.152.
 */
package org.rvpf.base.tool;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.rvpf.base.logger.Logger;
import org.rvpf.base.logger.Message;
import org.rvpf.base.tool.Profiler;

@Immutable
public final class Debug {
    private static final String _CLASS_NAME = Debug.class.getName();
    private final Logger _logger;
    private final StackTraceElement[] _stackTrace = Thread.currentThread().getStackTrace();

    private Debug() {
        int callerIndex = Profiler.stackTraceStartIndex(this._stackTrace, _CLASS_NAME);
        this._logger = callerIndex >= 0 ? Logger.getInstance(this._stackTrace[callerIndex].getClassName()) : Logger.getInstance(_CLASS_NAME);
    }

    public static void exit() {
        System.exit(-1);
    }

    public static void log(@Nonnull Throwable throwable) {
        new Debug()._log(throwable, "{0}", throwable.getMessage());
    }

    public static void log(@Nonnull String format, Object ... params) {
        new Debug()._log(format, params);
    }

    public static void log(@Nonnull Throwable throwable, @Nonnull String format, Object ... params) {
        new Debug()._log(throwable, format, params);
    }

    public static void logStackTrace() {
        new Debug()._logStackTrace();
    }

    public static void logStackTrace(@Nonnull Throwable throwable) {
        new Debug()._logStackTrace(throwable);
    }

    public static void logStackTrace(@Nonnull String format, Object ... params) {
        new Debug()._logStackTrace(format, params);
    }

    public static void logStackTrace(@Nonnull Throwable throwable, @Nonnull String format, Object ... params) {
        new Debug()._logStackTrace(throwable, format, params);
    }

    public static void logStackTraces() {
        new Debug()._logStackTraces();
    }

    public static void logStackTraces(@Nonnull Throwable throwable) {
        new Debug()._logStackTraces(throwable);
    }

    public static void logStackTraces(@Nonnull String format, Object ... params) {
        new Debug()._logStackTraces(format, params);
    }

    public static void logStackTraces(@Nonnull Throwable throwable, @Nonnull String format, Object ... params) {
        new Debug()._logStackTraces(throwable, format, params);
    }

    public static void print(@Nonnull String format, Object ... params) {
        System.err.println(Message.format(format, params));
    }

    public static void printStackTrace() {
        Debug.printStackTrace(System.err);
    }

    public static void printStackTrace(@Nonnull OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
        Debug.printStackTrace(printWriter);
        printWriter.flush();
    }

    public static void printStackTrace(@Nonnull PrintWriter printWriter) {
        Profiler.printStackTrace(Thread.currentThread(), Thread.currentThread().getStackTrace(), Optional.of(_CLASS_NAME), Integer.MAX_VALUE, printWriter);
    }

    public static void printStackTrace(@Nonnull String format, Object ... params) {
        Debug.print(format, params);
        Debug.printStackTrace();
    }

    public static void printStackTraces() {
        Debug.printStackTraces(System.err);
    }

    public static void printStackTraces(@Nonnull OutputStream outputStream) {
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
        Debug.printStackTraces(printWriter);
        printWriter.flush();
    }

    public static void printStackTraces(@Nonnull PrintWriter printWriter) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            Profiler.printStackTrace(entry.getKey(), entry.getValue(), Optional.of(_CLASS_NAME), Integer.MAX_VALUE, printWriter);
        }
    }

    public static void printStackTraces(@Nonnull String format, Object ... params) {
        Debug.print(format, params);
        Debug.printStackTraces();
    }

    private void _log(String format, Object ... params) {
        this._logger.log(Logger.LogLevel.DEBUG, "#" + format, params);
    }

    private void _log(Throwable throwable, String format, Object ... params) {
        this._logger.log(Logger.LogLevel.DEBUG, throwable, "#" + format, params);
    }

    private void _logStackTrace() {
        Profiler.printStackTrace(Thread.currentThread(), this._stackTrace, Optional.of(_CLASS_NAME), Integer.MAX_VALUE, this._logger.getPrintWriter(Logger.LogLevel.DEBUG));
    }

    private void _logStackTrace(Throwable throwable) {
        this._logStackTrace(throwable, "{0}", throwable);
    }

    private void _logStackTrace(String format, Object ... params) {
        this._log(format, params);
        this._logStackTrace();
    }

    private void _logStackTrace(Throwable throwable, String format, Object ... params) {
        this._log(throwable, format, params);
        this._logStackTrace();
    }

    private void _logStackTraces() {
        Debug.printStackTraces(this._logger.getPrintWriter(Logger.LogLevel.DEBUG));
    }

    private void _logStackTraces(Throwable throwable) {
        this._logStackTraces(throwable, "{0}", throwable);
    }

    private void _logStackTraces(String format, Object ... params) {
        this._log(format, params);
        this._logStackTraces();
    }

    private void _logStackTraces(Throwable throwable, String format, Object ... params) {
        this._log(throwable, format, params);
        this._logStackTraces();
    }
}

